/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.VCDiffStreamingDecoder;
import com.davidehrmann.vcdiff.engine.DeltaFileHeader;
import com.davidehrmann.vcdiff.engine.VCDiffAddressCache;
import com.davidehrmann.vcdiff.engine.VCDiffAddressCacheImpl;
import com.davidehrmann.vcdiff.engine.VCDiffCodeTableData;
import com.davidehrmann.vcdiff.engine.VCDiffDeltaFileWindow;
import com.davidehrmann.vcdiff.engine.VCDiffHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCDiffStreamingDecoderImpl
implements VCDiffStreamingDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCDiffStreamingDecoderImpl.class);
    public static final int DEFAULT_MAXIMUM_TARGET_FILE_SIZE = 0x4000000;
    public static final int TARGET_SIZE_LIMIT = Integer.MAX_VALUE;
    public static final int UNLIMITED_BYTES = -3;
    private ByteBuffer dictionary;
    private ByteBuffer unparsedBytes = ByteBuffer.allocate(0);
    private final DecoratedByteArrayOutputStream decodedTarget = new DecoratedByteArrayOutputStream(512);
    private byte vcdiffVersionCode;
    private VCDiffDeltaFileWindow deltaWindow;
    private VCDiffAddressCache addrCache;
    private VCDiffCodeTableData custom_code_table_;
    private final ByteArrayOutputStream custom_code_table_string_ = new ByteArrayOutputStream(1024);
    private VCDiffStreamingDecoderImpl custom_code_table_decoder_;
    private int plannedTargetFileSize;
    private long maximumTargetFileSize = 0x4000000L;
    private int maximumTargetWindowSize = 0x4000000;
    private long totalOfTargetWindowSizes;
    private int decodedTargetOutputPosition;
    private boolean startDecodingWasCalled;
    private boolean allowVcdTarget = true;

    public VCDiffStreamingDecoderImpl() {
        this.deltaWindow = new VCDiffDeltaFileWindow(this);
        this.reset();
    }

    public void reset() {
        this.startDecodingWasCalled = false;
        this.dictionary = null;
        this.vcdiffVersionCode = 0;
        this.plannedTargetFileSize = -3;
        this.totalOfTargetWindowSizes = 0L;
        this.addrCache = null;
        this.custom_code_table_ = null;
        this.custom_code_table_decoder_ = null;
        this.deltaWindow.Reset();
        this.decodedTargetOutputPosition = 0;
    }

    @Override
    public void startDecoding(byte[] dictionary) {
        this.startDecoding(ByteBuffer.wrap(dictionary));
    }

    @Override
    public void startDecoding(ByteBuffer dictionary) {
        if (this.startDecodingWasCalled) {
            throw new IllegalStateException("startDecoding() called twice without finishDecoding()");
        }
        this.unparsedBytes = ByteBuffer.allocate(0);
        this.decodedTarget.reset();
        this.reset();
        this.dictionary = dictionary;
        this.startDecodingWasCalled = true;
    }

    @Override
    public void decodeChunk(byte[] data, int offset, int len, OutputStream out) throws IOException {
        this.decodeChunk(ByteBuffer.wrap(data, offset, len), out);
    }

    @Override
    public void decodeChunk(ByteBuffer data, OutputStream out) throws IOException {
        if (!this.startDecodingWasCalled) {
            this.reset();
            throw new IOException("decodeChunk() called without startDecoding()");
        }
        ByteBuffer parseable_chunk = ByteBuffer.allocate(this.unparsedBytes.remaining() + data.remaining());
        parseable_chunk.put(this.unparsedBytes);
        parseable_chunk.put(data);
        parseable_chunk.flip();
        this.unparsedBytes = parseable_chunk.duplicate();
        try {
            int result = this.readDeltaFileHeader(parseable_chunk);
            if (0 == result) {
                result = this.readCustomCodeTable(parseable_chunk);
            }
            if (0 == result) {
                while (parseable_chunk.hasRemaining() && 0 == (result = this.deltaWindow.DecodeWindow(parseable_chunk)) && !this.reachedPlannedTargetFileSize()) {
                    if (this.allowVcdTarget()) continue;
                    this.flushDecodedTarget(out);
                }
            }
        }
        catch (IOException e) {
            this.reset();
            throw e;
        }
        this.unparsedBytes = parseable_chunk;
        this.appendNewOutputText(out);
    }

    @Override
    public void decodeChunk(byte[] data, OutputStream out) throws IOException {
        this.decodeChunk(ByteBuffer.wrap(data), out);
    }

    @Override
    public void finishDecoding() throws IOException {
        try {
            if (!this.startDecodingWasCalled) {
                throw new IOException("finishDecoding() called before startDecoding(), or called after decodeChunk() returned false");
            }
            if (!this.isDecodingComplete()) {
                throw new IOException("finishDecoding() called before parsing entire delta file window");
            }
        }
        finally {
            this.reset();
        }
    }

    public boolean allowInterleaved() {
        return this.vcdiffVersionCode == 83;
    }

    public boolean allowChecksum() {
        return this.vcdiffVersionCode == 83;
    }

    @Override
    public boolean setMaximumTargetFileSize(long newMaximumTargetFileSize) {
        this.maximumTargetFileSize = newMaximumTargetFileSize;
        return true;
    }

    @Override
    public boolean setMaximumTargetWindowSize(int newMaximumTargetWindowSize) {
        this.maximumTargetWindowSize = newMaximumTargetWindowSize;
        return true;
    }

    public boolean hasPlannedTargetFileSize() {
        return this.plannedTargetFileSize != -3;
    }

    public void setPlannedTargetFileSize(int planned_target_file_size) {
        this.plannedTargetFileSize = planned_target_file_size;
    }

    public void addToTotalTargetWindowSize(int window_size) {
        this.totalOfTargetWindowSizes += (long)window_size;
    }

    public boolean reachedPlannedTargetFileSize() {
        if (!this.hasPlannedTargetFileSize()) {
            return false;
        }
        if (this.totalOfTargetWindowSizes > (long)this.plannedTargetFileSize) {
            throw new IllegalStateException(String.format("Internal error: Decoded data size %d exceeds planned target file size %d", this.totalOfTargetWindowSizes, this.plannedTargetFileSize));
        }
        return this.totalOfTargetWindowSizes == (long)this.plannedTargetFileSize;
    }

    public void targetWindowWouldExceedSizeLimits(int window_size) throws IOException {
        long remaining_planned_target_file_size;
        if (window_size > this.maximumTargetWindowSize) {
            throw new IOException(String.format("Length of target window (%d) exceeds limit of %d bytes", window_size, this.maximumTargetWindowSize));
        }
        if (this.hasPlannedTargetFileSize() && (long)window_size > (remaining_planned_target_file_size = (long)this.plannedTargetFileSize - this.totalOfTargetWindowSizes)) {
            throw new IOException(String.format("Length of target window (%d bytes) plus previous windows (%d bytes) would exceed planned size of %d bytes", window_size, this.totalOfTargetWindowSizes, this.plannedTargetFileSize));
        }
        long remaining_maximum_target_bytes = this.maximumTargetFileSize - this.totalOfTargetWindowSizes;
        if ((long)window_size > remaining_maximum_target_bytes) {
            throw new IOException(String.format("Length of target window (%d bytes) plus previous windows (%d bytes) would exceed maximum target file size of %d bytes", window_size, this.totalOfTargetWindowSizes, this.maximumTargetFileSize));
        }
    }

    private int getUnconsumedDataSize() {
        return this.unparsedBytes.remaining();
    }

    private boolean isDecodingComplete() {
        if (!this.FoundFileHeader()) {
            return !this.unparsedBytes.hasRemaining();
        }
        if (this.custom_code_table_decoder_ != null) {
            return false;
        }
        if (this.deltaWindow.FoundWindowHeader()) {
            return false;
        }
        if (this.reachedPlannedTargetFileSize()) {
            return true;
        }
        return !this.unparsedBytes.hasRemaining();
    }

    public ByteBuffer dictionary_ptr() {
        return this.dictionary;
    }

    VCDiffAddressCache addrCache() {
        return this.addrCache;
    }

    DecoratedByteArrayOutputStream decodedTarget() {
        return this.decodedTarget;
    }

    public boolean allowVcdTarget() {
        return this.allowVcdTarget;
    }

    @Override
    public void setAllowVcdTarget(boolean allowVcdTarget) {
        if (this.startDecodingWasCalled) {
            throw new IllegalStateException("setAllowVcdTarget() called after startDecoding()");
        }
        this.allowVcdTarget = allowVcdTarget;
    }

    private int readDeltaFileHeader(ByteBuffer data) throws IOException {
        if (this.FoundFileHeader()) {
            return 0;
        }
        int data_size = data.remaining();
        ByteBuffer paddedHeaderData = ByteBuffer.allocate(5);
        paddedHeaderData.put((ByteBuffer)data.slice().limit(Math.min(5, data.remaining())));
        paddedHeaderData.rewind();
        DeltaFileHeader header = new DeltaFileHeader(paddedHeaderData);
        boolean wrong_magic_number = false;
        switch (data_size) {
            default: {
                this.vcdiffVersionCode = header.header4;
                if (this.vcdiffVersionCode != 0 && this.vcdiffVersionCode != 83) {
                    throw new IOException("Unrecognized VCDIFF format version");
                }
            }
            case 3: {
                if (header.header3 != -60) {
                    wrong_magic_number = true;
                }
            }
            case 2: {
                if (header.header2 != -61) {
                    wrong_magic_number = true;
                }
            }
            case 1: {
                if (header.header1 == -42) break;
                wrong_magic_number = true;
            }
            case 0: 
        }
        if (wrong_magic_number) {
            throw new IOException("Did not find VCDIFF header bytes; input is not a VCDIFF delta file");
        }
        if (data_size < 5) {
            return -2;
        }
        int unrecognizedFlags = header.hdr_indicator & 0xFF & 0xFFFFFFFC;
        if (unrecognizedFlags != 0) {
            throw new IOException(String.format("Unrecognized hdr_indicator flags: %02x", unrecognizedFlags));
        }
        if ((header.hdr_indicator & 1) != 0) {
            throw new IOException("Secondary compression is not supported");
        }
        if ((header.hdr_indicator & 2) != 0) {
            int bytes_parsed = this.InitCustomCodeTable(data.array(), data.arrayOffset() + data.position() + 5, data.remaining() - 5);
            if (bytes_parsed == -2) {
                return -2;
            }
            data.position(data.position() + 5 + bytes_parsed);
        } else {
            this.addrCache = new VCDiffAddressCacheImpl();
            data.position(data.position() + 5);
        }
        return 0;
    }

    private boolean FoundFileHeader() {
        return this.addrCache != null;
    }

    private int InitCustomCodeTable(byte[] data_start, int offset, int length) throws IOException {
        VCDiffHeaderParser header_parser = new VCDiffHeaderParser(ByteBuffer.wrap(data_start, offset, length).slice());
        Integer near_cache_size = header_parser.parseInt32("size of near cache");
        if (near_cache_size == null) {
            LOGGER.warn("Failed to parse size of near cache");
            return header_parser.getResult();
        }
        Integer same_cache_size = header_parser.parseInt32("size of same cache");
        if (same_cache_size == null) {
            LOGGER.warn("Failed to parse size of same cache");
            return header_parser.getResult();
        }
        this.custom_code_table_ = new VCDiffCodeTableData();
        this.custom_code_table_string_.reset();
        this.addrCache = new VCDiffAddressCacheImpl(near_cache_size.shortValue(), same_cache_size.shortValue());
        this.custom_code_table_decoder_ = new VCDiffStreamingDecoderImpl();
        byte[] codeTableBytes = VCDiffCodeTableData.kDefaultCodeTableData.getBytes();
        this.custom_code_table_decoder_.startDecoding(codeTableBytes);
        this.custom_code_table_decoder_.setPlannedTargetFileSize(codeTableBytes.length);
        return header_parser.unparsedData().position();
    }

    private int readCustomCodeTable(ByteBuffer data) throws IOException {
        if (this.custom_code_table_decoder_ == null) {
            return 0;
        }
        if (this.custom_code_table_ == null) {
            throw new IllegalStateException("Internal error: custom_code_table_decoder_ is set, but custom_code_table_ is null");
        }
        try {
            this.custom_code_table_decoder_.decodeChunk(data.array(), data.arrayOffset() + data.position(), data.remaining(), this.custom_code_table_string_);
        }
        catch (IOException cause) {
            IOException e = new IOException("Failed to write to custom_code_table_string_");
            e.initCause(cause);
            throw e;
        }
        if (this.custom_code_table_string_.size() < VCDiffCodeTableData.SERIALIZED_BYTE_SIZE) {
            data.position(data.limit());
            return -2;
        }
        this.custom_code_table_decoder_.finishDecoding();
        if (this.custom_code_table_string_.size() != VCDiffCodeTableData.SERIALIZED_BYTE_SIZE) {
            throw new IOException(String.format("Decoded custom code table size (%d) does not match size of a code table (%d)", this.custom_code_table_string_.size(), VCDiffCodeTableData.SERIALIZED_BYTE_SIZE));
        }
        this.custom_code_table_ = new VCDiffCodeTableData(this.custom_code_table_string_.toByteArray());
        this.custom_code_table_string_.reset();
        data.position(data.limit() - this.custom_code_table_decoder_.getUnconsumedDataSize());
        this.custom_code_table_decoder_ = null;
        this.deltaWindow.useCodeTable(this.custom_code_table_, this.addrCache.LastMode());
        return 0;
    }

    private void appendNewOutputText(OutputStream out) throws IOException {
        ByteBuffer decodedTargetBuffer = this.decodedTarget.toByteBuffer();
        decodedTargetBuffer.position(this.decodedTargetOutputPosition);
        while (decodedTargetBuffer.hasRemaining()) {
            out.write(decodedTargetBuffer.get());
        }
        this.decodedTargetOutputPosition = decodedTargetBuffer.limit();
    }

    private void flushDecodedTarget(OutputStream out) throws IOException {
        out.write(this.decodedTarget.getBuffer(), this.decodedTargetOutputPosition, this.decodedTarget.size() - this.decodedTargetOutputPosition);
        this.decodedTarget.reset();
        this.deltaWindow.setTargetWindowStartPos(0);
        this.decodedTargetOutputPosition = 0;
    }

    protected static class DecoratedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public DecoratedByteArrayOutputStream() {
        }

        public DecoratedByteArrayOutputStream(int size) {
            super(size);
        }

        public synchronized ByteBuffer toByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count).asReadOnlyBuffer();
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

