/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.engine.VCDiffAddressCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VCDiffCodeTableData
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCDiffCodeTableData.class);
    public static final int kCodeTableSize = 256;
    public static final byte VCD_NOOP = 0;
    public static final byte VCD_ADD = 1;
    public static final byte VCD_RUN = 2;
    public static final byte VCD_COPY = 3;
    protected static final byte VCD_LAST_INSTRUCTION_TYPE = 3;
    private static final byte N = 0;
    private static final byte A = 1;
    private static final byte R = 2;
    private static final byte C = 3;
    public static final byte VCD_INSTRUCTION_END_OF_DATA = 5;
    protected static final short kNoOpcode = 256;
    public static final VCDiffCodeTableData kDefaultCodeTableData = new VCDiffCodeTableData(new byte[]{2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3}, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1}, new byte[]{0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 5, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1}, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8}, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final int SERIALIZED_BYTE_SIZE = kDefaultCodeTableData.getBytes().length;
    public final byte[] inst1 = new byte[256];
    public final byte[] inst2 = new byte[256];
    public final byte[] size1 = new byte[256];
    public final byte[] size2 = new byte[256];
    public final byte[] mode1 = new byte[256];
    public final byte[] mode2 = new byte[256];
    private volatile byte[] bytes = null;

    public VCDiffCodeTableData() {
    }

    public VCDiffCodeTableData(byte[] bytes) {
        if (bytes.length != this.inst1.length + this.inst2.length + this.size1.length + this.size2.length + this.mode1.length + this.mode2.length) {
            throw new IllegalArgumentException();
        }
        int srcPos = 0;
        System.arraycopy(bytes, srcPos, this.inst1, 0, this.inst1.length);
        System.arraycopy(bytes, srcPos += this.inst1.length, this.inst2, 0, this.inst2.length);
        System.arraycopy(bytes, srcPos += this.inst2.length, this.size1, 0, this.size1.length);
        System.arraycopy(bytes, srcPos += this.size1.length, this.size2, 0, this.size2.length);
        System.arraycopy(bytes, srcPos += this.size2.length, this.mode1, 0, this.mode1.length);
        System.arraycopy(bytes, srcPos += this.mode1.length, this.mode2, 0, this.mode2.length);
        srcPos += this.mode2.length;
    }

    public VCDiffCodeTableData(byte[] inst1, byte[] inst2, byte[] size1, byte[] size2, byte[] mode1, byte[] mode2) {
        if (inst1.length != 256 || inst2.length != 256 || size1.length != 256 || size2.length != 256 || mode1.length != 256 || mode2.length != 256) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(inst1, 0, this.inst1, 0, 256);
        System.arraycopy(inst2, 0, this.inst2, 0, 256);
        System.arraycopy(size1, 0, this.size1, 0, 256);
        System.arraycopy(size2, 0, this.size2, 0, 256);
        System.arraycopy(mode1, 0, this.mode1, 0, 256);
        System.arraycopy(mode2, 0, this.mode2, 0, 256);
    }

    public VCDiffCodeTableData clone() {
        return new VCDiffCodeTableData(this.inst1, this.inst2, this.size1, this.size2, this.mode1, this.mode2);
    }

    public static String VCDiffInstructionName(int inst) {
        switch (inst) {
            case 0: {
                return "NOOP";
            }
            case 1: {
                return "ADD";
            }
            case 2: {
                return "RUN";
            }
            case 3: {
                return "COPY";
            }
        }
        return "";
    }

    protected static boolean ValidateOpcode(int opcode, short inst, short size, short mode, short max_mode, String first_or_second) {
        boolean no_errors_found = true;
        if (inst > 3 || inst < 0) {
            LOGGER.warn("VCDiff: Bad code table; opcode {} has invalid {} instruction type {}", opcode, first_or_second, inst);
            no_errors_found = false;
        }
        if (mode > max_mode || mode < 0) {
            LOGGER.warn("VCDiff: Bad code table; opcode {} has invalid {} mode {}", opcode, first_or_second, mode);
            no_errors_found = false;
        }
        if (inst == 0 && size != 0) {
            LOGGER.warn("VCDiff: Bad code table; opcode {} has {} instruction NOOP with nonzero size {}", opcode, first_or_second, size);
            no_errors_found = false;
        }
        if (size < 0) {
            LOGGER.warn("VCDiff: Bad code table; opcode {} has {} instruction with size less than zero {}", opcode, first_or_second, size);
            no_errors_found = false;
        }
        if (inst != 3 && mode != 0) {
            LOGGER.warn("VCDiff: Bad code table; opcode {} has non-COPY {} instruction with nonzero mode {}", opcode, first_or_second, mode);
            no_errors_found = false;
        }
        return no_errors_found;
    }

    protected boolean Validate(short max_mode) {
        int i;
        int kNumberOfTypesAndModes = 3 + max_mode + 1;
        boolean[] hasOpcodeForTypeAndMode = new boolean[259];
        boolean no_errors_found = true;
        for (i = 0; i < kNumberOfTypesAndModes; ++i) {
            hasOpcodeForTypeAndMode[i] = false;
        }
        for (i = 0; i < 256; ++i) {
            no_errors_found = VCDiffCodeTableData.ValidateOpcode(i, (short)(this.inst1[i] & 0xFF), (short)(this.size1[i] & 0xFF), (short)(this.mode1[i] & 0xFF), max_mode, "first") && no_errors_found;
            boolean bl = no_errors_found = VCDiffCodeTableData.ValidateOpcode(i, (short)(this.inst2[i] & 0xFF), (short)(this.size2[i] & 0xFF), (short)(this.mode2[i] & 0xFF), max_mode, "second") && no_errors_found;
            if (this.size1[i] != 0 || this.inst2[i] != 0 || (this.inst1[i] & 0xFF) + (this.mode1[i] & 0xFF) >= kNumberOfTypesAndModes) continue;
            hasOpcodeForTypeAndMode[(this.inst1[i] & 0xFF) + (this.mode1[i] & 0xFF)] = true;
        }
        for (i = 0; i < kNumberOfTypesAndModes; ++i) {
            if (i == 0 || hasOpcodeForTypeAndMode[i]) continue;
            if (i >= 3) {
                LOGGER.warn("VCDiff: Bad code table; there is no opcode for inst COPY, size 0, mode {}", (Object)(i - 3));
            } else {
                LOGGER.warn("VCDiff: Bad code table; there is no opcode for inst {}, size -,  mode 0", (Object)VCDiffCodeTableData.VCDiffInstructionName(i));
            }
            no_errors_found = false;
        }
        return no_errors_found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        if (this.bytes == null) {
            VCDiffCodeTableData vCDiffCodeTableData = this;
            synchronized (vCDiffCodeTableData) {
                if (this.bytes == null) {
                    this.bytes = new byte[this.inst1.length + this.inst2.length + this.size1.length + this.size2.length + this.mode1.length + this.mode2.length];
                    int destPos = 0;
                    System.arraycopy(this.inst1, 0, this.bytes, destPos, this.inst1.length);
                    System.arraycopy(this.inst2, 0, this.bytes, destPos += this.inst1.length, this.inst2.length);
                    System.arraycopy(this.size1, 0, this.bytes, destPos += this.inst2.length, this.size1.length);
                    System.arraycopy(this.size2, 0, this.bytes, destPos += this.size1.length, this.size2.length);
                    System.arraycopy(this.mode1, 0, this.bytes, destPos += this.size2.length, this.mode1.length);
                    System.arraycopy(this.mode2, 0, this.bytes, destPos += this.mode1.length, this.mode2.length);
                    int n = destPos + this.mode2.length;
                }
            }
        }
        return this.bytes;
    }

    protected boolean Validate() {
        return this.Validate(VCDiffAddressCache.DefaultLastMode());
    }
}

