/*
 * Decompiled with CFR 0.152.
 */
package com.davidehrmann.vcdiff.engine;

import com.davidehrmann.vcdiff.engine.VCDiffAddressCache;
import com.davidehrmann.vcdiff.util.VarInt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

class VCDiffAddressCacheImpl
extends VCDiffAddressCache {
    public VCDiffAddressCacheImpl() {
    }

    public VCDiffAddressCacheImpl(short near_cache_size, short same_cache_size) {
        super(near_cache_size, same_cache_size);
    }

    @Override
    public void Init() {
        Arrays.fill(this.near_addresses_, 0);
        Arrays.fill(this.same_addresses_, 0);
        this.next_slot_ = 0;
    }

    @Override
    public void UpdateCache(int address) {
        if (this.near_addresses_.length > 0) {
            this.near_addresses_[this.next_slot_] = address;
            this.next_slot_ = (this.next_slot_ + 1) % this.near_addresses_.length;
        }
        if (this.same_addresses_.length > 0) {
            this.same_addresses_[address % this.same_addresses_.length] = address;
        }
    }

    @Override
    public short EncodeAddress(int address, int here_address, AtomicInteger encoded_addr) {
        int same_cache_pos;
        if (address < 0) {
            encoded_addr.set(0);
            throw new IllegalArgumentException("EncodeAddress was passed a negative address: " + address);
        }
        if (address >= here_address) {
            encoded_addr.set(0);
            throw new IllegalArgumentException(String.format("EncodeAddress was called with address (%d) < here_address (%d)", address, here_address));
        }
        if (this.same_addresses_.length > 0 && this.same_addresses_[same_cache_pos = address % this.same_addresses_.length] == address) {
            this.UpdateCache(address);
            encoded_addr.set(same_cache_pos % 256);
            return (short)(this.FirstSameMode() + same_cache_pos / 256);
        }
        short best_mode = 0;
        int here_encoded_address = here_address - address;
        int best_encoded_address = address;
        if (here_encoded_address < best_encoded_address) {
            best_mode = 1;
            best_encoded_address = here_encoded_address;
        }
        for (int i = 0; i < this.near_addresses_.length; ++i) {
            int near_encoded_address = address - this.near_addresses_[i];
            if (near_encoded_address < 0 || near_encoded_address >= best_encoded_address) continue;
            best_mode = (short)(2 + i);
            best_encoded_address = near_encoded_address;
        }
        this.UpdateCache(address);
        encoded_addr.set(best_encoded_address);
        return best_mode;
    }

    private static void requireValidDecodedAddress(int decoded_address, int here_address) throws IOException {
        if (decoded_address < 0) {
            throw new IOException("Decoded address " + decoded_address + " is invalid");
        }
        if (decoded_address >= here_address) {
            throw new IOException(String.format("Decoded address (%d) is beyond location in target file (%d)", decoded_address, here_address));
        }
    }

    @Override
    public int DecodeAddress(int here_address, short vcDiffMode, ByteBuffer addressStream) throws IOException {
        int decoded_address;
        if (here_address < 0) {
            throw new IllegalStateException("DecodeAddress was passed a negative value for here_address: " + here_address);
        }
        if (addressStream.remaining() == 0) {
            return -2;
        }
        ByteBuffer duplicateAddressStream = addressStream.duplicate();
        if (this.IsSameMode(vcDiffMode)) {
            short encoded_address = (short)(duplicateAddressStream.get() & 0xFF);
            decoded_address = this.DecodeSameAddress(vcDiffMode, encoded_address);
        } else {
            int encoded_address;
            try {
                encoded_address = VarInt.getInt(duplicateAddressStream);
            }
            catch (VarInt.VarIntParseException e) {
                throw new IOException("Found invalid variable-length integer as encoded address value");
            }
            catch (VarInt.VarIntEndOfBufferException e) {
                return -2;
            }
            if (VCDiffAddressCacheImpl.IsSelfMode(vcDiffMode)) {
                decoded_address = VCDiffAddressCacheImpl.DecodeSelfAddress(encoded_address);
            } else if (VCDiffAddressCacheImpl.IsHereMode(vcDiffMode)) {
                decoded_address = VCDiffAddressCacheImpl.DecodeHereAddress(encoded_address, here_address);
            } else if (this.IsNearMode(vcDiffMode)) {
                decoded_address = this.DecodeNearAddress(vcDiffMode, encoded_address);
            } else {
                throw new IllegalArgumentException("Invalid mode value (" + vcDiffMode + ") passed to DecodeAddress; maximum mode value = " + this.LastMode());
            }
        }
        VCDiffAddressCacheImpl.requireValidDecodedAddress(decoded_address, here_address);
        this.UpdateCache(decoded_address);
        addressStream.position(duplicateAddressStream.position());
        return decoded_address;
    }
}

