/*
 * Decompiled with CFR 0.152.
 */
package com.maddwarf;

import com.maddwarf.Insults;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.NpcDespawned;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Mad Dwarf")
public class MadDwarfPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MadDwarfPlugin.class);
    @Inject
    private Client client;
    private int[] dwarfId = new int[]{322, 2408, 2409, 2429, 4305};
    public boolean kebabDropped = false;
    public boolean beerDropped = false;
    Insults insultsClass = new Insults();
    String[] insults = this.insultsClass.getInsults();

    protected void startUp() throws Exception {
        log.info("Mad Dwarf started!");
    }

    protected void shutDown() throws Exception {
        log.info("Mad Dwarf stopped!");
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        int currentTick = this.client.getTickCount();
        if ((this.kebabDropped || this.beerDropped) && currentTick % 8 == 0) {
            List npcList = this.client.getNpcs();
            for (NPC npc : npcList) {
                for (int i = 0; i < this.dwarfId.length; ++i) {
                    if (npc.getId() != this.dwarfId[i]) continue;
                    npc.setOverheadText(this.insults[this.getRandomNumber(0, this.insults.length)]);
                }
            }
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        for (int i = 0; i < this.dwarfId.length; ++i) {
            if (npc.getId() != this.dwarfId[i]) continue;
            this.kebabDropped = false;
            this.beerDropped = false;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        MenuAction menuAction = menuOptionClicked.getMenuAction();
        int itemId = menuOptionClicked.getItemId();
        MenuEntry clickedMenuEntry = menuOptionClicked.getMenuEntry();
        if (itemId == 1971 && clickedMenuEntry.getOption() == "Drop") {
            this.kebabDropped = true;
        }
        if (itemId == 1917 && clickedMenuEntry.getOption() == "Drop") {
            this.beerDropped = true;
        }
    }

    public int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }
}

