/*
 * Decompiled with CFR 0.152.
 */
package com.agilitypyramidsliderblocktimer;

import com.agilitypyramidsliderblocktimer.AgilityPyramidSliderBlockTimerConfig;
import com.agilitypyramidsliderblocktimer.AgilityPyramidSliderBlockTimerOverlay;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Agility Pyramid Slider Block Timer")
public class AgilityPyramidSliderBlockTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AgilityPyramidSliderBlockTimerPlugin.class);
    @Inject
    private Client client;
    private final Set<NPC> npcs = new HashSet<NPC>();
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AgilityPyramidSliderBlockTimerOverlay agilityPyramidSliderBlockTimerOverlay;
    @Inject
    private AgilityPyramidSliderBlockTimerConfig config;
    private static final Set<Integer> AGILITY_PYRAMID_TRAP_NPCS = ImmutableSet.of((Object)5787, (Object)5788);

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.agilityPyramidSliderBlockTimerOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.agilityPyramidSliderBlockTimerOverlay);
        this.npcs.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGIN_SCREEN: {
                this.npcs.clear();
            }
        }
    }

    @Provides
    AgilityPyramidSliderBlockTimerConfig provideConfig(ConfigManager configManager) {
        return (AgilityPyramidSliderBlockTimerConfig)configManager.getConfig(AgilityPyramidSliderBlockTimerConfig.class);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (AGILITY_PYRAMID_TRAP_NPCS.contains(npc.getId())) {
            this.npcs.add(npc);
        }
    }

    public Set<NPC> getNpcs() {
        return this.npcs;
    }
}

