/*
 * Decompiled with CFR 0.152.
 */
package com.agilitypyramidsliderblocktimer;

import com.agilitypyramidsliderblocktimer.AgilityPyramidSliderBlockTimerConfig;
import com.agilitypyramidsliderblocktimer.AgilityPyramidSliderBlockTimerPlugin;
import com.agilitypyramidsliderblocktimer.Npcs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;
import net.runelite.client.util.ColorUtil;

public class AgilityPyramidSliderBlockTimerOverlay
extends Overlay {
    private Map<Integer, Integer> trapLastPositions = new HashMap<Integer, Integer>();
    private Map<Integer, Instant> trapStartTimers = new HashMap<Integer, Instant>();
    private final Client client;
    private final AgilityPyramidSliderBlockTimerPlugin plugin;
    private final AgilityPyramidSliderBlockTimerConfig config;

    @Inject
    private AgilityPyramidSliderBlockTimerOverlay(Client client, AgilityPyramidSliderBlockTimerPlugin plugin, AgilityPyramidSliderBlockTimerConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Set<NPC> npcs = this.plugin.getNpcs();
        if (!npcs.isEmpty()) {
            Color trapHighlightColor = this.config.getSliderBlockColor();
            npcs.forEach(npc -> {
                if (Npcs.TRAP_NPC_IDS.contains(npc.getId())) {
                    Polygon tilePoly = npc.getCanvasTilePoly();
                    Integer lastTrapPosition = this.trapLastPositions.get(npc.getId());
                    WorldPoint currentPosition = npc.getWorldLocation();
                    Integer xPos = currentPosition.getX();
                    Integer yPos = currentPosition.getY();
                    String movementDimension = Npcs.TRAP_MOVEMENT_DIMENSION.get(npc.getId());
                    if (lastTrapPosition != null) {
                        Integer restingPosition = Npcs.TRAP_RESTING_POSITION.get(npc.getId());
                        boolean shouldRenderTime = false;
                        if (movementDimension.equals("x") && restingPosition.equals(xPos) || movementDimension.equals("y") && restingPosition.equals(yPos)) {
                            shouldRenderTime = true;
                        }
                        if (shouldRenderTime && tilePoly != null) {
                            if (movementDimension.equals("x") && !lastTrapPosition.equals(xPos) || movementDimension.equals("y") && !lastTrapPosition.equals(yPos)) {
                                this.trapStartTimers.put(npc.getId(), Instant.now());
                            }
                            String restingTime = Npcs.TRAP_RESTING_TIME.get(npc.getId());
                            Duration trapTime = Duration.parse(restingTime);
                            Instant timer = this.trapStartTimers.get(npc.getId());
                            if (timer == null) {
                                timer = Instant.now();
                            }
                            ProgressPieComponent progressPie = new ProgressPieComponent();
                            int xPiePos = (tilePoly.xpoints[0] + tilePoly.xpoints[2]) / 2;
                            int yPiePos = (tilePoly.ypoints[0] + tilePoly.ypoints[2]) / 2;
                            Point position = new Point(xPiePos, yPiePos);
                            Color trapBorder = ColorUtil.colorWithAlpha((Color)trapHighlightColor, (int)255);
                            progressPie.setFill(trapHighlightColor);
                            progressPie.setBorderColor(trapBorder);
                            progressPie.setPosition(position);
                            Duration duration = Duration.between(timer, Instant.now());
                            progressPie.setProgress(1.0 - (duration.compareTo(trapTime) < 0 ? (double)duration.toMillis() / (double)trapTime.toMillis() : 1.0));
                            progressPie.render(graphics);
                        }
                    }
                    if (movementDimension.equals("x")) {
                        this.trapLastPositions.put(npc.getId(), currentPosition.getX());
                    } else if (movementDimension.equals("y")) {
                        this.trapLastPositions.put(npc.getId(), currentPosition.getY());
                    }
                }
            });
        }
        return null;
    }
}

