/*
 * Decompiled with CFR 0.152.
 */
package com.maplexpbar;

import com.maplexpbar.MapleXPBarConfig;
import com.maplexpbar.MapleXPBarPlugin;
import com.maplexpbar.Viewport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.NumberFormat;
import java.util.Locale;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.SkillColor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XPBarOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(XPBarOverlay.class);
    private MapleXPBarConfig config;
    private Client client;
    private static final Logger logger = LoggerFactory.getLogger(XPBarOverlay.class);
    private static final Color BACKGROUND = new Color(0, 0, 0, 255);
    private static final int WIDTH = 512;
    static final int HEIGHT = 4;
    private static final int BORDER_SIZE = 1;
    private int currentXP;
    private int currentLevel;
    private int nextLevelXP;
    private final MapleXPBarPlugin plugin;
    private final SpriteManager spriteManager;

    @Inject
    private XPBarOverlay(Client client, MapleXPBarPlugin plugin, MapleXPBarConfig config, SkillIconManager skillIconManager, SpriteManager spriteManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.spriteManager = spriteManager;
    }

    public Dimension render(Graphics2D g) {
        if (!this.plugin.isBarsDisplayed()) {
            return null;
        }
        if (this.config.mostRecentSkill() && this.plugin.getCurrentSkill() == null) {
            return null;
        }
        Viewport curViewport = null;
        Widget curWidget = null;
        for (Viewport viewport : Viewport.values()) {
            Widget viewportWidget = this.client.getWidget(viewport.getViewport());
            if (viewportWidget == null) continue;
            curViewport = viewport;
            curWidget = viewportWidget;
            break;
        }
        if (curViewport == null) {
            return null;
        }
        boolean isChatboxUnloaded = curWidget.getCanvasLocation().equals((Object)new Point(-1, -1));
        Point offset = curViewport.getOffsetLeft();
        Point location = isChatboxUnloaded ? new Point(0, this.client.getCanvasHeight() - 165) : curWidget.getCanvasLocation();
        int chatboxHiddenOffset = curWidget.isHidden() ? 142 : 0;
        int height = 4;
        int offsetBarX = location.getX() - offset.getX();
        int offsetBarY = location.getY() - offset.getY() + chatboxHiddenOffset;
        if (this.config.displayHealthAndPrayer()) {
            this.renderThreeBars(g, offsetBarX, offsetBarY, height);
        } else {
            this.renderBar(g, offsetBarX, offsetBarY, height);
        }
        return null;
    }

    private String getTootltipText(int currentLevelXP, int nextLevelXP) {
        NumberFormat f = NumberFormat.getNumberInstance(Locale.US);
        String xpText = f.format(this.currentXP) + "/" + f.format(nextLevelXP);
        Double percentage = 100.0 * (double)(this.currentXP - currentLevelXP) / (double)(nextLevelXP - currentLevelXP);
        if (this.config.showPercentage()) {
            xpText = this.config.showOnlyPercentage() ? f.format(percentage) + "%" : xpText + " (" + f.format(percentage) + "%)";
        }
        return xpText;
    }

    public void renderBar(Graphics2D graphics, int x, int y, int height) {
        boolean hoveringBar;
        Skill skill = this.config.mostRecentSkill() ? this.plugin.getCurrentSkill() : this.config.skill();
        this.currentXP = this.client.getSkillExperience(skill);
        this.currentLevel = Experience.getLevelForXp((int)this.currentXP);
        this.nextLevelXP = Experience.getXpForLevel((int)(this.currentLevel + 1));
        int currentLevelXP = Experience.getXpForLevel((int)this.currentLevel);
        boolean isTransparentChatbox = this.client.getVarbitValue(4608) == 1;
        int adjustedX = x;
        int adjustedWidth = 512;
        if (this.client.isResized()) {
            adjustedX = x - 4;
            adjustedWidth = 519;
        }
        int[] ALL_CHATBOX_BUTTON_IDS = new int[]{10616837, 10616840, 10616844, 10616848, 10616852, 10616856, 10616860};
        boolean isChatShown = false;
        block0: for (int id : ALL_CHATBOX_BUTTON_IDS) {
            int[] BUTTON_ENABLED_IDS;
            for (int enabled_id : BUTTON_ENABLED_IDS = new int[]{3053, 3054}) {
                if (this.client.getWidget(id).getSpriteId() != enabled_id) continue;
                isChatShown = true;
                continue block0;
            }
        }
        int adjustedY = this.client.isResized() && isTransparentChatbox && isChatShown ? y + 7 : y;
        int filledWidth = XPBarOverlay.getBarWidth(this.nextLevelXP - currentLevelXP, this.currentXP - currentLevelXP, adjustedWidth);
        String xpText = this.getTootltipText(currentLevelXP, this.nextLevelXP);
        boolean bl = hoveringBar = this.client.getMouseCanvasPosition().getX() >= adjustedX && this.client.getMouseCanvasPosition().getY() >= adjustedY && this.client.getMouseCanvasPosition().getX() <= adjustedX + adjustedWidth && this.client.getMouseCanvasPosition().getY() <= adjustedY + 4;
        if (hoveringBar) {
            graphics.drawString(xpText, adjustedWidth / 2 + 8 - xpText.length() * 3, adjustedY);
        }
        Color barColor = this.config.mostRecentSkillColor() ? SkillColor.find((Skill)this.plugin.getCurrentSkill()).getColor() : this.config.colorXP();
        this.drawBar(graphics, adjustedX, adjustedY, adjustedWidth, filledWidth, barColor, this.config.colorXPNotches());
    }

    public void renderThreeBars(Graphics2D graphics, int x, int y, int height) {
        boolean hoveringBar;
        Skill skill = this.config.mostRecentSkill() ? this.plugin.getCurrentSkill() : this.config.skill();
        this.currentXP = this.client.getSkillExperience(skill);
        this.currentLevel = Experience.getLevelForXp((int)this.currentXP);
        this.nextLevelXP = Experience.getXpForLevel((int)(this.currentLevel + 1));
        int currentLevelXP = Experience.getXpForLevel((int)this.currentLevel);
        int currentHP = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        int maxHP = this.client.getRealSkillLevel(Skill.HITPOINTS);
        int currentPray = this.client.getBoostedSkillLevel(Skill.PRAYER);
        int maxPray = this.client.getRealSkillLevel(Skill.PRAYER);
        boolean isTransparentChatbox = this.client.getVarbitValue(4608) == 1;
        int adjustedX = x;
        int adjustedWidth = 512;
        if (this.client.isResized()) {
            adjustedX = x - 4;
            adjustedWidth = 519;
        }
        int adjustedY = this.client.isResized() && isTransparentChatbox ? y + 7 : y;
        int filledWidthXP = XPBarOverlay.getBarWidth(this.nextLevelXP - currentLevelXP, this.currentXP - currentLevelXP, adjustedWidth);
        int filledWidthHP = XPBarOverlay.getBarWidth(maxHP, currentHP, adjustedWidth);
        int filledWidthPray = XPBarOverlay.getBarWidth(maxPray, currentPray, adjustedWidth);
        String xpText = this.getTootltipText(currentLevelXP, this.nextLevelXP);
        boolean bl = hoveringBar = this.client.getMouseCanvasPosition().getX() >= adjustedX && this.client.getMouseCanvasPosition().getY() >= adjustedY && this.client.getMouseCanvasPosition().getX() <= adjustedX + adjustedWidth && this.client.getMouseCanvasPosition().getY() <= adjustedY + 4;
        if (hoveringBar) {
            graphics.drawString(xpText, adjustedWidth / 2 + 8 - xpText.length() * 3, adjustedY - 8);
        }
        this.drawBar(graphics, adjustedX, adjustedY, adjustedWidth, filledWidthXP, this.config.colorXP(), this.config.colorXPNotches());
        this.drawBar(graphics, adjustedX, adjustedY - 4, adjustedWidth, filledWidthPray, this.config.colorPray(), this.config.colorPrayNotches());
        this.drawBar(graphics, adjustedX, adjustedY - 8, adjustedWidth, filledWidthHP, this.config.colorHP(), this.config.colorHPNotches());
    }

    private void drawBar(Graphics graphics, int adjustedX, int adjustedY, int adjustedWidth, int fill, Color barColor, Color notchColor) {
        graphics.setColor(BACKGROUND);
        graphics.drawRect(adjustedX, adjustedY, adjustedWidth - 1, 3);
        graphics.fillRect(adjustedX, adjustedY, adjustedWidth, 4);
        graphics.setColor(barColor);
        graphics.fillRect(adjustedX + 1, adjustedY + 1, fill - 2, 2);
        graphics.setColor(notchColor);
        graphics.fillRect(adjustedX + 1 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
        graphics.fillRect(adjustedX + 2 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
        graphics.fillRect(adjustedX + 3 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
        graphics.fillRect(adjustedX + 4 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
        graphics.fillRect(adjustedX + 5 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
        graphics.fillRect(adjustedX + 6 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
        graphics.fillRect(adjustedX + 7 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
        graphics.fillRect(adjustedX + 8 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
        graphics.fillRect(adjustedX + 9 * (adjustedWidth / 10), adjustedY + 1, 2, 2);
    }

    private static int getBarWidth(int base, int current, int size) {
        double ratio = (double)current / (double)base;
        if (ratio >= 1.0) {
            return size;
        }
        return (int)Math.round(ratio * (double)size);
    }
}

