/*
 * Decompiled with CFR 0.152.
 */
package com.WintertodtSoloHelper;

import com.WintertodtSoloHelper.BrazierLocation;
import com.WintertodtSoloHelper.BrazierStatus;
import com.WintertodtSoloHelper.PermanentGameObject;
import com.WintertodtSoloHelper.WintertodtActivity;
import com.WintertodtSoloHelper.WintertodtBrazier;
import com.WintertodtSoloHelper.WintertodtSoloHelperConfig;
import com.WintertodtSoloHelper.WintertodtSoloHelperOverlay;
import com.google.common.collect.Lists;
import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wintertodt Solo Helper", description="Helpful Highlighting and data for Wintertodt Soloers", tags={"minigame", "firemaking", "boss"})
public class WintertodtSoloHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WintertodtSoloHelperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private WintertodtSoloHelperOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WintertodtSoloHelperConfig config;
    private static final int WINTERTODT_REGION_ID = 6462;
    public static final int WINTERTODT_WIDGET_GROUP_ID = 396;
    private static final int WINTERTODT_HEALTH_WIDGET_ID = 21;
    private static final int WINTERTODT_POINTS_WIDGET_ID = 7;
    private static final int HAMMER_CRATE = 29316;
    private static final int KNIFE_CRATE = 29317;
    private static final int POTION_CRATE = 29320;
    private static final int TINDERBOX_CRATE = 29319;
    private static final int UNLIT_BRAZIER = 29312;
    private static final int BROKEN_BRAZIER = 29313;
    private static final int LIT_BRAZIER = 29314;
    private static final int BRUMA_ROOTS = 29311;
    private static final int PYROMANCER = 7372;
    private static final int DEAD_PYROMANCER = 7371;
    private WintertodtBrazier SouthEast = new WintertodtBrazier(BrazierLocation.SouthEast);
    private WintertodtBrazier SouthWest = new WintertodtBrazier(BrazierLocation.SouthWest);
    private WintertodtBrazier NorthEast = new WintertodtBrazier(BrazierLocation.NorthEast);
    private WintertodtBrazier NorthWest = new WintertodtBrazier(BrazierLocation.NorthWest);
    private List<WintertodtBrazier> braziers = Lists.newArrayList((Object[])new WintertodtBrazier[]{this.SouthEast, this.SouthWest, this.NorthEast, this.NorthWest});
    private Widget healthWidget;
    private Widget pointsWidget;
    private Item[] inventoryItems;
    private Item[] equipmentItems;
    private Instant lastActionTime;
    private int brumaLogCount;
    private int brumaKindlingCount;
    private int emptyInventoryCount;
    private int wintertodtHealth;
    private int wintertodtPoints;
    private boolean isInWintertodt;
    private boolean hasHammer;
    private boolean hasKnife;
    private boolean hasTinderbox;
    private String warningText;
    private TileObject hammerCrate;
    private TileObject knifeCrate;
    private PermanentGameObject potionCrateWest = new PermanentGameObject(29320, new WorldPoint(1626, 3982, 0));
    private PermanentGameObject potionCrateEast = new PermanentGameObject(29320, new WorldPoint(1634, 3982, 0));
    private List<PermanentGameObject> potionCrates = Lists.newArrayList((Object[])new PermanentGameObject[]{this.potionCrateWest, this.potionCrateEast});
    private PermanentGameObject sproutingRootsWest = new PermanentGameObject(29315, new WorldPoint(1611, 4007, 0));
    private PermanentGameObject sproutingRootsEast = new PermanentGameObject(29315, new WorldPoint(1649, 4007, 0));
    private List<PermanentGameObject> sproutingRoots = Lists.newArrayList((Object[])new PermanentGameObject[]{this.sproutingRootsWest, this.sproutingRootsEast});
    private List<PermanentGameObject> allPermanentObjects = Lists.newArrayList((Object[])new PermanentGameObject[]{this.potionCrateEast, this.potionCrateWest, this.sproutingRootsEast, this.sproutingRootsWest});
    private TileObject tinderboxCrate;
    private int potionDoseCount;
    private int unfinishedCount;
    private int herbCount;
    private int litBrazierCount;
    private WintertodtActivity currentActivity = WintertodtActivity.IDLE;

    @Provides
    WintertodtSoloHelperConfig getConfig(ConfigManager configManager) {
        return (WintertodtSoloHelperConfig)configManager.getConfig(WintertodtSoloHelperConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.isInWintertodtRegion()) {
            if (this.isInWintertodt) {
                log.debug("Left Wintertodt!");
                this.reset();
                this.isInWintertodt = false;
            }
            return;
        }
        if (this.isInWintertodt) {
            String text;
            this.healthWidget = this.client.getWidget(396, 21);
            this.pointsWidget = this.client.getWidget(396, 7);
            if (this.healthWidget != null && (text = this.healthWidget.getText()) != null && text != "" && text.replaceAll("[^0-9]", "") != "") {
                this.wintertodtHealth = Integer.parseInt(text.replaceAll("[^0-9]", ""));
            }
            if (this.pointsWidget != null && (text = this.pointsWidget.getText()) != null && text != "" && text.replaceAll("[^0-9]", "") != "") {
                this.wintertodtPoints = Integer.parseInt(text.replaceAll("[^0-9]", ""));
            }
            this.litBrazierCount = 0;
            for (WintertodtBrazier brazier : this.braziers) {
                brazier.ProcessWidgets(this.client);
                if (brazier.getStatus() != BrazierStatus.LIT) continue;
                ++this.litBrazierCount;
            }
        } else {
            this.reset();
            log.debug("Entered Wintertodt!");
            this.isInWintertodt = true;
        }
        this.checkActionTimeout();
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        ItemContainer itemContainer = event.getItemContainer();
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.inventoryItems = itemContainer.getItems();
            this.herbCount = 0;
            this.unfinishedCount = 0;
            this.brumaLogCount = 0;
            this.brumaKindlingCount = 0;
            this.potionDoseCount = 0;
            this.emptyInventoryCount = 0;
            if (this.inventoryItems != null) {
                for (Item item : this.inventoryItems) {
                    if (item.getId() == 20695) {
                        ++this.brumaLogCount;
                    }
                    if (item.getId() == 20696) {
                        ++this.brumaKindlingCount;
                    }
                    if (item.getId() == 20702) {
                        ++this.potionDoseCount;
                    }
                    if (item.getId() == 20701) {
                        this.potionDoseCount += 2;
                    }
                    if (item.getId() == 20700) {
                        this.potionDoseCount += 3;
                    }
                    if (item.getId() == 20699) {
                        this.potionDoseCount += 4;
                    }
                    if (item.getId() == 20697) {
                        ++this.unfinishedCount;
                    }
                    if (item.getId() == 20698) {
                        ++this.herbCount;
                    }
                    if (item.getId() != -1) continue;
                    ++this.emptyInventoryCount;
                }
            }
        }
        if (event.getContainerId() == InventoryID.EQUIPMENT.getId()) {
            this.equipmentItems = itemContainer.getItems();
        }
        if (this.inventoryItems != null && this.equipmentItems != null) {
            this.hasHammer = false;
            this.hasKnife = false;
            this.hasTinderbox = false;
            for (Item item : this.equipmentItems) {
                if (item.getId() == 25644) {
                    this.hasHammer = true;
                }
                if (item.getId() != 20720) continue;
                this.hasTinderbox = true;
            }
            if (!this.hasHammer) {
                for (Item item : this.inventoryItems) {
                    if (item.getId() == 2347) {
                        this.hasHammer = true;
                    }
                    if (item.getId() == 946) {
                        this.hasKnife = true;
                    }
                    if (item.getId() != 590) continue;
                    this.hasTinderbox = true;
                }
            }
        }
    }

    private boolean isInWintertodtRegion() {
        if (this.client.getLocalPlayer() != null) {
            return this.client.getLocalPlayer().getWorldLocation().getRegionID() == 6462;
        }
        return false;
    }

    private void reset() {
        this.healthWidget = null;
        this.pointsWidget = null;
        this.wintertodtHealth = 0;
        this.currentActivity = WintertodtActivity.IDLE;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.processGameObject(event.getGameObject());
    }

    private void processGameObject(GameObject gameObject) {
        if (gameObject.getId() == 29316) {
            this.hammerCrate = gameObject;
        }
        if (gameObject.getId() == 29317) {
            this.knifeCrate = gameObject;
        }
        for (PermanentGameObject permanentGameObject : this.allPermanentObjects) {
            permanentGameObject.setGameObject(gameObject);
        }
        if (gameObject.getId() == 29319) {
            this.tinderboxCrate = gameObject;
        }
        if (gameObject.getId() == 29312 || gameObject.getId() == 29314 || gameObject.getId() == 29313) {
            for (WintertodtBrazier brazier : this.braziers) {
                brazier.updateGameObject(gameObject);
            }
        }
        if (gameObject.getId() == 29311) {
            for (WintertodtBrazier brazier : this.braziers) {
                brazier.updateRoots(gameObject);
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (npc.getId() == 7372 || npc.getId() == 7371) {
            for (WintertodtBrazier brazier : this.braziers) {
                brazier.updatePyromancer(npc);
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (!this.isInWintertodt) {
            return;
        }
        Player local = this.client.getLocalPlayer();
        if (event.getActor() != local) {
            return;
        }
        int animId = local.getAnimation();
        switch (animId) {
            case 24: 
            case 867: 
            case 869: 
            case 871: 
            case 873: 
            case 875: 
            case 877: 
            case 879: 
            case 2117: 
            case 2846: 
            case 7264: 
            case 8303: 
            case 8324: 
            case 8778: {
                this.setActivity(WintertodtActivity.WOODCUTTING);
                break;
            }
            case 1248: {
                this.setActivity(WintertodtActivity.FLETCHING);
                break;
            }
            case 832: {
                this.setActivity(WintertodtActivity.FEEDING_BRAZIER);
                break;
            }
            case 733: {
                this.setActivity(WintertodtActivity.LIGHTING_BRAZIER);
                break;
            }
            case 3676: 
            case 8912: {
                this.setActivity(WintertodtActivity.FIXING_BRAZIER);
            }
        }
    }

    public WorldPoint getPlayerLocation() {
        return this.client.getLocalPlayer().getWorldLocation();
    }

    public Player getPlayer() {
        return this.client.getLocalPlayer();
    }

    private void setActivity(WintertodtActivity action) {
        this.currentActivity = action;
        this.lastActionTime = Instant.now();
    }

    private void checkActionTimeout() {
        int currentAnimation;
        if (this.currentActivity == WintertodtActivity.IDLE) {
            return;
        }
        int n = currentAnimation = this.client.getLocalPlayer() != null ? this.client.getLocalPlayer().getAnimation() : -1;
        if (currentAnimation != -1 || this.lastActionTime == null) {
            return;
        }
        Duration actionTimeout = Duration.ofSeconds(3L);
        Duration sinceAction = Duration.between(this.lastActionTime, Instant.now());
        if (sinceAction.compareTo(actionTimeout) >= 0) {
            log.debug("Activity timeout!");
            this.currentActivity = WintertodtActivity.IDLE;
        }
    }

    List<WintertodtBrazier> getBraziers() {
        return this.braziers;
    }

    int getBrumaLogCount() {
        return this.brumaLogCount;
    }

    int getBrumaKindlingCount() {
        return this.brumaKindlingCount;
    }

    int getEmptyInventoryCount() {
        return this.emptyInventoryCount;
    }

    int getWintertodtHealth() {
        return this.wintertodtHealth;
    }

    int getWintertodtPoints() {
        return this.wintertodtPoints;
    }

    boolean isInWintertodt() {
        return this.isInWintertodt;
    }

    boolean isHasHammer() {
        return this.hasHammer;
    }

    boolean isHasKnife() {
        return this.hasKnife;
    }

    boolean isHasTinderbox() {
        return this.hasTinderbox;
    }

    String getWarningText() {
        return this.warningText;
    }

    TileObject getHammerCrate() {
        return this.hammerCrate;
    }

    TileObject getKnifeCrate() {
        return this.knifeCrate;
    }

    List<PermanentGameObject> getPotionCrates() {
        return this.potionCrates;
    }

    List<PermanentGameObject> getSproutingRoots() {
        return this.sproutingRoots;
    }

    TileObject getTinderboxCrate() {
        return this.tinderboxCrate;
    }

    int getPotionDoseCount() {
        return this.potionDoseCount;
    }

    int getUnfinishedCount() {
        return this.unfinishedCount;
    }

    int getHerbCount() {
        return this.herbCount;
    }

    int getLitBrazierCount() {
        return this.litBrazierCount;
    }

    WintertodtActivity getCurrentActivity() {
        return this.currentActivity;
    }
}

