/*
 * Decompiled with CFR 0.152.
 */
package com.WintertodtSoloHelper;

import com.WintertodtSoloHelper.PermanentGameObject;
import com.WintertodtSoloHelper.WintertodtActivity;
import com.WintertodtSoloHelper.WintertodtBrazier;
import com.WintertodtSoloHelper.WintertodtSoloHelperConfig;
import com.WintertodtSoloHelper.WintertodtSoloHelperPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.MenuAction;
import net.runelite.api.TileObject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WintertodtSoloHelperOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(WintertodtSoloHelperOverlay.class);
    private final WintertodtSoloHelperPlugin plugin;
    private final WintertodtSoloHelperConfig wintertodtAFKConfig;
    private final ModelOutlineRenderer modelOutlineRenderer;

    @Inject
    private WintertodtSoloHelperOverlay(WintertodtSoloHelperPlugin plugin, WintertodtSoloHelperConfig wintertodtAFKConfig, ModelOutlineRenderer modelOutlineRenderer) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.wintertodtAFKConfig = wintertodtAFKConfig;
        this.modelOutlineRenderer = modelOutlineRenderer;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.addMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Wintertodt Afk overlay");
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInWintertodt()) {
            return null;
        }
        if (this.wintertodtAFKConfig.showOverlay()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Wintertodt Health: ").leftColor(Color.WHITE).right(String.valueOf(this.plugin.getWintertodtHealth())).rightColor(Color.WHITE).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Lit Braziers: ").leftColor(Color.WHITE).right(String.valueOf(this.plugin.getLitBrazierCount())).rightColor(Color.WHITE).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Potion Doses: ").leftColor(this.wintertodtAFKConfig.minPotionDose() <= this.plugin.getPotionDoseCount() ? Color.WHITE : this.wintertodtAFKConfig.getHighlightColor()).right(String.valueOf(this.plugin.getPotionDoseCount())).rightColor(this.wintertodtAFKConfig.minPotionDose() <= this.plugin.getPotionDoseCount() ? Color.WHITE : this.wintertodtAFKConfig.getHighlightColor()).build());
            if (this.wintertodtAFKConfig.warnForHammer() && !this.plugin.isHasHammer()) {
                this.panelComponent.getChildren().add(TitleComponent.builder().text("Missing Hammer").color(this.wintertodtAFKConfig.getHighlightColor()).build());
            }
            if (this.wintertodtAFKConfig.warnForKnife() && !this.plugin.isHasKnife()) {
                this.panelComponent.getChildren().add(TitleComponent.builder().text("Missing Knife").color(this.wintertodtAFKConfig.getHighlightColor()).build());
            }
            if (this.wintertodtAFKConfig.warnForTinderbox() && !this.plugin.isHasTinderbox()) {
                this.panelComponent.getChildren().add(TitleComponent.builder().text("Missing Tinderbox").color(this.wintertodtAFKConfig.getHighlightColor()).build());
            }
        }
        if (this.wintertodtAFKConfig.highlightObjects()) {
            if (this.wintertodtAFKConfig.warnForHammer() && !this.plugin.isHasHammer()) {
                this.modelOutlineRenderer.drawOutline(this.plugin.getHammerCrate(), 6, this.wintertodtAFKConfig.getHighlightColor(), 6);
            }
            if (this.wintertodtAFKConfig.warnForKnife() && !this.plugin.isHasKnife()) {
                this.modelOutlineRenderer.drawOutline(this.plugin.getKnifeCrate(), 6, this.wintertodtAFKConfig.getHighlightColor(), 6);
            }
            if (this.wintertodtAFKConfig.warnForTinderbox() && !this.plugin.isHasTinderbox()) {
                this.modelOutlineRenderer.drawOutline(this.plugin.getTinderboxCrate(), 6, this.wintertodtAFKConfig.getHighlightColor(), 6);
            }
            if (this.plugin.getPotionDoseCount() < this.wintertodtAFKConfig.minPotionDose()) {
                if (this.plugin.getUnfinishedCount() == 0) {
                    for (PermanentGameObject crate : this.plugin.getPotionCrates()) {
                        this.modelOutlineRenderer.drawOutline((TileObject)crate.getGameObject(), 6, this.wintertodtAFKConfig.getHighlightColor(), 6);
                    }
                }
                if (this.plugin.getHerbCount() == 0) {
                    for (PermanentGameObject root : this.plugin.getSproutingRoots()) {
                        this.modelOutlineRenderer.drawOutline((TileObject)root.getGameObject(), 6, this.wintertodtAFKConfig.getHighlightColor(), 6);
                    }
                }
            }
            if (this.wintertodtAFKConfig.highlightPlayer() && this.plugin.getBrumaLogCount() > 0 && this.plugin.getCurrentActivity() != WintertodtActivity.WOODCUTTING && this.plugin.getCurrentActivity() != WintertodtActivity.FLETCHING) {
                log.debug(this.plugin.getPlayer() + " " + this.plugin.getPlayer().getWorldLocation());
                this.modelOutlineRenderer.drawOutline(this.plugin.getPlayer(), 6, this.wintertodtAFKConfig.getHighlightColor(), 6);
            }
            for (WintertodtBrazier brazier : this.plugin.getBraziers()) {
                brazier.render(this.modelOutlineRenderer, this.wintertodtAFKConfig, this.plugin);
            }
        }
        return super.render(graphics);
    }
}

