/*
 * Decompiled with CFR 0.152.
 */
package com.WintertodtSoloHelper;

import com.WintertodtSoloHelper.BrazierLocation;
import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="wintertodt-afk")
public interface WintertodtSoloHelperConfig
extends Config {
    @ConfigSection(name="Percentages", description="All the options for how you solo Wintertodt", position=6, closedByDefault=false)
    public static final String percentages = "percentages";
    @ConfigSection(name="Items", description="Should the plugin highlight crates for hammers, knifes, etc", position=7, closedByDefault=true)
    public static final String items = "items";
    @ConfigSection(name="Misc", description="Miscellaneous options", position=6, closedByDefault=true)
    public static final String misc = "misc";

    @ConfigItem(position=0, keyName="showOverlay", name="Show Overlay", description="Toggles the status overlay")
    default public boolean showOverlay() {
        return true;
    }

    @ConfigItem(position=1, keyName="highlightObjects", name="Highlight Objects", description="Highlights objects")
    default public boolean highlightObjects() {
        return true;
    }

    @ConfigItem(position=2, keyName="highlightPlayer", name="Highlight Player", description="Highlights player when inventory actions needed")
    default public boolean highlightPlayer() {
        return true;
    }

    @ConfigItem(position=2, keyName="pointGoal", name="Point Goal", description="What point goal before ending")
    @Range(min=0, max=13500)
    default public int pointGoal() {
        return 13500;
    }

    @ConfigItem(position=3, keyName="brazier", name="Brazier", description="Which brazier you prefer to use")
    default public BrazierLocation brazier() {
        return BrazierLocation.SouthEast;
    }

    @Alpha
    @ConfigItem(keyName="overlayColor", name="Highlight Color", description="Color of highlights", position=5)
    default public Color getHighlightColor() {
        return Color.RED;
    }

    @ConfigItem(position=0, keyName="minRelightHealth", name="Minimum Relight Health", description="Minimum health to relight the main brazier", section="percentages")
    @Range(min=1, max=100)
    @Units(value="%")
    default public int minRelightHealth() {
        return 6;
    }

    @ConfigItem(position=1, keyName="alwaysRelightHealth", name="Always Relight Health", description="Always relight the fire above this health", section="percentages")
    @Range(min=2, max=100)
    @Units(value="%")
    default public int alwaysRelightHealth() {
        return 11;
    }

    @ConfigItem(position=2, keyName="multiFireRelightPercentage", name="Multi Fire Relight Percentage", description="What percentage to relight multiple fires", section="percentages")
    @Range(min=2, max=100)
    @Units(value="%")
    default public int multiFireRelightPercentage() {
        return 25;
    }

    @ConfigItem(position=0, keyName="warnForHammer", name="Warn for Hammer", description="Warns you if you don't have a hammer", section="items")
    default public boolean warnForHammer() {
        return true;
    }

    @ConfigItem(position=1, keyName="warnForKnife", name="Warn for Knife", description="Warns and highlights you if you don't have a knife", section="items")
    default public boolean warnForKnife() {
        return true;
    }

    @ConfigItem(position=2, keyName="warnForTinderbox", name="Warn for Tinderbox", description="Warns and highlights you if you don't have a tinderbox", section="items")
    default public boolean warnForTinderbox() {
        return true;
    }

    @ConfigItem(position=3, keyName="minPotionDose", name="Minimum Potion Dose", description="Warns and highlights when you have less than this many doses of bruma potion", section="items")
    @Range(min=0, max=40)
    default public int minPotionDose() {
        return 4;
    }

    @ConfigItem(position=0, keyName="alwaysRepairBroken", name="Always Repair Broken", description="Always repair broken brazier", section="misc")
    default public boolean alwaysRepairBroken() {
        return true;
    }
}

