/*
 * Decompiled with CFR 0.152.
 */
package com.WintertodtSoloHelper;

import com.WintertodtSoloHelper.BrazierLocation;
import com.WintertodtSoloHelper.BrazierStatus;
import com.WintertodtSoloHelper.WintertodtActivity;
import com.WintertodtSoloHelper.WintertodtSoloHelperConfig;
import com.WintertodtSoloHelper.WintertodtSoloHelperPlugin;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.NPC;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.outline.ModelOutlineRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WintertodtBrazier {
    private static final Logger log = LoggerFactory.getLogger(WintertodtBrazier.class);
    public GameObject brazierObject;
    private GameObject brumaRootObject;
    private NPC pyromancer;
    private BrazierStatus status;
    private static final int UNLIT_SPRITE_ID = 1398;
    private static final int LIT_SPRITE_ID = 1399;
    private static final int BROKEN_SPRITE_ID = 1397;
    private static final int DEAD_PYROMANCER_SPRITE_ID = 1400;
    private WorldPoint worldLocation;
    private int brazierStatusWidgetId;
    private Widget brazierStatusWidget;
    private int wizardStatusWidgetId;
    private Widget wizardStatusWidget;
    public BrazierLocation brazierLocation;
    private boolean pyromancerAlive;

    public WintertodtBrazier(BrazierLocation brazierLocation) {
        this.brazierLocation = brazierLocation;
        switch (brazierLocation) {
            case SouthWest: {
                this.worldLocation = new WorldPoint(1621, 3998, 0);
                this.brazierStatusWidgetId = 12;
                this.wizardStatusWidgetId = 8;
                break;
            }
            case NorthWest: {
                this.worldLocation = new WorldPoint(1621, 4016, 0);
                this.brazierStatusWidgetId = 13;
                this.wizardStatusWidgetId = 9;
                break;
            }
            case NorthEast: {
                this.worldLocation = new WorldPoint(1639, 4016, 0);
                this.brazierStatusWidgetId = 14;
                this.wizardStatusWidgetId = 10;
                break;
            }
            case SouthEast: {
                this.worldLocation = new WorldPoint(1639, 3998, 0);
                this.brazierStatusWidgetId = 15;
                this.wizardStatusWidgetId = 11;
            }
        }
    }

    public void ProcessWidgets(Client client) {
        this.wizardStatusWidget = client.getWidget(396, this.wizardStatusWidgetId);
        this.brazierStatusWidget = client.getWidget(396, this.brazierStatusWidgetId);
        if (this.brazierStatusWidget != null) {
            if (this.brazierStatusWidget.getSpriteId() == 1398) {
                this.status = BrazierStatus.UNLIT;
            }
            if (this.brazierStatusWidget.getSpriteId() == 1399) {
                this.status = BrazierStatus.LIT;
            }
            if (this.brazierStatusWidget.getSpriteId() == 1397) {
                this.status = BrazierStatus.BROKEN;
            }
        }
        if (this.wizardStatusWidget != null) {
            this.pyromancerAlive = this.wizardStatusWidget.getSpriteId() != 1400;
        }
    }

    public void updateGameObject(GameObject gameObject) {
        if (gameObject.getWorldLocation().getX() == this.worldLocation.getX() && gameObject.getWorldLocation().getY() == this.worldLocation.getY()) {
            this.brazierObject = gameObject;
        }
    }

    public void render(ModelOutlineRenderer modelOutlineRenderer, WintertodtSoloHelperConfig config, WintertodtSoloHelperPlugin plugin) {
        boolean shouldDrawRoot;
        boolean thisIsMainLocation = config.brazier() == this.brazierLocation;
        int distanceFromPlayer = this.worldLocation.distanceTo(plugin.getPlayerLocation());
        boolean isWithinDistance = distanceFromPlayer <= 15;
        boolean shouldCurrentActivityStopRender = plugin.getCurrentActivity() == WintertodtActivity.LIGHTING_BRAZIER || plugin.getCurrentActivity() == WintertodtActivity.FEEDING_BRAZIER;
        boolean shouldDraw = !isWithinDistance || !shouldCurrentActivityStopRender;
        boolean bl = shouldDrawRoot = !isWithinDistance || plugin.getCurrentActivity() != WintertodtActivity.WOODCUTTING;
        if (!this.pyromancerAlive && this.pyromancer != null) {
            modelOutlineRenderer.drawOutline(this.pyromancer, 6, config.getHighlightColor(), 6);
        }
        int brumaKindlingCount = plugin.getBrumaKindlingCount();
        int brumaRootCount = plugin.getBrumaLogCount();
        if (config.alwaysRepairBroken() && this.status == BrazierStatus.BROKEN) {
            this.drawOutline(modelOutlineRenderer, this.brazierObject, config, true);
        }
        if (config.pointGoal() < plugin.getWintertodtPoints() && this.status != BrazierStatus.LIT) {
            this.drawOutline(modelOutlineRenderer, this.brazierObject, config, shouldDraw);
        }
        if (thisIsMainLocation) {
            if (this.status == BrazierStatus.UNLIT) {
                if (plugin.getWintertodtHealth() > config.alwaysRelightHealth()) {
                    this.drawOutline(modelOutlineRenderer, this.brazierObject, config, shouldDraw);
                } else if (plugin.getWintertodtHealth() > config.minRelightHealth()) {
                    if (brumaKindlingCount > 0) {
                        if (brumaRootCount == 0) {
                            this.drawOutline(modelOutlineRenderer, this.brazierObject, config, shouldDraw);
                        }
                    } else if (plugin.getEmptyInventoryCount() != 0) {
                        this.drawOutline(modelOutlineRenderer, this.brumaRootObject, config, shouldDrawRoot);
                    }
                }
            } else if (this.status == BrazierStatus.LIT) {
                if (brumaKindlingCount > 0) {
                    if (brumaRootCount == 0) {
                        this.drawOutline(modelOutlineRenderer, this.brazierObject, config, shouldDraw);
                    }
                } else if (plugin.getEmptyInventoryCount() != 0) {
                    this.drawOutline(modelOutlineRenderer, this.brumaRootObject, config, shouldDrawRoot);
                }
            } else if (this.status == BrazierStatus.BROKEN) {
                this.drawOutline(modelOutlineRenderer, this.brazierObject, config, shouldDraw);
                if (plugin.getEmptyInventoryCount() != 0 && brumaKindlingCount == 0) {
                    this.drawOutline(modelOutlineRenderer, this.brumaRootObject, config, shouldDrawRoot);
                }
            }
        } else if (config.multiFireRelightPercentage() < plugin.getWintertodtHealth() && this.status == BrazierStatus.UNLIT) {
            this.drawOutline(modelOutlineRenderer, this.brazierObject, config, shouldDraw);
        }
    }

    private void drawOutline(ModelOutlineRenderer modelOutlineRenderer, GameObject gameObject, WintertodtSoloHelperConfig config, boolean shouldDraw) {
        if (shouldDraw) {
            modelOutlineRenderer.drawOutline((TileObject)gameObject, 6, config.getHighlightColor(), 6);
        }
    }

    public void updateRoots(GameObject gameObject) {
        int distance = gameObject.getWorldLocation().distanceTo(this.worldLocation);
        if (distance < 15) {
            this.brumaRootObject = gameObject;
        }
    }

    public void updatePyromancer(NPC npc) {
        int distance = npc.getWorldLocation().distanceTo(this.worldLocation);
        if (distance < 15) {
            this.pyromancer = npc;
        }
    }

    BrazierStatus getStatus() {
        return this.status;
    }

    boolean isPyromancerAlive() {
        return this.pyromancerAlive;
    }
}

