/*
 * Decompiled with CFR 0.152.
 */
package com.pathmarker;

import com.pathmarker.PathMarkerConfig;
import com.pathmarker.PathMarkerPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.CollisionData;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import org.apache.commons.lang3.tuple.Pair;

public class Pathfinder {
    private final Client client;
    private final PathMarkerConfig config;
    private final PathMarkerPlugin plugin;
    private final int[][] directions = new int[128][128];
    private final int[][] distances = new int[128][128];
    private final int[] bufferX = new int[4096];
    private final int[] bufferY = new int[4096];

    public Pathfinder(Client client, PathMarkerConfig config, PathMarkerPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
    }

    public Pair<List<WorldPoint>, Boolean> pathTo(int approxDestinationX, int approxDestinationY, int sizeX, int sizeY, int objConfig, int objID) {
        int directionOld;
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return null;
        }
        int z = this.client.getPlane();
        CollisionData[] collisionData = this.client.getCollisionMaps();
        if (collisionData == null) {
            return null;
        }
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                this.directions[i][j] = 0;
                this.distances[i][j] = Integer.MAX_VALUE;
            }
        }
        LocalPoint playerTrueTileLocalPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)player.getWorldLocation());
        if (playerTrueTileLocalPoint == null) {
            return null;
        }
        int middleX = playerTrueTileLocalPoint.getSceneX();
        int middleY = playerTrueTileLocalPoint.getSceneY();
        int currentX = middleX;
        int currentY = middleY;
        int offsetX = 64;
        int offsetY = 64;
        this.directions[offsetX][offsetY] = 99;
        this.distances[offsetX][offsetY] = 0;
        int index1 = 0;
        this.bufferX[0] = currentX;
        int index2 = 1;
        this.bufferY[0] = currentY;
        int[][] collisionDataFlags = collisionData[z].getFlags();
        boolean isReachable = false;
        while (index1 != index2) {
            currentX = this.bufferX[index1];
            currentY = this.bufferY[index1];
            index1 = index1 + 1 & 0xFFF;
            int currentMapX = currentX - middleX + offsetX;
            int currentMapY = currentY - middleY + offsetY;
            if (this.hasArrived(currentX, currentY, approxDestinationX, approxDestinationY, sizeX, sizeY, objConfig, objID, collisionDataFlags)) {
                isReachable = true;
                break;
            }
            int currentDistance = this.distances[currentMapX][currentMapY] + 1;
            if (currentMapX > 0 && this.directions[currentMapX - 1][currentMapY] == 0 && (collisionDataFlags[currentX - 1][currentY] & 0x1240108) == 0) {
                this.bufferX[index2] = currentX - 1;
                this.bufferY[index2] = currentY;
                index2 = index2 + 1 & 0xFFF;
                this.directions[currentMapX - 1][currentMapY] = 2;
                this.distances[currentMapX - 1][currentMapY] = currentDistance;
            }
            if (currentMapX < 127 && this.directions[currentMapX + 1][currentMapY] == 0 && (collisionDataFlags[currentX + 1][currentY] & 0x1240180) == 0) {
                this.bufferX[index2] = currentX + 1;
                this.bufferY[index2] = currentY;
                index2 = index2 + 1 & 0xFFF;
                this.directions[currentMapX + 1][currentMapY] = 8;
                this.distances[currentMapX + 1][currentMapY] = currentDistance;
            }
            if (currentMapY > 0 && this.directions[currentMapX][currentMapY - 1] == 0 && (collisionDataFlags[currentX][currentY - 1] & 0x1240102) == 0) {
                this.bufferX[index2] = currentX;
                this.bufferY[index2] = currentY - 1;
                index2 = index2 + 1 & 0xFFF;
                this.directions[currentMapX][currentMapY - 1] = 1;
                this.distances[currentMapX][currentMapY - 1] = currentDistance;
            }
            if (currentMapY < 127 && this.directions[currentMapX][currentMapY + 1] == 0 && (collisionDataFlags[currentX][currentY + 1] & 0x1240120) == 0) {
                this.bufferX[index2] = currentX;
                this.bufferY[index2] = currentY + 1;
                index2 = index2 + 1 & 0xFFF;
                this.directions[currentMapX][currentMapY + 1] = 4;
                this.distances[currentMapX][currentMapY + 1] = currentDistance;
            }
            if (currentMapX > 0 && currentMapY > 0 && this.directions[currentMapX - 1][currentMapY - 1] == 0 && (collisionDataFlags[currentX - 1][currentY - 1] & 0x124010E) == 0 && (collisionDataFlags[currentX - 1][currentY] & 0x1240108) == 0 && (collisionDataFlags[currentX][currentY - 1] & 0x1240102) == 0) {
                this.bufferX[index2] = currentX - 1;
                this.bufferY[index2] = currentY - 1;
                index2 = index2 + 1 & 0xFFF;
                this.directions[currentMapX - 1][currentMapY - 1] = 3;
                this.distances[currentMapX - 1][currentMapY - 1] = currentDistance;
            }
            if (currentMapX < 127 && currentMapY > 0 && this.directions[currentMapX + 1][currentMapY - 1] == 0 && (collisionDataFlags[currentX + 1][currentY - 1] & 0x1240183) == 0 && (collisionDataFlags[currentX + 1][currentY] & 0x1240180) == 0 && (collisionDataFlags[currentX][currentY - 1] & 0x1240102) == 0) {
                this.bufferX[index2] = currentX + 1;
                this.bufferY[index2] = currentY - 1;
                index2 = index2 + 1 & 0xFFF;
                this.directions[currentMapX + 1][currentMapY - 1] = 9;
                this.distances[currentMapX + 1][currentMapY - 1] = currentDistance;
            }
            if (currentMapX > 0 && currentMapY < 127 && this.directions[currentMapX - 1][currentMapY + 1] == 0 && (collisionDataFlags[currentX - 1][currentY + 1] & 0x1240138) == 0 && (collisionDataFlags[currentX - 1][currentY] & 0x1240108) == 0 && (collisionDataFlags[currentX][currentY + 1] & 0x1240120) == 0) {
                this.bufferX[index2] = currentX - 1;
                this.bufferY[index2] = currentY + 1;
                index2 = index2 + 1 & 0xFFF;
                this.directions[currentMapX - 1][currentMapY + 1] = 6;
                this.distances[currentMapX - 1][currentMapY + 1] = currentDistance;
            }
            if (currentMapX >= 127 || currentMapY >= 127 || this.directions[currentMapX + 1][currentMapY + 1] != 0 || (collisionDataFlags[currentX + 1][currentY + 1] & 0x12401E0) != 0 || (collisionDataFlags[currentX + 1][currentY] & 0x1240180) != 0 || (collisionDataFlags[currentX][currentY + 1] & 0x1240120) != 0) continue;
            this.bufferX[index2] = currentX + 1;
            this.bufferY[index2] = currentY + 1;
            index2 = index2 + 1 & 0xFFF;
            this.directions[currentMapX + 1][currentMapY + 1] = 12;
            this.distances[currentMapX + 1][currentMapY + 1] = currentDistance;
        }
        if (!isReachable) {
            int upperboundDistance = Integer.MAX_VALUE;
            int pathLength = Integer.MAX_VALUE;
            int checkRange = 10;
            for (int i = approxDestinationX - checkRange; i <= checkRange + approxDestinationX; ++i) {
                for (int j = approxDestinationY - checkRange; j <= checkRange + approxDestinationY; ++j) {
                    int currentMapX = i - middleX + offsetX;
                    int currentMapY = j - middleY + offsetY;
                    if (currentMapX < 0 || currentMapY < 0 || currentMapX >= 128 || currentMapY >= 128 || this.distances[currentMapX][currentMapY] >= 100) continue;
                    int deltaX = 0;
                    if (i < approxDestinationX) {
                        deltaX = approxDestinationX - i;
                    } else if (i > approxDestinationX + sizeX - 1) {
                        deltaX = i - (approxDestinationX + sizeX - 1);
                    }
                    int deltaY = 0;
                    if (j < approxDestinationY) {
                        deltaY = approxDestinationY - j;
                    } else if (j > approxDestinationY + sizeY - 1) {
                        deltaY = j - (approxDestinationY + sizeY - 1);
                    }
                    int distanceSquared = deltaX * deltaX + deltaY * deltaY;
                    if (distanceSquared >= upperboundDistance && (distanceSquared != upperboundDistance || this.distances[currentMapX][currentMapY] >= pathLength)) continue;
                    upperboundDistance = distanceSquared;
                    pathLength = this.distances[currentMapX][currentMapY];
                    currentX = i;
                    currentY = j;
                }
            }
            if (upperboundDistance == Integer.MAX_VALUE) {
                ArrayList<WorldPoint> checkpointWPs = new ArrayList<WorldPoint>();
                checkpointWPs.add(this.plugin.getActiveCheckpointWPs().get(0));
                return Pair.of(checkpointWPs, (Object)false);
            }
        }
        this.bufferX[0] = currentX;
        this.bufferY[0] = currentY;
        int index = 1;
        int directionNew = directionOld = this.directions[currentX - middleX + offsetX][currentY - middleY + offsetY];
        while (middleX != currentX || middleY != currentY) {
            if (directionNew != directionOld) {
                directionOld = directionNew;
                this.bufferX[index] = currentX;
                this.bufferY[index++] = currentY;
            }
            if ((directionNew & 2) != 0) {
                ++currentX;
            } else if ((directionNew & 8) != 0) {
                --currentX;
            }
            if ((directionNew & 1) != 0) {
                ++currentY;
            } else if ((directionNew & 4) != 0) {
                --currentY;
            }
            directionNew = this.directions[currentX - middleX + offsetX][currentY - middleY + offsetY];
        }
        int checkpointTileNumber = 1;
        Tile[][][] tiles = this.client.getScene().getTiles();
        ArrayList<WorldPoint> checkpointWPs = new ArrayList<WorldPoint>();
        while (index-- > 0) {
            checkpointWPs.add(tiles[z][this.bufferX[index]][this.bufferY[index]].getWorldLocation());
            if (checkpointTileNumber == 25) break;
            ++checkpointTileNumber;
        }
        if (checkpointWPs.size() == 0) {
            checkpointWPs.add(player.getWorldLocation());
            return Pair.of(checkpointWPs, (Object)true);
        }
        return Pair.of(checkpointWPs, (Object)true);
    }

    public Pair<List<WorldPoint>, Boolean> pathTo(Tile other) {
        return this.pathTo(other.getSceneLocation().getX(), other.getSceneLocation().getY(), 1, 1, -1, -1);
    }

    private boolean hasArrived(int baseX, int baseY, int targetX, int targetY, int sizeX, int sizeY, int objConfig, int objID, int[][] flags) {
        int objShape = -1;
        int objRot = 0;
        switch (objConfig) {
            case -2: {
                objShape = -2;
                break;
            }
            case -1: {
                break;
            }
            default: {
                objShape = objConfig & 0x1F;
                objRot = objConfig >>> 6 & 3;
            }
        }
        if (objShape != -2 && targetX <= baseX && baseX <= targetX + sizeX - 1 && targetY <= baseY && baseY <= targetY + sizeY - 1) {
            return true;
        }
        switch (objShape) {
            case 0: {
                return this.reachStraightWall(flags, baseX, baseY, targetX, targetY, objRot);
            }
            case 2: {
                return this.reachLWall(flags, baseX, baseY, targetX, targetY, objRot);
            }
            case 6: {
                return this.reachDiagonalWallDecoration(flags, baseX, baseY, targetX, targetY, objRot);
            }
            case 7: {
                return this.reachDiagonalWallDecoration(flags, baseX, baseY, targetX, targetY, objRot + 2 & 3);
            }
            case -2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: {
                int objFlags = 0;
                if (Arrays.asList(10, 11, 22).contains(objShape)) {
                    objFlags = PathMarkerPlugin.getObjectBlocking(objID, objRot);
                }
                return this.reachRectangularBoundary(flags, baseX, baseY, targetX, targetY, sizeX, sizeY, objFlags);
            }
        }
        return false;
    }

    private boolean reachRectangularBoundary(int[][] flags, int x, int y, int destX, int destY, int destWidth, int destHeight, int objectflags) {
        int east = destX + destWidth - 1;
        int north = destY + destHeight - 1;
        if (x == destX - 1 && y >= destY && y <= north && (flags[x][y] & 8) == 0 && (objectflags & 8) == 0) {
            return true;
        }
        if (x == east + 1 && y >= destY && y <= north && (flags[x][y] & 0x80) == 0 && (objectflags & 2) == 0) {
            return true;
        }
        if (y + 1 == destY && x >= destX && x <= east && (flags[x][y] & 2) == 0 && (objectflags & 4) == 0) {
            return true;
        }
        return y == north + 1 && x >= destX && x <= east && (flags[x][y] & 0x20) == 0 && (objectflags & 1) == 0;
    }

    private boolean reachStraightWall(int[][] flags, int x, int y, int destX, int destY, int rot) {
        switch (rot) {
            case 0: {
                if (x == destX - 1 && y == destY) {
                    return true;
                }
                if (x == destX && y == destY + 1 && (flags[x][y] & 0x12C0120) == 0) {
                    return true;
                }
                if (x != destX || y != destY - 1 || (flags[x][y] & 0x12C0102) != 0) break;
                return true;
            }
            case 1: {
                if (x == destX && y == destY + 1) {
                    return true;
                }
                if (x == destX - 1 && y == destY && (flags[x][y] & 0x12C0108) == 0) {
                    return true;
                }
                if (x != destX + 1 || y != destY || (flags[x][y] & 0x12C0180) != 0) break;
                return true;
            }
            case 2: {
                if (x == destX + 1 && y == destY) {
                    return true;
                }
                if (x == destX && y == destY + 1 && (flags[x][y] & 0x12C0120) == 0) {
                    return true;
                }
                if (x != destX || y != destY - 1 || (flags[x][y] & 0x12C0102) != 0) break;
                return true;
            }
            case 3: {
                if (x == destX && y == destY - 1) {
                    return true;
                }
                if (x == destX - 1 && y == destY && (flags[x][y] & 0x12C0108) == 0) {
                    return true;
                }
                if (x != destX + 1 || y != destY || (flags[x][y] & 0x12C0180) != 0) break;
                return true;
            }
        }
        return false;
    }

    private boolean reachLWall(int[][] flags, int x, int y, int destX, int destY, int rot) {
        int WESTWALLFLAGS = 19661064;
        int NORTHWALLFLAGS = 19661088;
        int EASTWALLFLAGS = 19661184;
        int SOUTHWALLFLAGS = 19661058;
        switch (rot) {
            case 0: {
                WESTWALLFLAGS = 0;
                NORTHWALLFLAGS = 0;
                break;
            }
            case 1: {
                NORTHWALLFLAGS = 0;
                EASTWALLFLAGS = 0;
                break;
            }
            case 2: {
                EASTWALLFLAGS = 0;
                SOUTHWALLFLAGS = 0;
                break;
            }
            case 3: {
                SOUTHWALLFLAGS = 0;
                WESTWALLFLAGS = 0;
            }
        }
        if (x == destX - 1 && y == destY && (flags[x][y] & WESTWALLFLAGS) == 0) {
            return true;
        }
        if (x == destX && y == destY + 1 && (flags[x][y] & NORTHWALLFLAGS) == 0) {
            return true;
        }
        if (x == destX + 1 && y == destY && (flags[x][y] & EASTWALLFLAGS) == 0) {
            return true;
        }
        return x == destX && y == destY - 1 && (flags[x][y] & SOUTHWALLFLAGS) == 0;
    }

    private boolean reachDiagonalWallDecoration(int[][] flags, int x, int y, int destX, int destY, int rot) {
        switch (rot) {
            case 0: {
                if (x == destX + 1 && y == destY && (flags[x][y] & 0x80) == 0) {
                    return true;
                }
                if (x != destX || y != destY - 1 || (flags[x][y] & 2) != 0) break;
                return true;
            }
            case 1: {
                if (x == destX - 1 && y == destY && (flags[x][y] & 4) == 0) {
                    return true;
                }
                if (x != destX || y != destY - 1 || (flags[x][y] & 2) != 0) break;
                return true;
            }
            case 2: {
                if (x == destX - 1 && y == destY && (flags[x][y] & 4) == 0) {
                    return true;
                }
                if (x != destX || y != destY + 1 || (flags[x][y] & 0x20) != 0) break;
                return true;
            }
            case 3: {
                if (x == destX + 1 && y == destY && (flags[x][y] & 0x80) == 0) {
                    return true;
                }
                if (x != destX || y != destY + 1 || (flags[x][y] & 0x20) != 0) break;
                return true;
            }
        }
        return false;
    }
}

