/*
 * Decompiled with CFR 0.152.
 */
package com.pathmarker;

import com.pathmarker.PathMarkerConfig;
import com.pathmarker.PathMarkerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class PathMinimapMarkerOverlay
extends Overlay {
    private final Client client;
    private final PathMarkerPlugin plugin;
    @Inject
    private PathMarkerConfig config;
    private double angle;

    @Inject
    private PathMinimapMarkerOverlay(Client client, PathMarkerConfig config, PathMarkerPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        this.angle = (double)this.client.getMapAngle() * 0.0030679615;
        Widget minimapDrawWidget = this.client.isResized() ? (this.client.getVarbitValue(4607) == 1 ? this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA) : this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA)) : this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
        if (minimapDrawWidget == null || minimapDrawWidget.isHidden()) {
            return null;
        }
        Point minimapWidgetLocation = minimapDrawWidget.getCanvasLocation();
        Point minimapPoint = new Point(minimapWidgetLocation.getX() + minimapDrawWidget.getWidth() / 2, minimapWidgetLocation.getY() + minimapDrawWidget.getHeight() / 2);
        graphics.rotate(this.angle, minimapPoint.getX(), minimapPoint.getY());
        if (!(this.config.hoverPathDisplaySetting() == PathMarkerConfig.PathDisplaySetting.NEVER || this.config.activePathDisplaySetting() != PathMarkerConfig.PathDisplaySetting.NEVER && this.plugin.isPathActive() && this.config.drawOnlyIfNoActivePath() || !this.plugin.isKeyDisplayHoverPath() && this.config.hoverPathDisplaySetting() != PathMarkerConfig.PathDisplaySetting.ALWAYS)) {
            for (WorldPoint worldPoint : this.plugin.getHoverPathTiles()) {
                if (this.config.hoverPathDrawLocations() != PathMarkerConfig.drawLocations.BOTH && this.config.hoverPathDrawLocations() != PathMarkerConfig.drawLocations.MINIMAP || this.config.hoverPathDrawMode() != PathMarkerConfig.DrawMode.FULL_PATH && worldPoint != this.plugin.getHoverPathTiles().get(this.plugin.getHoverPathTiles().size() - 1)) continue;
                this.renderMinimapTile(graphics, worldPoint, this.config.hoverPathFill1(), minimapPoint);
            }
            for (WorldPoint worldPoint : this.plugin.getHoverMiddlePathTiles()) {
                if (this.config.hoverPathDrawLocations() != PathMarkerConfig.drawLocations.BOTH && this.config.hoverPathDrawLocations() != PathMarkerConfig.drawLocations.MINIMAP || this.config.hoverPathDrawMode() != PathMarkerConfig.DrawMode.FULL_PATH && worldPoint != this.plugin.getHoverPathTiles().get(this.plugin.getHoverPathTiles().size() - 1)) continue;
                this.renderMinimapTile(graphics, worldPoint, this.config.hoverPathFill2(), minimapPoint);
            }
        }
        if (this.config.activePathDisplaySetting() != PathMarkerConfig.PathDisplaySetting.NEVER && this.plugin.isPathActive() && (this.plugin.isKeyDisplayActivePath() || this.config.activePathDisplaySetting() == PathMarkerConfig.PathDisplaySetting.ALWAYS)) {
            for (WorldPoint worldPoint : this.plugin.getActivePathTiles()) {
                if (this.config.activePathDrawLocations() != PathMarkerConfig.drawLocations.BOTH && this.config.activePathDrawLocations() != PathMarkerConfig.drawLocations.MINIMAP || this.config.activePathDrawMode() != PathMarkerConfig.DrawMode.FULL_PATH && worldPoint != this.plugin.getActivePathTiles().get(this.plugin.getActivePathTiles().size() - 1)) continue;
                this.renderMinimapTile(graphics, worldPoint, this.config.activePathFill1(), minimapPoint);
            }
            for (WorldPoint worldPoint : this.plugin.getActiveMiddlePathTiles()) {
                if (this.config.activePathDrawLocations() != PathMarkerConfig.drawLocations.BOTH && this.config.activePathDrawLocations() != PathMarkerConfig.drawLocations.MINIMAP || this.config.activePathDrawMode() != PathMarkerConfig.DrawMode.FULL_PATH && worldPoint != this.plugin.getActivePathTiles().get(this.plugin.getActivePathTiles().size() - 1)) continue;
                this.renderMinimapTile(graphics, worldPoint, this.config.activePathFill2(), minimapPoint);
            }
        }
        graphics.rotate(-this.angle, minimapPoint.getX(), minimapPoint.getY());
        return null;
    }

    private void renderMinimapTile(Graphics2D graphics, WorldPoint worldPoint, Color color, Point miniMapPoint) {
        int y;
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (lp == null) {
            return;
        }
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        if (localLocation == null) {
            return;
        }
        int x = lp.getX() / 32 - localLocation.getX() / 32;
        int squaredDistance = x * x + (y = localLocation.getY() / 32 - lp.getY() / 32) * y;
        if (squaredDistance > 5900) {
            return;
        }
        Point miniMapPoint2 = new Point(x + miniMapPoint.getX(), y + miniMapPoint.getY());
        graphics.setColor(color);
        graphics.fillRect(miniMapPoint2.getX() - 2, miniMapPoint2.getY() - 2, 4, 4);
    }
}

