/*
 * Decompiled with CFR 0.152.
 */
package com.pathmarker;

import com.google.inject.Provides;
import com.pathmarker.KeyListener;
import com.pathmarker.MouseListener;
import com.pathmarker.PathMarkerConfig;
import com.pathmarker.PathMarkerOverlay;
import com.pathmarker.PathMinimapMarkerOverlay;
import com.pathmarker.Pathfinder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileItem;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Path Marker", description="Highlights your character's path to its target tile and/or to the hovered tile", tags={"route", "pathfinder", "hover", "highlight", "tiles"})
public class PathMarkerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PathMarkerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private PathMarkerConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PathMarkerOverlay overlay;
    @Inject
    private PathMinimapMarkerOverlay minimapOverlay;
    public Pathfinder pathfinder;
    private Tile lastSelectedSceneTile;
    private boolean ctrlHeld;
    private WorldPoint lastTickWorldLocation;
    private MenuEntry lastSelectedMenuEntry;
    private List<WorldPoint> activeCheckpointWPs;
    private Tile oldSelectedSceneTile;
    private boolean isRunning;
    private boolean activePathFound;
    private boolean hoverPathFound;
    private boolean activePathStartedLastTick;
    private boolean activePathMismatchLastTick;
    private boolean calcTilePathOnNextClientTick;
    private boolean keyDisplayActivePath;
    private boolean keyDisplayHoverPath;
    private boolean leftClicked;
    private boolean pathActive;
    private List<WorldPoint> hoverPathTiles;
    private List<WorldPoint> hoverMiddlePathTiles;
    private List<WorldPoint> activePathTiles;
    private List<WorldPoint> activeMiddlePathTiles;
    private List<WorldPoint> hoverCheckpointWPs;
    private List<WorldArea> npcBlockWAs;
    private Point lastMouseCanvasPosition;
    private MenuEntry[] oldMenuEntries;
    @Inject
    private KeyManager keyManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyListener keyListener;
    @Inject
    private MouseListener mouseListener;
    private static Map<Integer, Integer> objectBlocking;
    private static Map<Integer, Integer> npcBlocking;
    private PathDestination activePathDestination;

    protected void startUp() throws Exception {
        this.hoverPathTiles = new ArrayList<WorldPoint>();
        this.hoverMiddlePathTiles = new ArrayList<WorldPoint>();
        this.hoverCheckpointWPs = new ArrayList<WorldPoint>();
        this.activePathTiles = new ArrayList<WorldPoint>();
        this.activeMiddlePathTiles = new ArrayList<WorldPoint>();
        this.activeCheckpointWPs = new ArrayList<WorldPoint>();
        this.npcBlockWAs = new ArrayList<WorldArea>();
        this.ctrlHeld = false;
        this.pathActive = false;
        this.activePathStartedLastTick = false;
        this.activePathMismatchLastTick = false;
        this.leftClicked = false;
        this.keyDisplayActivePath = false;
        this.isRunning = this.willRunOnClick();
        objectBlocking = PathMarkerPlugin.readFile("loc_blocking.txt");
        npcBlocking = PathMarkerPlugin.readFile("npc_blocking.txt");
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.keyManager.registerKeyListener((net.runelite.client.input.KeyListener)this.keyListener);
        this.mouseManager.registerMouseListener((net.runelite.client.input.MouseListener)this.mouseListener);
        this.pathfinder = new Pathfinder(this.client, this.config, this);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.keyManager.unregisterKeyListener((net.runelite.client.input.KeyListener)this.keyListener);
        this.mouseManager.unregisterMouseListener((net.runelite.client.input.MouseListener)this.mouseListener);
    }

    @Provides
    PathMarkerConfig provideConfig(ConfigManager configManager) {
        return (PathMarkerConfig)configManager.getConfig(PathMarkerConfig.class);
    }

    private Pair<List<WorldPoint>, Boolean> pathToHover() {
        MenuEntry menuEntry;
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (menuEntries.length == 0) {
            return null;
        }
        if (!this.client.isMenuOpen()) {
            int i = 1;
            menuEntry = menuEntries[menuEntries.length - 1];
            MenuAction type = menuEntry.getType();
            while (type == MenuAction.EXAMINE_ITEM_GROUND || type == MenuAction.EXAMINE_NPC || type == MenuAction.EXAMINE_OBJECT || type == MenuAction.RUNELITE || type == MenuAction.RUNELITE_HIGH_PRIORITY || type == MenuAction.RUNELITE_INFOBOX || type == MenuAction.RUNELITE_OVERLAY || type == MenuAction.RUNELITE_PLAYER || type == MenuAction.RUNELITE_OVERLAY_CONFIG) {
                menuEntry = menuEntries[menuEntries.length - ++i];
                type = menuEntry.getType();
            }
        } else {
            menuEntry = this.hoveredMenuEntry(menuEntries);
        }
        switch (menuEntry.getType()) {
            case EXAMINE_ITEM_GROUND: 
            case EXAMINE_NPC: 
            case EXAMINE_OBJECT: 
            case CANCEL: 
            case CC_OP: 
            case CC_OP_LOW_PRIORITY: 
            case PLAYER_EIGHTH_OPTION: 
            case WIDGET_CLOSE: 
            case WIDGET_CONTINUE: 
            case WIDGET_FIRST_OPTION: 
            case WIDGET_SECOND_OPTION: 
            case WIDGET_THIRD_OPTION: 
            case WIDGET_FOURTH_OPTION: 
            case WIDGET_FIFTH_OPTION: 
            case WIDGET_TARGET: 
            case WIDGET_TARGET_ON_WIDGET: 
            case WIDGET_TYPE_1: 
            case WIDGET_TYPE_4: 
            case WIDGET_TYPE_5: 
            case WIDGET_USE_ON_ITEM: 
            case RUNELITE: 
            case RUNELITE_HIGH_PRIORITY: 
            case RUNELITE_INFOBOX: 
            case RUNELITE_OVERLAY: 
            case RUNELITE_OVERLAY_CONFIG: 
            case RUNELITE_PLAYER: {
                this.hoverCheckpointWPs.clear();
                return null;
            }
            case GAME_OBJECT_FIRST_OPTION: 
            case GAME_OBJECT_SECOND_OPTION: 
            case GAME_OBJECT_THIRD_OPTION: 
            case GAME_OBJECT_FOURTH_OPTION: 
            case GAME_OBJECT_FIFTH_OPTION: 
            case WIDGET_TARGET_ON_GAME_OBJECT: 
            case GROUND_ITEM_FIRST_OPTION: 
            case GROUND_ITEM_SECOND_OPTION: 
            case GROUND_ITEM_THIRD_OPTION: 
            case GROUND_ITEM_FOURTH_OPTION: 
            case GROUND_ITEM_FIFTH_OPTION: 
            case WIDGET_TARGET_ON_GROUND_ITEM: {
                int x = menuEntry.getParam0();
                int y = menuEntry.getParam1();
                int id = menuEntry.getIdentifier();
                int objConfig = -1;
                int sizeX = 1;
                int sizeY = 1;
                TileObject tileObject = this.findTileObject(x, y, id);
                TileItem tileItem = this.findTileItem(x, y, id);
                if (tileObject == null && tileItem == null) {
                    return null;
                }
                if (tileObject != null) {
                    if (tileObject instanceof GameObject) {
                        GameObject gameObject = (GameObject)tileObject;
                        objConfig = gameObject.getConfig();
                        sizeX = gameObject.sizeX();
                        sizeY = gameObject.sizeY();
                    }
                    if (tileObject instanceof WallObject) {
                        WallObject wallObject = (WallObject)tileObject;
                        objConfig = wallObject.getConfig();
                    }
                    if (tileObject instanceof DecorativeObject) {
                        DecorativeObject decorativeObject = (DecorativeObject)tileObject;
                        objConfig = decorativeObject.getConfig();
                    }
                    if (tileObject instanceof GroundObject) {
                        GroundObject groundObject = (GroundObject)tileObject;
                        objConfig = groundObject.getConfig();
                    }
                }
                return this.pathfinder.pathTo(x, y, sizeX, sizeY, objConfig, id);
            }
            case NPC_FIRST_OPTION: 
            case NPC_SECOND_OPTION: 
            case NPC_THIRD_OPTION: 
            case NPC_FOURTH_OPTION: 
            case NPC_FIFTH_OPTION: 
            case WIDGET_TARGET_ON_NPC: 
            case PLAYER_FIRST_OPTION: 
            case PLAYER_SECOND_OPTION: 
            case PLAYER_THIRD_OPTION: 
            case PLAYER_FOURTH_OPTION: 
            case PLAYER_FIFTH_OPTION: 
            case PLAYER_SIXTH_OPTION: 
            case PLAYER_SEVENTH_OPTION: 
            case WIDGET_TARGET_ON_PLAYER: {
                Actor actor = menuEntry.getActor();
                if (actor == null) {
                    return null;
                }
                int x = actor.getLocalLocation().getSceneX();
                int y = actor.getLocalLocation().getSceneY();
                int size = 1;
                if (actor instanceof NPC) {
                    size = ((NPC)actor).getComposition().getSize();
                }
                return this.pathfinder.pathTo(x, y, size, size, -2, -1);
            }
        }
        Tile selectedSceneTile = this.client.getSelectedSceneTile();
        if (selectedSceneTile == null) {
            return null;
        }
        return this.pathfinder.pathTo(this.client.getSelectedSceneTile());
    }

    private void pathFromCheckpointTiles(List<WorldPoint> checkpointWPs, boolean running, List<WorldPoint> middlePathTiles, List<WorldPoint> pathTiles, boolean pathFound) {
        pathTiles.clear();
        middlePathTiles.clear();
        WorldArea currentWA = this.client.getLocalPlayer().getWorldArea();
        if (currentWA == null || checkpointWPs == null || checkpointWPs.size() == 0) {
            return;
        }
        if (currentWA.getPlane() != checkpointWPs.get(0).getPlane() && pathFound) {
            return;
        }
        boolean runSkip = true;
        int cpTileIndex = 0;
        while (currentWA.toWorldPoint().getX() != checkpointWPs.get(checkpointWPs.size() - 1).getX() || currentWA.toWorldPoint().getY() != checkpointWPs.get(checkpointWPs.size() - 1).getY()) {
            WorldArea finalCurrentWA;
            int dy;
            int dx;
            boolean movementCheck;
            WorldPoint cpTileWP = checkpointWPs.get(cpTileIndex);
            if (currentWA.toWorldPoint().equals((Object)cpTileWP)) {
                cpTileWP = checkpointWPs.get(++cpTileIndex);
            }
            if (movementCheck = currentWA.canTravelInDirection(this.client, dx = Integer.signum(cpTileWP.getX() - currentWA.getX()), dy = Integer.signum(cpTileWP.getY() - currentWA.getY()), arg_0 -> this.lambda$pathFromCheckpointTiles$0(finalCurrentWA = currentWA, dx, dy, arg_0))) {
                if ((currentWA = new WorldArea(currentWA.getX() + dx, currentWA.getY() + dy, 1, 1, this.client.getPlane())).toWorldPoint().equals((Object)checkpointWPs.get(checkpointWPs.size() - 1)) || !pathFound) {
                    pathTiles.add(currentWA.toWorldPoint());
                } else if (runSkip && running) {
                    middlePathTiles.add(currentWA.toWorldPoint());
                } else {
                    pathTiles.add(currentWA.toWorldPoint());
                }
                runSkip = !runSkip;
                continue;
            }
            movementCheck = currentWA.canTravelInDirection(this.client, dx, 0, worldPoint -> {
                for (WorldArea worldArea : this.npcBlockWAs) {
                    WorldPoint worldPoint1;
                    if (!worldArea.contains(worldPoint1 = new WorldPoint(finalCurrentWA.getX() + dx, finalCurrentWA.getY(), this.client.getPlane()))) continue;
                    return false;
                }
                return true;
            });
            if (dx != 0 && movementCheck) {
                if ((currentWA = new WorldArea(currentWA.getX() + dx, currentWA.getY(), 1, 1, this.client.getPlane())).toWorldPoint().equals((Object)checkpointWPs.get(checkpointWPs.size() - 1)) || !pathFound) {
                    pathTiles.add(currentWA.toWorldPoint());
                } else if (runSkip && running) {
                    middlePathTiles.add(currentWA.toWorldPoint());
                } else {
                    pathTiles.add(currentWA.toWorldPoint());
                }
                runSkip = !runSkip;
                continue;
            }
            movementCheck = currentWA.canTravelInDirection(this.client, 0, dy, worldPoint -> {
                for (WorldArea worldArea : this.npcBlockWAs) {
                    WorldPoint worldPoint1;
                    if (!worldArea.contains(worldPoint1 = new WorldPoint(finalCurrentWA.getX(), finalCurrentWA.getY() + dy, this.client.getPlane()))) continue;
                    return false;
                }
                return true;
            });
            if (dy != 0 && movementCheck) {
                if ((currentWA = new WorldArea(currentWA.getX(), currentWA.getY() + dy, 1, 1, this.client.getPlane())).toWorldPoint().equals((Object)checkpointWPs.get(checkpointWPs.size() - 1)) || !pathFound) {
                    pathTiles.add(currentWA.toWorldPoint());
                } else if (runSkip && running) {
                    middlePathTiles.add(currentWA.toWorldPoint());
                } else {
                    pathTiles.add(currentWA.toWorldPoint());
                }
                runSkip = !runSkip;
                continue;
            }
            return;
        }
    }

    private void updateCheckpointTiles() {
        WorldPoint lastActiveCPTile;
        if (this.lastTickWorldLocation == null) {
            return;
        }
        WorldArea currentWA = new WorldArea(this.lastTickWorldLocation.getX(), this.lastTickWorldLocation.getY(), 1, 1, this.client.getPlane());
        if (this.activeCheckpointWPs == null) {
            return;
        }
        if (this.lastTickWorldLocation.getPlane() != this.activeCheckpointWPs.get(0).getPlane() && this.activePathFound) {
            WorldPoint lastActiveCPTile2 = this.activeCheckpointWPs.get(0);
            this.activeCheckpointWPs.clear();
            this.activeCheckpointWPs.add(lastActiveCPTile2);
            this.pathActive = false;
            return;
        }
        int cpTileIndex = 0;
        int steps = 0;
        while (currentWA.toWorldPoint().getX() != this.activeCheckpointWPs.get(this.activeCheckpointWPs.size() - 1).getX() || currentWA.toWorldPoint().getY() != this.activeCheckpointWPs.get(this.activeCheckpointWPs.size() - 1).getY()) {
            WorldArea finalCurrentWA;
            int dy;
            int dx;
            boolean movementCheck;
            WorldPoint cpTileWP = this.activeCheckpointWPs.get(cpTileIndex);
            if (currentWA.toWorldPoint().equals((Object)cpTileWP)) {
                cpTileWP = this.activeCheckpointWPs.get(++cpTileIndex);
            }
            if (movementCheck = currentWA.canTravelInDirection(this.client, dx = Integer.signum(cpTileWP.getX() - currentWA.getX()), dy = Integer.signum(cpTileWP.getY() - currentWA.getY()), arg_0 -> this.lambda$updateCheckpointTiles$3(finalCurrentWA = currentWA, dx, dy, arg_0))) {
                currentWA = new WorldArea(currentWA.getX() + dx, currentWA.getY() + dy, 1, 1, this.client.getPlane());
            } else {
                movementCheck = currentWA.canTravelInDirection(this.client, dx, 0, worldPoint -> {
                    WorldPoint worldPoint1 = new WorldPoint(finalCurrentWA.getX() + dx, finalCurrentWA.getY(), this.client.getPlane());
                    for (WorldArea worldArea : this.npcBlockWAs) {
                        if (!worldArea.contains(worldPoint1)) continue;
                        return false;
                    }
                    return true;
                });
                if (dx != 0 && movementCheck) {
                    currentWA = new WorldArea(currentWA.getX() + dx, currentWA.getY(), 1, 1, this.client.getPlane());
                } else {
                    movementCheck = currentWA.canTravelInDirection(this.client, 0, dy, worldPoint -> {
                        WorldPoint worldPoint1 = new WorldPoint(finalCurrentWA.getX(), finalCurrentWA.getY() + dy, this.client.getPlane());
                        for (WorldArea worldArea : this.npcBlockWAs) {
                            if (!worldArea.contains(worldPoint1)) continue;
                            return false;
                        }
                        return true;
                    });
                    if (dy != 0 && movementCheck) {
                        currentWA = new WorldArea(currentWA.getX(), currentWA.getY() + dy, 1, 1, this.client.getPlane());
                    }
                }
            }
            if (++steps != 2 && this.isRunning && this.activePathFound) continue;
            break;
        }
        if (steps == 0 && this.pathActive) {
            lastActiveCPTile = this.activeCheckpointWPs.get(0);
            this.activeCheckpointWPs.clear();
            this.activeCheckpointWPs.add(lastActiveCPTile);
            this.pathActive = false;
            this.activePathDestination.objConfig = -1;
            this.activePathMismatchLastTick = true;
            return;
        }
        if (!currentWA.toWorldPoint().equals((Object)this.client.getLocalPlayer().getWorldLocation()) && this.pathActive) {
            if (this.activePathStartedLastTick) {
                LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.activePathDestination.worldPoint);
                if (localPoint != null) {
                    Pair<List<WorldPoint>, Boolean> pathResult = this.pathfinder.pathTo(localPoint.getSceneX(), localPoint.getSceneY(), this.activePathDestination.sizeX, this.activePathDestination.sizeY, this.activePathDestination.objConfig, this.activePathDestination.objID);
                    if (pathResult == null) {
                        return;
                    }
                    this.lastTickWorldLocation = this.client.getLocalPlayer().getWorldLocation();
                    this.pathActive = true;
                    this.activeCheckpointWPs = (List)pathResult.getLeft();
                    this.activePathFound = (Boolean)pathResult.getRight();
                    this.pathFromCheckpointTiles(this.activeCheckpointWPs, this.isRunning, this.activeMiddlePathTiles, this.activePathTiles, this.activePathFound);
                    this.activePathStartedLastTick = false;
                }
            } else if (this.activePathMismatchLastTick) {
                lastActiveCPTile = this.activeCheckpointWPs.get(0);
                this.activeCheckpointWPs.clear();
                this.activeCheckpointWPs.add(lastActiveCPTile);
                this.pathActive = false;
                this.activePathStartedLastTick = false;
            }
            this.activePathMismatchLastTick = true;
        } else {
            this.activePathMismatchLastTick = false;
        }
        for (int i = 0; i < cpTileIndex; ++i) {
            if (this.activeCheckpointWPs.size() <= 1) continue;
            this.activeCheckpointWPs.remove(0);
        }
    }

    private void updateNpcBlockings() {
        List npcs = this.client.getNpcs();
        this.npcBlockWAs.clear();
        for (NPC npc : npcs) {
            NPCComposition npcComposition = npc.getTransformedComposition();
            if (npcComposition == null || !PathMarkerPlugin.getNpcBlocking(npcComposition.getId())) continue;
            this.npcBlockWAs.add(npc.getWorldArea());
        }
    }

    private boolean willRunOnClick() {
        boolean willRun;
        boolean bl = willRun = this.client.getVarpValue(173) == 1;
        if (!this.ctrlHeld) {
            return willRun;
        }
        int ctrlSetting = this.client.getVarbitValue(13132);
        switch (ctrlSetting) {
            case 0: {
                return willRun;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return !willRun;
            }
        }
        return willRun;
    }

    TileItem findTileItem(int x, int y, int id) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        Tile tile = tiles[this.client.getPlane()][x][y];
        if (tile == null) {
            return null;
        }
        List tileItems = tile.getGroundItems();
        if (tileItems == null) {
            return null;
        }
        for (TileItem tileItem : tileItems) {
            if (tileItem == null || tileItem.getId() != id) continue;
            return tileItem;
        }
        return null;
    }

    TileObject findTileObject(int x, int y, int id) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        Tile tile = tiles[this.client.getPlane()][x][y];
        if (tile != null) {
            for (GameObject gameObject : tile.getGameObjects()) {
                if (gameObject == null || gameObject.getId() != id) continue;
                return gameObject;
            }
            WallObject wallObject = tile.getWallObject();
            if (wallObject != null && wallObject.getId() == id) {
                return wallObject;
            }
            DecorativeObject decorativeObject = tile.getDecorativeObject();
            if (decorativeObject != null && decorativeObject.getId() == id) {
                return decorativeObject;
            }
            GroundObject groundObject = tile.getGroundObject();
            if (groundObject != null && groundObject.getId() == id) {
                return groundObject;
            }
        }
        return null;
    }

    public static int getObjectBlocking(int objectId, int rotation) {
        if (objectBlocking == null) {
            return 0;
        }
        int blockingValue = objectBlocking.getOrDefault(objectId, 0);
        return rotation == 0 ? blockingValue : (blockingValue << rotation & 0xF) + (blockingValue >> 4 - rotation);
    }

    public static boolean getNpcBlocking(int npcCompId) {
        if (npcBlocking == null) {
            return false;
        }
        return npcBlocking.getOrDefault(npcCompId, 0) == 1;
    }

    private static Map<Integer, Integer> readFile(String name) {
        try {
            String line;
            InputStream inputStream = PathMarkerPlugin.class.getResourceAsStream(name);
            if (inputStream == null) {
                return null;
            }
            InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BufferedReader reader = new BufferedReader(streamReader);
            LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("=");
                int id = Integer.parseInt(split[0]);
                int blocking = Integer.parseInt(split[1].split(" ")[0]);
                map.put(id, blocking);
            }
            reader.close();
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Point minimapToScenePoint() {
        if (this.client.getMenuEntries().length != 1 || this.lastMouseCanvasPosition == null) {
            return null;
        }
        Widget minimapDrawWidget = this.client.isResized() ? (this.client.getVarbitValue(4607) == 1 ? this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA) : this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA)) : this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
        if (minimapDrawWidget == null || minimapDrawWidget.isHidden()) {
            return null;
        }
        if (!minimapDrawWidget.contains(this.lastMouseCanvasPosition)) {
            return null;
        }
        int widgetX = this.lastMouseCanvasPosition.getX() - minimapDrawWidget.getCanvasLocation().getX() - minimapDrawWidget.getWidth() / 2;
        int widgetY = this.lastMouseCanvasPosition.getY() - minimapDrawWidget.getCanvasLocation().getY() - minimapDrawWidget.getHeight() / 2;
        int angle = this.client.getMapAngle() & 0x7FF;
        int sine = (int)(65536.0 * Math.sin((double)angle * 0.0030679615));
        int cosine = (int)(65536.0 * Math.cos((double)angle * 0.0030679615));
        int xx = cosine * widgetX + widgetY * sine >> 11;
        int yy = widgetY * cosine - widgetX * sine >> 11;
        int deltaX = xx + this.client.getLocalPlayer().getLocalLocation().getSceneX() >> 7;
        int deltaY = this.client.getLocalPlayer().getLocalLocation().getSceneY() - yy >> 7;
        LocalPoint localPoint = this.client.getLocalPlayer().getLocalLocation();
        if (localPoint == null) {
            return null;
        }
        return new Point(localPoint.getSceneX() + deltaX, localPoint.getSceneY() + deltaY);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (event.getVarpId() == 173) {
            int[] varps = this.client.getVarps();
            this.isRunning = varps[173] == 1;
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        switch (event.getMenuAction()) {
            case EXAMINE_ITEM_GROUND: 
            case EXAMINE_NPC: 
            case EXAMINE_OBJECT: 
            case CANCEL: 
            case CC_OP: 
            case CC_OP_LOW_PRIORITY: 
            case PLAYER_EIGHTH_OPTION: 
            case WIDGET_CLOSE: 
            case WIDGET_CONTINUE: 
            case WIDGET_FIRST_OPTION: 
            case WIDGET_SECOND_OPTION: 
            case WIDGET_THIRD_OPTION: 
            case WIDGET_FOURTH_OPTION: 
            case WIDGET_FIFTH_OPTION: 
            case WIDGET_TARGET: 
            case WIDGET_TARGET_ON_WIDGET: 
            case WIDGET_TYPE_1: 
            case WIDGET_TYPE_4: 
            case WIDGET_TYPE_5: 
            case WIDGET_USE_ON_ITEM: 
            case RUNELITE: 
            case RUNELITE_HIGH_PRIORITY: 
            case RUNELITE_INFOBOX: 
            case RUNELITE_OVERLAY: 
            case RUNELITE_OVERLAY_CONFIG: 
            case RUNELITE_PLAYER: {
                return;
            }
            case GAME_OBJECT_FIRST_OPTION: 
            case GAME_OBJECT_SECOND_OPTION: 
            case GAME_OBJECT_THIRD_OPTION: 
            case GAME_OBJECT_FOURTH_OPTION: 
            case GAME_OBJECT_FIFTH_OPTION: 
            case WIDGET_TARGET_ON_GAME_OBJECT: 
            case GROUND_ITEM_FIRST_OPTION: 
            case GROUND_ITEM_SECOND_OPTION: 
            case GROUND_ITEM_THIRD_OPTION: 
            case GROUND_ITEM_FOURTH_OPTION: 
            case GROUND_ITEM_FIFTH_OPTION: 
            case WIDGET_TARGET_ON_GROUND_ITEM: {
                int x = event.getParam0();
                int y = event.getParam1();
                int id = event.getId();
                int config = -1;
                int sizeX = 1;
                int sizeY = 1;
                TileObject tileObject = this.findTileObject(x, y, id);
                TileItem tileItem = this.findTileItem(x, y, id);
                if (tileObject == null && tileItem == null) {
                    return;
                }
                this.isRunning = this.willRunOnClick();
                if (tileObject != null) {
                    if (tileObject instanceof GameObject) {
                        GameObject gameObject = (GameObject)tileObject;
                        config = gameObject.getConfig();
                        sizeX = gameObject.sizeX();
                        sizeY = gameObject.sizeY();
                    }
                    if (tileObject instanceof WallObject) {
                        WallObject wallObject = (WallObject)tileObject;
                        config = wallObject.getConfig();
                    }
                    if (tileObject instanceof DecorativeObject) {
                        DecorativeObject decorativeObject = (DecorativeObject)tileObject;
                        config = decorativeObject.getConfig();
                    }
                    if (tileObject instanceof GroundObject) {
                        GroundObject groundObject = (GroundObject)tileObject;
                        config = groundObject.getConfig();
                    }
                }
                WorldPoint worldPoint = WorldPoint.fromScene((Client)this.client, (int)x, (int)y, (int)this.client.getPlane());
                Pair<List<WorldPoint>, Boolean> pathResult = this.pathfinder.pathTo(x, y, sizeX, sizeY, config, id);
                this.activePathDestination = new PathDestination(worldPoint, sizeX, sizeY, config, id);
                if (pathResult == null) {
                    return;
                }
                this.lastTickWorldLocation = this.client.getLocalPlayer().getWorldLocation();
                this.pathActive = true;
                this.activeCheckpointWPs = (List)pathResult.getLeft();
                this.activePathFound = (Boolean)pathResult.getRight();
                this.pathFromCheckpointTiles(this.activeCheckpointWPs, this.isRunning, this.activeMiddlePathTiles, this.activePathTiles, this.activePathFound);
                this.activePathStartedLastTick = true;
                this.calcTilePathOnNextClientTick = false;
                return;
            }
            case NPC_FIRST_OPTION: 
            case NPC_SECOND_OPTION: 
            case NPC_THIRD_OPTION: 
            case NPC_FOURTH_OPTION: 
            case NPC_FIFTH_OPTION: 
            case WIDGET_TARGET_ON_NPC: 
            case PLAYER_FIRST_OPTION: 
            case PLAYER_SECOND_OPTION: 
            case PLAYER_THIRD_OPTION: 
            case PLAYER_FOURTH_OPTION: 
            case PLAYER_FIFTH_OPTION: 
            case PLAYER_SIXTH_OPTION: 
            case PLAYER_SEVENTH_OPTION: 
            case WIDGET_TARGET_ON_PLAYER: {
                Actor actor = event.getMenuEntry().getActor();
                if (actor == null) {
                    return;
                }
                this.isRunning = this.willRunOnClick();
                LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)actor.getWorldLocation());
                if (localPoint == null) {
                    return;
                }
                int x = localPoint.getSceneX();
                int y = localPoint.getSceneY();
                int size = 1;
                if (actor instanceof NPC) {
                    size = ((NPC)actor).getComposition().getSize();
                }
                WorldPoint worldPoint = WorldPoint.fromScene((Client)this.client, (int)x, (int)y, (int)this.client.getPlane());
                Pair<List<WorldPoint>, Boolean> pathResult = this.pathfinder.pathTo(x, y, size, size, -2, -1);
                this.activePathDestination = new PathDestination(worldPoint, size, size, -2, -1, actor);
                if (pathResult == null) {
                    return;
                }
                this.lastTickWorldLocation = this.client.getLocalPlayer().getWorldLocation();
                this.pathActive = true;
                this.activeCheckpointWPs = (List)pathResult.getLeft();
                this.activePathFound = (Boolean)pathResult.getRight();
                this.pathFromCheckpointTiles(this.activeCheckpointWPs, this.isRunning, this.activeMiddlePathTiles, this.activePathTiles, this.activePathFound);
                this.activePathStartedLastTick = true;
                this.calcTilePathOnNextClientTick = false;
                return;
            }
        }
        if (!this.client.isMenuOpen()) {
            this.calcTilePathOnNextClientTick = true;
            return;
        }
        if (this.oldSelectedSceneTile == null) {
            return;
        }
        this.isRunning = this.willRunOnClick();
        WorldPoint worldPoint = WorldPoint.fromScene((Client)this.client, (int)this.oldSelectedSceneTile.getSceneLocation().getX(), (int)this.oldSelectedSceneTile.getSceneLocation().getY(), (int)this.client.getPlane());
        Pair<List<WorldPoint>, Boolean> pathResult = this.pathfinder.pathTo(this.oldSelectedSceneTile);
        this.activePathDestination = new PathDestination(worldPoint, 1, 1, -1, -1);
        if (pathResult == null) {
            return;
        }
        this.lastTickWorldLocation = this.client.getLocalPlayer().getWorldLocation();
        this.pathActive = true;
        this.activeCheckpointWPs = (List)pathResult.getLeft();
        this.activePathFound = (Boolean)pathResult.getRight();
        this.pathFromCheckpointTiles(this.activeCheckpointWPs, this.isRunning, this.activeMiddlePathTiles, this.activePathTiles, this.activePathFound);
        this.activePathStartedLastTick = true;
        this.calcTilePathOnNextClientTick = event.getMenuAction() == MenuAction.WALK && !this.client.isMenuOpen();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.activeCheckpointWPs.clear();
                this.activeCheckpointWPs.add(new WorldPoint(0, 0, this.client.getPlane()));
                this.pathActive = false;
            }
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        Pair<List<WorldPoint>, Boolean> pathResult;
        Point point;
        Pair<List<WorldPoint>, Boolean> pathResult2;
        Tile selectedSceneTile;
        if (this.calcTilePathOnNextClientTick && (selectedSceneTile = this.client.getSelectedSceneTile()) != null) {
            this.isRunning = this.willRunOnClick();
            WorldPoint worldPoint = WorldPoint.fromScene((Client)this.client, (int)selectedSceneTile.getSceneLocation().getX(), (int)selectedSceneTile.getSceneLocation().getY(), (int)this.client.getPlane());
            pathResult2 = this.pathfinder.pathTo(selectedSceneTile);
            this.activePathDestination = new PathDestination(worldPoint, 1, 1, -1, -1);
            if (pathResult2 != null) {
                this.lastTickWorldLocation = this.client.getLocalPlayer().getWorldLocation();
                this.pathActive = true;
                this.activeCheckpointWPs = (List)pathResult2.getLeft();
                this.activePathFound = (Boolean)pathResult2.getRight();
                this.pathFromCheckpointTiles(this.activeCheckpointWPs, this.isRunning, this.activeMiddlePathTiles, this.activePathTiles, this.activePathFound);
                this.activePathStartedLastTick = true;
                this.calcTilePathOnNextClientTick = false;
            }
        }
        selectedSceneTile = this.client.getSelectedSceneTile();
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (menuEntries.length == 1 && !this.client.isMenuOpen() && (this.leftClicked || this.config.hoverPathDisplaySetting() != PathMarkerConfig.PathDisplaySetting.NEVER) && (point = this.minimapToScenePoint()) != null && (pathResult = this.pathfinder.pathTo(point.getX(), point.getY(), 1, 1, -1, -1)) != null) {
            this.hoverCheckpointWPs = (List)pathResult.getLeft();
            this.hoverPathFound = (Boolean)pathResult.getRight();
            if (this.hoverCheckpointWPs != null) {
                this.lastSelectedSceneTile = selectedSceneTile;
            }
            if (this.leftClicked) {
                this.isRunning = this.willRunOnClick();
                this.activePathDestination = new PathDestination(WorldPoint.fromScene((Client)this.client, (int)point.getX(), (int)point.getY(), (int)this.client.getPlane()), 1, 1, -1, -1);
                this.lastTickWorldLocation = this.client.getLocalPlayer().getWorldLocation();
                this.pathActive = true;
                this.activeCheckpointWPs = new ArrayList<WorldPoint>((Collection)pathResult.getLeft());
                this.activePathFound = (Boolean)pathResult.getRight();
                this.pathFromCheckpointTiles(this.activeCheckpointWPs, this.isRunning, this.activeMiddlePathTiles, this.activePathTiles, this.activePathFound);
                this.activePathStartedLastTick = true;
            }
        }
        if (this.lastSelectedSceneTile == null || this.lastSelectedSceneTile != selectedSceneTile || this.client.isMenuOpen() && this.hoveredMenuEntry(menuEntries) != this.lastSelectedMenuEntry || this.oldMenuEntries.length != menuEntries.length) {
            if (this.client.isMenuOpen()) {
                this.lastSelectedMenuEntry = this.hoveredMenuEntry(menuEntries);
            }
            if (selectedSceneTile != null && (pathResult2 = this.pathToHover()) != null) {
                this.hoverCheckpointWPs = (List)pathResult2.getLeft();
                this.hoverPathFound = (Boolean)pathResult2.getRight();
            }
        }
        this.oldSelectedSceneTile = this.client.getSelectedSceneTile();
        this.oldMenuEntries = menuEntries;
        this.leftClicked = false;
        this.lastMouseCanvasPosition = this.client.getMouseCanvasPosition();
        this.lastSelectedSceneTile = selectedSceneTile;
        this.pathFromCheckpointTiles(this.hoverCheckpointWPs, this.willRunOnClick(), this.hoverMiddlePathTiles, this.hoverPathTiles, this.hoverPathFound);
    }

    private MenuEntry hoveredMenuEntry(MenuEntry[] menuEntries) {
        int menuX = this.client.getMenuX();
        int menuY = this.client.getMenuY();
        int menuWidth = this.client.getMenuWidth();
        Point mousePosition = this.client.getMouseCanvasPosition();
        int dy = mousePosition.getY() - menuY;
        if ((dy -= 19) < 0) {
            return menuEntries[0];
        }
        int idx = dy / 15;
        idx = menuEntries.length - 1 - idx;
        if (mousePosition.getX() > menuX && mousePosition.getX() < menuX + menuWidth && idx >= 0 && idx < menuEntries.length) {
            return menuEntries[idx];
        }
        return menuEntries[0];
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Pair<List<WorldPoint>, Boolean> pathResult;
        LocalPoint localPoint;
        Pair<List<WorldPoint>, Boolean> pathResult2;
        WorldPoint worldDestinationLocation;
        LocalPoint localDestinationLocation = this.client.getLocalDestinationLocation();
        if (localDestinationLocation != null && this.pathActive && this.activePathFound && !(worldDestinationLocation = WorldPoint.fromLocal((Client)this.client, (LocalPoint)localDestinationLocation)).equals((Object)this.activeCheckpointWPs.get(this.activeCheckpointWPs.size() - 1)) && (pathResult2 = this.pathfinder.pathTo(localDestinationLocation.getSceneX(), localDestinationLocation.getSceneY(), this.activePathDestination.sizeX, this.activePathDestination.sizeY, this.activePathDestination.objConfig, this.activePathDestination.objID)) != null) {
            this.activeCheckpointWPs = (List)pathResult2.getLeft();
            this.activePathFound = (Boolean)pathResult2.getRight();
            this.activePathStartedLastTick = false;
        }
        this.updateNpcBlockings();
        WorldPoint currentWorldLocation = this.client.getLocalPlayer().getWorldLocation();
        if ((this.lastTickWorldLocation == null || this.lastTickWorldLocation != currentWorldLocation) && (pathResult2 = this.pathToHover()) != null) {
            this.hoverCheckpointWPs = (List)pathResult2.getLeft();
            this.hoverPathFound = (Boolean)pathResult2.getRight();
        }
        if (this.hoverCheckpointWPs != null && this.hoverCheckpointWPs.size() > 0) {
            this.pathFromCheckpointTiles(this.hoverCheckpointWPs, this.willRunOnClick(), this.hoverMiddlePathTiles, this.hoverPathTiles, this.hoverPathFound);
        }
        if (currentWorldLocation.equals((Object)this.activeCheckpointWPs.get(this.activeCheckpointWPs.size() - 1)) || this.lastTickWorldLocation != null && currentWorldLocation.distanceTo(this.lastTickWorldLocation) > 2) {
            this.pathActive = false;
        }
        this.updateCheckpointTiles();
        if (this.pathActive && this.activePathDestination.objConfig == -2 && this.activeCheckpointWPs.size() < 2 && (localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.activePathDestination.actor.getWorldLocation())) != null && (pathResult = this.pathfinder.pathTo(localPoint.getSceneX(), localPoint.getSceneY(), this.activePathDestination.sizeX, this.activePathDestination.sizeY, this.activePathDestination.objConfig, this.activePathDestination.objID)) != null) {
            this.pathActive = true;
            this.activeCheckpointWPs = (List)pathResult.getLeft();
            this.activePathFound = (Boolean)pathResult.getRight();
            this.activePathStartedLastTick = false;
        }
        this.pathFromCheckpointTiles(this.activeCheckpointWPs, this.isRunning, this.activeMiddlePathTiles, this.activePathTiles, this.activePathFound);
        this.lastTickWorldLocation = currentWorldLocation;
    }

    public void setCtrlHeld(boolean ctrlHeld) {
        this.ctrlHeld = ctrlHeld;
    }

    public List<WorldPoint> getActiveCheckpointWPs() {
        return this.activeCheckpointWPs;
    }

    public void setKeyDisplayActivePath(boolean keyDisplayActivePath) {
        this.keyDisplayActivePath = keyDisplayActivePath;
    }

    public boolean isKeyDisplayActivePath() {
        return this.keyDisplayActivePath;
    }

    public void setKeyDisplayHoverPath(boolean keyDisplayHoverPath) {
        this.keyDisplayHoverPath = keyDisplayHoverPath;
    }

    public boolean isKeyDisplayHoverPath() {
        return this.keyDisplayHoverPath;
    }

    public void setLeftClicked(boolean leftClicked) {
        this.leftClicked = leftClicked;
    }

    public boolean isPathActive() {
        return this.pathActive;
    }

    public List<WorldPoint> getHoverPathTiles() {
        return this.hoverPathTiles;
    }

    public List<WorldPoint> getHoverMiddlePathTiles() {
        return this.hoverMiddlePathTiles;
    }

    public List<WorldPoint> getActivePathTiles() {
        return this.activePathTiles;
    }

    public List<WorldPoint> getActiveMiddlePathTiles() {
        return this.activeMiddlePathTiles;
    }

    public void setLastMouseCanvasPosition(Point lastMouseCanvasPosition) {
        this.lastMouseCanvasPosition = lastMouseCanvasPosition;
    }

    private /* synthetic */ boolean lambda$updateCheckpointTiles$3(WorldArea finalCurrentWA, int dx, int dy, WorldPoint worldPoint) {
        WorldPoint worldPoint1 = new WorldPoint(finalCurrentWA.getX() + dx, finalCurrentWA.getY(), this.client.getPlane());
        WorldPoint worldPoint2 = new WorldPoint(finalCurrentWA.getX(), finalCurrentWA.getY() + dy, this.client.getPlane());
        WorldPoint worldPoint3 = new WorldPoint(finalCurrentWA.getX() + dx, finalCurrentWA.getY() + dy, this.client.getPlane());
        for (WorldArea worldArea : this.npcBlockWAs) {
            if (!worldArea.contains(worldPoint1) && !worldArea.contains(worldPoint2) && !worldArea.contains(worldPoint3)) continue;
            return false;
        }
        return true;
    }

    private /* synthetic */ boolean lambda$pathFromCheckpointTiles$0(WorldArea finalCurrentWA, int dx, int dy, WorldPoint worldPoint) {
        WorldPoint worldPoint1 = new WorldPoint(finalCurrentWA.getX() + dx, finalCurrentWA.getY(), this.client.getPlane());
        WorldPoint worldPoint2 = new WorldPoint(finalCurrentWA.getX(), finalCurrentWA.getY() + dy, this.client.getPlane());
        WorldPoint worldPoint3 = new WorldPoint(finalCurrentWA.getX() + dx, finalCurrentWA.getY() + dy, this.client.getPlane());
        for (WorldArea worldArea : this.npcBlockWAs) {
            if (!worldArea.contains(worldPoint1) && !worldArea.contains(worldPoint2) && !worldArea.contains(worldPoint3)) continue;
            return false;
        }
        return true;
    }

    static class PathDestination {
        private WorldPoint worldPoint;
        private int sizeX;
        private int sizeY;
        private int objConfig;
        private int objID;
        private Actor actor;

        public PathDestination(WorldPoint worldPoint, int sizeX, int sizeY, int objConfig, int objID) {
            this.worldPoint = worldPoint;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.objConfig = objConfig;
            this.objID = objID;
            this.actor = null;
        }

        public PathDestination(WorldPoint worldPoint, int sizeX, int sizeY, int objConfig, int objID, Actor actor) {
            this.worldPoint = worldPoint;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.objConfig = objConfig;
            this.objID = objID;
            this.actor = actor;
        }
    }
}

