/*
 * Decompiled with CFR 0.152.
 */
package com.pathmarker;

import com.pathmarker.PathMarkerConfig;
import com.pathmarker.PathMarkerPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class PathMarkerOverlay
extends Overlay {
    private final Client client;
    private final PathMarkerPlugin plugin;
    @Inject
    private PathMarkerConfig config;

    @Inject
    private PathMarkerOverlay(Client client, PathMarkerConfig config, PathMarkerPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!(this.config.hoverPathDisplaySetting() == PathMarkerConfig.PathDisplaySetting.NEVER || this.config.activePathDisplaySetting() != PathMarkerConfig.PathDisplaySetting.NEVER && this.plugin.isPathActive() && this.config.drawOnlyIfNoActivePath() || !this.plugin.isKeyDisplayHoverPath() && this.config.hoverPathDisplaySetting() != PathMarkerConfig.PathDisplaySetting.ALWAYS)) {
            for (WorldPoint worldPoint : this.plugin.getHoverPathTiles()) {
                if (this.config.hoverPathDrawLocations() != PathMarkerConfig.drawLocations.BOTH && this.config.hoverPathDrawLocations() != PathMarkerConfig.drawLocations.GAME_WORLD || this.config.hoverPathDrawMode() != PathMarkerConfig.DrawMode.FULL_PATH && worldPoint != this.plugin.getHoverPathTiles().get(this.plugin.getHoverPathTiles().size() - 1)) continue;
                switch (this.config.hoverPathMarkerStyle()) {
                    case TILE: {
                        this.renderTile(graphics, worldPoint, this.config.hoverPathStroke1(), this.config.hoverPathFill1());
                        break;
                    }
                    case DOT: {
                        this.renderDots(graphics, worldPoint, this.config.hoverPathStroke1(), this.config.hoverPathFill1());
                    }
                }
            }
            for (WorldPoint worldPoint : this.plugin.getHoverMiddlePathTiles()) {
                if (this.config.hoverPathDrawLocations() != PathMarkerConfig.drawLocations.BOTH && this.config.hoverPathDrawLocations() != PathMarkerConfig.drawLocations.GAME_WORLD || this.config.hoverPathDrawMode() != PathMarkerConfig.DrawMode.FULL_PATH && worldPoint != this.plugin.getHoverPathTiles().get(this.plugin.getHoverPathTiles().size() - 1)) continue;
                switch (this.config.hoverPathMarkerStyle()) {
                    case TILE: {
                        this.renderTile(graphics, worldPoint, this.config.hoverPathStroke2(), this.config.hoverPathFill2());
                        break;
                    }
                    case DOT: {
                        this.renderDots(graphics, worldPoint, this.config.hoverPathStroke2(), this.config.hoverPathFill2());
                    }
                }
            }
        }
        if (this.config.activePathDisplaySetting() != PathMarkerConfig.PathDisplaySetting.NEVER && this.plugin.isPathActive() && (this.plugin.isKeyDisplayActivePath() || this.config.activePathDisplaySetting() == PathMarkerConfig.PathDisplaySetting.ALWAYS)) {
            for (WorldPoint worldPoint : this.plugin.getActivePathTiles()) {
                if (this.config.activePathDrawLocations() != PathMarkerConfig.drawLocations.BOTH && this.config.activePathDrawLocations() != PathMarkerConfig.drawLocations.GAME_WORLD || this.config.activePathDrawMode() != PathMarkerConfig.DrawMode.FULL_PATH && worldPoint != this.plugin.getActivePathTiles().get(this.plugin.getActivePathTiles().size() - 1)) continue;
                switch (this.config.activePathMarkerStyle()) {
                    case TILE: {
                        this.renderTile(graphics, worldPoint, this.config.activePathStroke1(), this.config.activePathFill1());
                        break;
                    }
                    case DOT: {
                        this.renderDots(graphics, worldPoint, this.config.activePathStroke1(), this.config.activePathFill1());
                    }
                }
            }
            for (WorldPoint worldPoint : this.plugin.getActiveMiddlePathTiles()) {
                if (this.config.activePathDrawLocations() != PathMarkerConfig.drawLocations.BOTH && this.config.activePathDrawLocations() != PathMarkerConfig.drawLocations.GAME_WORLD || this.config.activePathDrawMode() != PathMarkerConfig.DrawMode.FULL_PATH && worldPoint != this.plugin.getActivePathTiles().get(this.plugin.getActivePathTiles().size() - 1)) continue;
                switch (this.config.activePathMarkerStyle()) {
                    case TILE: {
                        this.renderTile(graphics, worldPoint, this.config.activePathStroke2(), this.config.activePathFill2());
                        break;
                    }
                    case DOT: {
                        this.renderDots(graphics, worldPoint, this.config.activePathStroke2(), this.config.activePathFill2());
                    }
                }
            }
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, WorldPoint worldPoint, Color stroke_color, Color fill_color) {
        BasicStroke stroke = new BasicStroke(1.0f);
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly == null) {
            return;
        }
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)stroke_color, (Color)fill_color, (Stroke)stroke);
    }

    private void renderDots(Graphics2D graphics, WorldPoint worldPoint, Color stroke_color, Color fill_color) {
        BasicStroke stroke = new BasicStroke(2.0f);
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (lp == null) {
            return;
        }
        Point screenPoint = Perspective.localToCanvas((Client)this.client, (LocalPoint)lp, (int)0);
        Ellipse2D.Double dot = new Ellipse2D.Double(screenPoint.getX(), screenPoint.getY(), 8.0, 8.0);
        if (dot == null) {
            return;
        }
        OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)dot, (Color)stroke_color, (Color)fill_color, (Stroke)stroke);
    }
}

