/*
 * Decompiled with CFR 0.152.
 */
package com.pathmarker;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Keybind;

@ConfigGroup(value="pathmarker")
public interface PathMarkerConfig
extends Config {
    @ConfigSection(name="Active Path", description="All options related to your active path", position=0)
    public static final String activePathSection = "activePath";
    @ConfigSection(name="Hover-Path", description="All options related to the path to the hovered location", position=1)
    public static final String hoverPathSection = "hoverPath";

    @ConfigItem(keyName="activePathDrawLocations", name="Draw location(s)", description="Marks your active path on the game world and/or the minimap", section="activePath")
    default public drawLocations activePathDrawLocations() {
        return drawLocations.BOTH;
    }

    @ConfigItem(keyName="activePathDrawMode", name="Draw mode", description="Determines which tiles are drawn", section="activePath")
    default public DrawMode activePathDrawMode() {
        return DrawMode.FULL_PATH;
    }

    @ConfigItem(keyName="activePathMarkerStyle", name="Marker Style", description="Shape of the path markers that are drawn", section="activePath")
    default public MarkerStyle activePathMarkerStyle() {
        return MarkerStyle.TILE;
    }

    @Alpha
    @ConfigItem(keyName="activePathStroke1", name="Main outline color", description="The main outline color of your active path", section="activePath")
    default public Color activePathStroke1() {
        return new Color(255, 0, 0, 255);
    }

    @Alpha
    @ConfigItem(keyName="activePathFill1", name="Main fill color", description="The main fill color of your active path", section="activePath")
    default public Color activePathFill1() {
        return new Color(255, 0, 0, 50);
    }

    @Alpha
    @ConfigItem(keyName="activePathStroke2", name="Secondary outline color", description="The secondary outline color of your active path, indicating the tiles you 'skip' while running.", section="activePath")
    default public Color activePathStroke2() {
        return new Color(255, 255, 0, 255);
    }

    @Alpha
    @ConfigItem(keyName="activePathFill2", name="Secondary fill color", description="The secondary fill color of your active path, indicating the tiles you 'skip' while running.", section="activePath")
    default public Color activePathFill2() {
        return new Color(255, 255, 0, 50);
    }

    @ConfigItem(keyName="activePathDisplaySetting", name="Display", description="Configures when the active path should be displayed", section="activePath")
    default public PathDisplaySetting activePathDisplaySetting() {
        return PathDisplaySetting.ALWAYS;
    }

    @ConfigItem(keyName="displayKeybindActivePath", name="Keybind", description="Sets the keybind for the Display setting.", section="activePath")
    default public Keybind displayKeybindActivePath() {
        return Keybind.NOT_SET;
    }

    @ConfigItem(keyName="hoverPathDrawLocations", name="Draw location(s)", description="Marks your hover-path on the game world and/or the minimap", section="hoverPath")
    default public drawLocations hoverPathDrawLocations() {
        return drawLocations.MINIMAP;
    }

    @ConfigItem(keyName="hoverPathDrawMode", name="Draw mode", description="Determines which tiles are drawn", section="hoverPath")
    default public DrawMode hoverPathDrawMode() {
        return DrawMode.FULL_PATH;
    }

    @ConfigItem(keyName="hoverPathMarkerStyle", name="Marker Style", description="Shape of the path markers that are drawn", section="hoverPath")
    default public MarkerStyle hoverPathMarkerStyle() {
        return MarkerStyle.TILE;
    }

    @Alpha
    @ConfigItem(keyName="hoverPathStroke1", name="Main outline color", description="The main outline color of the hover-path", section="hoverPath")
    default public Color hoverPathStroke1() {
        return new Color(255, 0, 255, 255);
    }

    @Alpha
    @ConfigItem(keyName="hoverPathFill1", name="Main fill color", description="The main fill color of the hover-path", section="hoverPath")
    default public Color hoverPathFill1() {
        return new Color(255, 0, 255, 50);
    }

    @Alpha
    @ConfigItem(keyName="hoverPathStroke2", name="Secondary outline color", description="The secondary outline color of the hover-path, indicating the tiles you 'skip' while running.", section="hoverPath")
    default public Color hoverPathStroke2() {
        return new Color(0, 255, 0, 255);
    }

    @Alpha
    @ConfigItem(keyName="hoverPathFill2", name="Secondary fill color", description="The secondary fill color of the hover-path, indicating the tiles you 'skip' while running.", section="hoverPath")
    default public Color hoverPathFill2() {
        return new Color(0, 255, 0, 50);
    }

    @ConfigItem(keyName="hoverPathDisplaySetting", name="Display", description="Configures when the hover-path should be displayed", section="hoverPath")
    default public PathDisplaySetting hoverPathDisplaySetting() {
        return PathDisplaySetting.ALWAYS;
    }

    @ConfigItem(keyName="displayKeybindHoverPath", name="Keybind", description="Sets the keybind for the Display setting.", section="hoverPath")
    default public Keybind displayKeybindHoverPath() {
        return Keybind.NOT_SET;
    }

    @ConfigItem(keyName="drawOnlyIfNoActivePath", name="Draw only if no active path", description="Marks the path to your hovered location only if you don't have an active path visible", position=0, section="hoverPath")
    default public boolean drawOnlyIfNoActivePath() {
        return false;
    }

    public static enum PathDisplaySetting {
        ALWAYS,
        WHILE_KEY_PRESSED,
        TOGGLE_ON_KEYPRESS,
        NEVER;

    }

    public static enum MarkerStyle {
        TILE,
        DOT;

    }

    public static enum DrawMode {
        FULL_PATH,
        TARGET_TILE;

    }

    public static enum drawLocations {
        BOTH,
        GAME_WORLD,
        MINIMAP;

    }
}

