/*
 * Decompiled with CFR 0.152.
 */
package com.dukebarrelswap;

import com.dukebarrelswap.DukeBarrelSwapConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Duke Barrel Swap", description="Swaps Fill & Check for Duke Sucellus Fermentation Barrels when uncrushed mushrooms are in inventory")
public class DukeBarrelSwapPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DukeBarrelSwapPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DukeBarrelSwapConfig config;
    public static final int DUKE_SUCELLUS_REGION_ID = 12132;
    public static final int UNCRUSHED_MUSCA_MUSHROOM_ID = 28341;
    public static final int CRUSHED_MUSCA_MUSHROOM_ID = 28342;
    public static final int UNCRUSHED_ARDER_MUSHROOM_ID = 28345;
    public static final int CRUSHED_ARDER_MUSHROOM_ID = 28346;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            // empty if block
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.isInDukeRoom()) {
            boolean barrelSwap;
            ItemContainer inv = this.client.getItemContainer(InventoryID.INVENTORY);
            if (inv == null) {
                return;
            }
            boolean hasUncrushedMushroom = DukeBarrelSwapPlugin.containsAny(inv);
            if (!hasUncrushedMushroom) {
                return;
            }
            if (this.config.enableSwap() && (barrelSwap = DukeBarrelSwapPlugin.isFillBarrel(event.getMenuEntry()))) {
                event.getMenuEntry().setDeprioritized(true);
            }
        }
    }

    @Provides
    DukeBarrelSwapConfig provideConfig(ConfigManager configManager) {
        return (DukeBarrelSwapConfig)configManager.getConfig(DukeBarrelSwapConfig.class);
    }

    public boolean isInDukeRoom() {
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)12132);
    }

    private static boolean containsAny(ItemContainer itemContainer) {
        for (Item item : itemContainer.getItems()) {
            if (28341 != item.getId() && 28345 != item.getId()) continue;
            return true;
        }
        return false;
    }

    private static boolean isFillBarrel(MenuEntry menuEntry) {
        return menuEntry.getOption().equals("Fill") && menuEntry.getTarget().contains("Fermentation Vat");
    }
}

