/*
 * Decompiled with CFR 0.152.
 */
package com.monsterhp;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import com.monsterhp.MonsterHPConfig;
import com.monsterhp.MonsterHPOverlay;
import com.monsterhp.WanderingNPC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Monster HP Percentage")
public class MonsterHPPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MonsterHPPlugin.class);
    @Inject
    private Client client;
    @Inject
    private MonsterHPConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MonsterHPOverlay monsterhpoverlay;
    private final Map<Integer, WanderingNPC> wanderingNPCs = new HashMap<Integer, WanderingNPC>();
    private List<String> selectedNPCs = new ArrayList<String>();
    private boolean npcShowAll = true;
    private HashMap<Integer, WorldPoint> npcLocations = new HashMap();

    @Provides
    MonsterHPConfig getConfig(ConfigManager configManager) {
        return (MonsterHPConfig)configManager.getConfig(MonsterHPConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.monsterhpoverlay);
        this.selectedNPCs = this.getSelectedNPCs();
        this.npcShowAll = this.config.npcShowAll();
        this.rebuildAllNpcs();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.monsterhpoverlay);
        this.wanderingNPCs.clear();
        this.npcLocations.clear();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        int npcId = npc.getId();
        if (this.checkNPCName(npcName)) {
            return;
        }
        this.wanderingNPCs.putIfAbsent(npc.getIndex(), new WanderingNPC(npc));
        this.npcLocations.put(npc.getIndex(), npc.getWorldLocation());
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.wanderingNPCs.remove(npc.getIndex());
        this.npcLocations.remove(npc.getIndex());
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.wanderingNPCs.clear();
            this.npcLocations.clear();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        HashMap<WorldPoint, Integer> locationCount = new HashMap<WorldPoint, Integer>();
        for (WorldPoint location : this.npcLocations.values()) {
            if (locationCount.containsKey(location)) {
                locationCount.put(location, (Integer)locationCount.get(location) + 1);
                continue;
            }
            locationCount.put(location, 1);
        }
        for (NPC npc : this.client.getNpcs()) {
            WanderingNPC wnpc;
            String npcName = npc.getName();
            if (this.checkNPCName(npcName) || (wnpc = this.wanderingNPCs.get(npc.getIndex())) == null) continue;
            double monsterHP = 0.0;
            if (!this.config.showOverlay()) continue;
            monsterHP = (double)npc.getHealthRatio() / (double)npc.getHealthScale() * 100.0;
            if (!npc.isDead()) {
                if (npc.getHealthRatio() / npc.getHealthScale() != 1) {
                    wnpc.setHealthRatio(monsterHP);
                    wnpc.setCurrentLocation(npc.getWorldLocation());
                    wnpc.setDead(false);
                    if (locationCount.containsKey(wnpc.getCurrentLocation())) {
                        wnpc.setOffset((Integer)locationCount.get(wnpc.getCurrentLocation()) - 1);
                        locationCount.put(wnpc.getCurrentLocation(), (Integer)locationCount.get(wnpc.getCurrentLocation()) - 1);
                    }
                }
            } else if (npc.isDead()) {
                wnpc.setHealthRatio(0.0);
                if (this.config.hideDeath()) {
                    wnpc.setDead(true);
                }
            }
            this.npcLocations.put(wnpc.getNpcIndex(), wnpc.getCurrentLocation());
        }
    }

    private boolean checkNPCName(String npcName) {
        if (npcName == null || !this.selectedNPCs.contains(npcName.toLowerCase())) {
            return !this.npcShowAll;
        }
        return false;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (Objects.equals(configChanged.getGroup(), "MonsterHP") && (Objects.equals(configChanged.getKey(), "npcShowAll") || Objects.equals(configChanged.getKey(), "npcToShowHp"))) {
            this.selectedNPCs = this.getSelectedNPCs();
            this.npcShowAll = this.config.npcShowAll();
            this.rebuildAllNpcs();
        }
    }

    @VisibleForTesting
    List<String> getSelectedNPCs() {
        String configNPCs = this.config.npcToShowHp().toLowerCase();
        if (configNPCs.isEmpty()) {
            return Collections.emptyList();
        }
        return Text.fromCSV((String)configNPCs);
    }

    private void rebuildAllNpcs() {
        this.wanderingNPCs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            String npcName = npc.getName();
            if (this.checkNPCName(npcName)) continue;
            this.wanderingNPCs.putIfAbsent(npc.getIndex(), new WanderingNPC(npc));
            this.npcLocations.put(npc.getIndex(), npc.getWorldLocation());
        }
    }

    Map<Integer, WanderingNPC> getWanderingNPCs() {
        return this.wanderingNPCs;
    }
}

