/*
 * Decompiled with CFR 0.152.
 */
package com.monsterhp;

import com.monsterhp.MonsterHPConfig;
import com.monsterhp.MonsterHPPlugin;
import com.monsterhp.WanderingNPC;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.client.game.NPCManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonsterHPOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(MonsterHPOverlay.class);
    private final MonsterHPPlugin plugin;
    private final MonsterHPConfig config;
    private NPCManager npcManager;
    protected String lastFont = "";
    protected int lastFontSize = 0;
    protected boolean useRunescapeFont = true;
    protected MonsterHPConfig.FontStyle lastFontStyle = MonsterHPConfig.FontStyle.DEFAULT;
    protected Font font = null;
    NumberFormat format = new DecimalFormat("#");
    NumberFormat oneDecimalFormat = new DecimalFormat("#.#");
    NumberFormat twoDecimalFormat = new DecimalFormat("#.##");

    @Inject
    MonsterHPOverlay(MonsterHPPlugin plugin, MonsterHPConfig config, NPCManager npcManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
        this.npcManager = npcManager;
    }

    protected void handleFont(Graphics2D graphics) {
        if (this.font != null) {
            graphics.setFont(this.font);
            if (this.useRunescapeFont) {
                graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
        }
    }

    public Dimension render(Graphics2D graphics) {
        this.updateFont();
        this.handleFont(graphics);
        if (this.config.showOverlay()) {
            this.plugin.getWanderingNPCs().forEach((id, npc) -> this.renderTimer((WanderingNPC)npc, graphics));
        }
        return null;
    }

    private String getCurrentHpString(WanderingNPC npc) {
        String currentHPString;
        if (this.config.numericHealth()) {
            currentHPString = String.valueOf((int)npc.getCurrentHp());
        } else {
            switch (this.config.decimalHp()) {
                case 1: {
                    currentHPString = String.valueOf(this.oneDecimalFormat.format(npc.getHealthRatio()));
                    break;
                }
                case 2: {
                    currentHPString = String.valueOf(this.twoDecimalFormat.format(npc.getHealthRatio()));
                    break;
                }
                default: {
                    currentHPString = String.valueOf(this.format.format(npc.getHealthRatio()));
                }
            }
        }
        return currentHPString;
    }

    private void renderTimer(WanderingNPC npc, Graphics2D graphics) {
        if (npc.isDead()) {
            return;
        }
        Color timerColor = this.config.normalHPColor();
        if (this.config.numericHealth()) {
            try {
                boolean isHealthBelowThreshold = npc.getHealthRatio() < (double)this.config.lowHPThreshold();
                double numericHealth = Math.round(npc.getHealthRatio() / 100.0 * (double)this.npcManager.getHealth(npc.getId()).intValue());
                npc.setCurrentHp(numericHealth);
                if (this.config.useLowHP() && isHealthBelowThreshold) {
                    timerColor = this.config.lowHPColor();
                }
            }
            catch (Exception e) {
                log.error("there was an error:" + e);
            }
        } else if (this.config.useLowHP() && npc.getHealthRatio() < (double)this.config.lowHPThreshold()) {
            timerColor = this.config.lowHPColor();
        }
        String currentHPString = this.getCurrentHpString(npc);
        Point canvasPoint = this.config.aboveHPBar() ? npc.getNpc().getCanvasTextLocation(graphics, currentHPString, npc.getNpc().getLogicalHeight() + this.config.HPHeight()) : npc.getNpc().getCanvasTextLocation(graphics, currentHPString, this.config.HPHeight());
        if (canvasPoint == null) {
            return;
        }
        if (this.config.stackHp()) {
            int offSet = (int)((double)(npc.getOffset() * this.config.fontSize()) * 0.85);
            Point stackOffset = new Point(canvasPoint.getX(), canvasPoint.getY() + offSet);
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)stackOffset, (String)currentHPString, (Color)timerColor);
        } else {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasPoint, (String)currentHPString, (Color)timerColor);
        }
    }

    private void updateFont() {
        if (!this.lastFont.equals(this.config.fontName()) || this.lastFontSize != this.config.fontSize() || this.lastFontStyle != this.config.fontStyle()) {
            if (this.config.customFont()) {
                this.lastFont = this.config.fontName();
            }
            this.lastFontSize = this.config.fontSize();
            this.lastFontStyle = this.config.fontStyle();
            if (this.config.fontName().equals("") || !this.config.customFont()) {
                this.font = this.config.fontSize() < 16 ? FontManager.getRunescapeSmallFont() : (this.config.fontStyle() == MonsterHPConfig.FontStyle.BOLD || this.config.fontStyle() == MonsterHPConfig.FontStyle.BOLD_ITALICS ? FontManager.getRunescapeBoldFont() : FontManager.getRunescapeFont());
                if (this.config.fontSize() > 16) {
                    this.font = this.font.deriveFont((float)this.config.fontSize());
                }
                if (this.config.fontStyle() == MonsterHPConfig.FontStyle.BOLD) {
                    this.font = this.font.deriveFont(1);
                }
                if (this.config.fontStyle() == MonsterHPConfig.FontStyle.ITALICS) {
                    this.font = this.font.deriveFont(2);
                }
                if (this.config.fontStyle() == MonsterHPConfig.FontStyle.BOLD_ITALICS) {
                    this.font = this.font.deriveFont(3);
                }
                this.useRunescapeFont = true;
                return;
            }
            int style = 0;
            switch (this.config.fontStyle()) {
                case BOLD: {
                    style = 1;
                    break;
                }
                case ITALICS: {
                    style = 2;
                    break;
                }
                case BOLD_ITALICS: {
                    style = 3;
                }
            }
            this.font = new Font(this.config.fontName(), style, this.config.fontSize());
            this.useRunescapeFont = false;
        }
    }
}

