/*
 * Decompiled with CFR 0.152.
 */
package com.monsterhp;

import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="MonsterHP")
public interface MonsterHPConfig
extends Config {
    @ConfigSection(name="hp settings", description="Settings relating to hp", position=1)
    public static final String hp_settings = "hp_settings";
    @ConfigSection(name="font settings", description="Settings relating to fonts", position=2)
    public static final String font_settings = "font_settings";

    @ConfigItem(position=0, keyName="showOverlay", name="Show HP over chosen NPCs", description="Configures whether or not to have the HP shown over the chosen NPCs")
    default public boolean showOverlay() {
        return true;
    }

    @ConfigItem(position=1, keyName="npcToShowHp", name="NPC Names", description="Enter names of NPCs where you wish to use this plugin", section="hp_settings")
    default public String npcToShowHp() {
        return "";
    }

    @ConfigItem(position=2, keyName="npcShowAll", name="Show All", description="Show for all NPCs", section="hp_settings")
    default public boolean npcShowAll() {
        return false;
    }

    @Range(max=300)
    @ConfigItem(position=3, keyName="normalHPColor", name="Default hp overlay color", description="Choose the color to be used on the hp", section="hp_settings")
    default public Color normalHPColor() {
        return Color.GREEN;
    }

    @ConfigItem(position=4, keyName="useLowHP", name="Use low HP threshold", description="Configures whether or not you wish to use a 2nd color when the monster hp hits below the low hp threshold", section="hp_settings")
    default public boolean useLowHP() {
        return true;
    }

    @ConfigItem(position=5, keyName="lowHPThreshold", name="Low HP threshold", description="Used to set the low HP threshold", section="hp_settings")
    default public int lowHPThreshold() {
        return 25;
    }

    @ConfigItem(position=6, keyName="lowHPColor", name="Overlay color Low HP", description="Choose the color to be used when the hp of the npc is below the chosen hp threshold", section="hp_settings")
    default public Color lowHPColor() {
        return Color.RED;
    }

    @ConfigItem(position=7, keyName="aboveHPBar", name="Above HP bar", description="Hp above the monsters hp bar, otherwise the Hp is show on the body of the NPC", section="hp_settings")
    default public boolean aboveHPBar() {
        return true;
    }

    @ConfigItem(position=8, keyName="HPHeight", name="Height of the HP", description="Change the vertical offset of the HP above the npc body or the HP bar", section="hp_settings")
    default public int HPHeight() {
        return 50;
    }

    @ConfigItem(position=9, keyName="hideDeath", name="Hide hp on death", description="Hides the hp when the npc dies. Works nicely with the entity hider: Hide Dead NPCs option", section="hp_settings")
    default public boolean hideDeath() {
        return false;
    }

    @ConfigItem(position=10, keyName="stackHp", name="Stack monster HP", description="Stacks the HP numbers on top of each other if multiple npc's are on the same tile", section="hp_settings")
    default public boolean stackHp() {
        return false;
    }

    @Range(min=0, max=2)
    @ConfigItem(position=11, keyName="decimalHp", name="Amount of decimals", description="Show 0-2 decimals of precision, e.g. 13.33 instead of 13.", section="hp_settings")
    default public int decimalHp() {
        return 0;
    }

    @ConfigItem(position=11, keyName="customFont", name="Enable custom fonts", description="Enabling this setting makes it possible to use the custom font from the box below this", section="font_settings")
    default public boolean customFont() {
        return true;
    }

    @ConfigItem(position=12, keyName="fontName", name="Font", description="Name of the font to use for the hp shown. Leave blank to use RuneLite setting.", section="font_settings")
    default public String fontName() {
        return "roboto";
    }

    @ConfigItem(position=13, keyName="fontStyle", name="Font style", description="Style of the font to use for the hp shown. Only works with custom font.", section="font_settings")
    default public FontStyle fontStyle() {
        return FontStyle.DEFAULT;
    }

    @ConfigItem(position=14, keyName="fontSize", name="Font size", description="Size of the font to use for XP drops. Only works with custom font.", section="font_settings")
    default public int fontSize() {
        return 15;
    }

    @ConfigItem(position=15, keyName="numericHealth", name="Numeric Health", description="Show the numeric health of the monster instead of precentage.", section="hp_settings")
    default public boolean numericHealth() {
        return false;
    }

    public static enum FontStyle {
        BOLD("Bold"),
        ITALICS("Italics"),
        BOLD_ITALICS("Bold and italics"),
        DEFAULT("Default");

        String name;

        private FontStyle(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

