/*
 * Decompiled with CFR 0.152.
 */
package com.toagearcheck;

import com.toagearcheck.ItemPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.Player;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ToaGearCheckPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(ToaGearCheckPanel.class);
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    private final JTabbedPane partyTabs;

    public ToaGearCheckPanel() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel partyApplicants = new JPanel(new GridBagLayout());
        this.partyTabs = new JTabbedPane();
        GridBagConstraints tabConstraints = new GridBagConstraints();
        tabConstraints.fill = 1;
        tabConstraints.weightx = 1.0;
        tabConstraints.weighty = 1.0;
        partyApplicants.add((Component)this.partyTabs, tabConstraints);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(partyApplicants));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(partyApplicants));
    }

    public void updatePanel(HashMap<Player, List<ItemComposition>> playerList) {
        SwingUtilities.invokeLater(() -> {
            String lastUserSelected = "";
            if (this.partyTabs.getSelectedIndex() != -1) {
                lastUserSelected = this.partyTabs.getTitleAt(this.partyTabs.getSelectedIndex());
            }
            this.partyTabs.removeAll();
            if (playerList.size() == 0) {
                return;
            }
            for (Map.Entry player : playerList.entrySet()) {
                JPanel equipmentPanels = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 2;
                c.weightx = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                for (ItemComposition itemComposition : (List)player.getValue()) {
                    AsyncBufferedImage itemImage = this.itemManager.getImage(itemComposition.getId());
                    equipmentPanels.add((Component)new ItemPanel(itemComposition, itemImage), c);
                    ++c.gridy;
                }
                this.partyTabs.addTab(((Player)player.getKey()).getName(), equipmentPanels);
                if (!((Player)player.getKey()).getName().equals(lastUserSelected)) continue;
                this.partyTabs.setSelectedComponent(equipmentPanels);
            }
            this.repaint();
            this.revalidate();
        });
    }
}

