/*
 * Decompiled with CFR 0.152.
 */
package com.toagearcheck;

import com.toagearcheck.ToaGearCheckPanel;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.kit.KitType;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToA Party Gear Checker", description="Checks gear of party applicants", tags={"toa", "raids3", "tombs of amascut"})
public class ToAGearCheckPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ToAGearCheckPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar pluginToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    private static final int PartyApplicantWidgetGroup = 774;
    private static final int PartyApplicantWidgetChild = 48;
    private NavigationButton navButton;
    private boolean navButtonAdded = false;
    private boolean checkingApplicants = false;
    private ToaGearCheckPanel toaGearCheckPanel;

    protected void startUp() throws Exception {
        this.toaGearCheckPanel = (ToaGearCheckPanel)((Object)this.injector.getInstance(ToaGearCheckPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(ToAGearCheckPlugin.class, (String)"panelimage.png");
        this.navButton = NavigationButton.builder().tooltip("ToA Party Gear Checker").icon(icon).priority(10).panel((PluginPanel)this.toaGearCheckPanel).build();
    }

    protected void shutDown() throws Exception {
        this.pluginToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    private void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 774) {
            this.checkingApplicants = true;
            this.refreshPanel();
            SwingUtilities.invokeLater(() -> {
                if (!this.navButton.isSelected()) {
                    this.navButton.getOnSelect().run();
                }
            });
        }
    }

    @Subscribe
    private void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() == 774) {
            this.checkingApplicants = false;
        }
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        boolean inRegion;
        Player lp = this.client.getLocalPlayer();
        boolean bl = inRegion = lp != null && lp.getWorldLocation().getRegionID() == 13454;
        if (inRegion && !this.navButtonAdded) {
            this.pluginToolbar.addNavigation(this.navButton);
        } else if (!inRegion) {
            this.pluginToolbar.removeNavigation(this.navButton);
        }
        this.navButtonAdded = inRegion;
        this.refreshPanel();
    }

    public void refreshPanel() {
        if (!this.checkingApplicants) {
            return;
        }
        Widget[] partyApplicantWidget = this.client.getWidget(774, 48).getChildren();
        if (partyApplicantWidget == null) {
            return;
        }
        Stream<Widget> partyApplicantWidgetChildren = Arrays.stream(partyApplicantWidget).filter(x -> x.getOriginalWidth() == 114 && x.getOriginalHeight() == 22);
        ArrayList playerListStr = new ArrayList();
        HashMap<Player, List<ItemComposition>> playerList = new HashMap<Player, List<ItemComposition>>();
        partyApplicantWidgetChildren.forEach(widget -> playerListStr.add(widget.getText()));
        for (Player player : this.client.getPlayers()) {
            if (!playerListStr.contains(player.getName())) continue;
            ArrayList listOfEquipment = new ArrayList();
            PlayerComposition playerComposition = player.getPlayerComposition();
            for (KitType kitType : KitType.values()) {
                if (playerComposition.getEquipmentId(kitType) == -1) continue;
                this.clientThread.invoke(() -> listOfEquipment.add(this.itemManager.getItemComposition(playerComposition.getEquipmentId(kitType))));
            }
            playerList.put(player, listOfEquipment);
        }
        this.toaGearCheckPanel.updatePanel(playerList);
    }
}

