/*
 * Decompiled with CFR 0.152.
 */
package com.analoguetimestamps;

import com.analoguetimestamps.AnalogueTimestamp;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.MessageNode;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Analogue Timestamps", description="Add analogue timestamps to chat messages", tags={"chat", "emoji", "hub"})
public class AnalogueTimestampsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AnalogueTimestampsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientThread clientThread;
    private SimpleDateFormat formatter = new SimpleDateFormat("hhmm");
    private int modIconsStart = -1;

    protected void startUp() throws Exception {
        this.clientThread.invoke(this::loadAnalogueTimestampIcons);
    }

    protected void shutDown() throws Exception {
        this.formatter = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loadAnalogueTimestampIcons();
        }
    }

    private void loadAnalogueTimestampIcons() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.modIconsStart != -1 || modIcons == null) {
            return;
        }
        AnalogueTimestamp[] analogueTimestamps = AnalogueTimestamp.values();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + analogueTimestamps.length);
        this.modIconsStart = modIcons.length;
        for (int i = 0; i < analogueTimestamps.length; ++i) {
            AnalogueTimestamp analogueTimestamp = analogueTimestamps[i];
            try {
                IndexedSprite sprite;
                BufferedImage image = analogueTimestamp.loadImage();
                newModIcons[this.modIconsStart + i] = sprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
                continue;
            }
            catch (Exception ex) {
                log.warn("Failed to load the sprite for Timestamp Analogue " + analogueTimestamp, (Throwable)ex);
            }
        }
        this.client.setModIcons(newModIcons);
    }

    String getTimestamp(MessageNode messageNode) {
        String filename = this.generateRoundedTimestamp(messageNode.getTimestamp(), ZoneId.systemDefault());
        AnalogueTimestamp analogueTimestamp = AnalogueTimestamp.getAnalogueTimestamp(filename);
        int analogueTimestampId = this.modIconsStart + analogueTimestamp.ordinal();
        return "<img=" + analogueTimestampId + ">";
    }

    String generateRoundedTimestamp(int timestamp, ZoneId zoneId) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp), zoneId);
        String stringTimestamp = this.formatter.format(Date.from(time.toInstant()));
        return String.valueOf(5 * (Integer.parseInt(stringTimestamp) / 5));
    }

    @Subscribe(priority=-1.0f)
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!"chatMessageBuilding".equals(event.getEventName())) {
            return;
        }
        int uid = this.client.getIntStack()[this.client.getIntStackSize() - 1];
        MessageNode messageNode = (MessageNode)this.client.getMessages().get((long)uid);
        assert (messageNode != null) : "chat message build for unknown message";
        String timestamp = this.getTimestamp(messageNode);
        this.client.getStringStack()[this.client.getStringStackSize() - 1] = timestamp + this.client.getStringStack()[this.client.getStringStackSize() - 1];
    }
}

