/*
 * Decompiled with CFR 0.152.
 */
package com.damagecounter;

import com.damagecounter.DamageCounterConfig;
import com.damagecounter.DamageCounterPlugin;
import com.damagecounter.DamageMember;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.client.party.PartyService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.util.QuantityFormatter;

class DamageOverlay
extends OverlayPanel {
    private static final DecimalFormat DPS_FORMAT = new DecimalFormat("#0.0");
    private static final int PANEL_WIDTH_OFFSET = 0;
    private final DamageCounterPlugin damageCounterPlugin;
    private final DamageCounterConfig damageCounterConfig;
    private final PartyService partyService;
    private final Client client;

    @Inject
    DamageOverlay(DamageCounterPlugin damageCounterPlugin, DamageCounterConfig damageCounterConfig, PartyService partyService, Client client) {
        super((Plugin)damageCounterPlugin);
        this.damageCounterPlugin = damageCounterPlugin;
        this.damageCounterConfig = damageCounterConfig;
        this.partyService = partyService;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        Duration elapsed;
        long s;
        Player player;
        if (this.damageCounterConfig.overlayHide()) {
            return null;
        }
        Map<String, DamageMember> dpsMembers = this.damageCounterPlugin.getMembers();
        if (dpsMembers.isEmpty() || this.damageCounterConfig.overlayAutoHide() && DamageMember.overlayHide) {
            return null;
        }
        boolean inParty = !this.partyService.getMembers().isEmpty();
        boolean showDamage = this.damageCounterConfig.showDamage();
        DamageMember total = this.damageCounterPlugin.getTotal();
        String title = "Damage Counter";
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Damage Counter").build());
        int maxWidth = 129;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.damageCounterConfig.overlaySort()) {
            TreeMap damageDoneSorted = new TreeMap();
            for (DamageMember damageMember : dpsMembers.values()) {
                String left = damageMember.getName();
                int right = showDamage ? Integer.parseInt(QuantityFormatter.formatNumber((long)damageMember.getDamage())) : Integer.parseInt(DPS_FORMAT.format(damageMember.getDps()));
                damageDoneSorted.put(right, left);
            }
            NavigableMap descedingValuesMap = damageDoneSorted.descendingMap();
            Set descendingValuesSet = descedingValuesMap.entrySet();
            for (Map.Entry m : descendingValuesSet) {
                String left = (String)m.getValue();
                String right = Integer.toString((Integer)m.getKey());
                maxWidth = Math.max(maxWidth, fontMetrics.stringWidth(left) + fontMetrics.stringWidth(right));
                this.panelComponent.getChildren().add(LineComponent.builder().left(left).right(right).build());
            }
        } else {
            for (DamageMember damageMember : dpsMembers.values()) {
                String left = damageMember.getName();
                String right = showDamage ? QuantityFormatter.formatNumber((long)damageMember.getDamage()) : DPS_FORMAT.format(damageMember.getDps());
                maxWidth = Math.max(maxWidth, fontMetrics.stringWidth(left) + fontMetrics.stringWidth(right));
                this.panelComponent.getChildren().add(LineComponent.builder().left(left).right(right).build());
            }
        }
        this.panelComponent.setPreferredSize(new Dimension(maxWidth + 0, 0));
        if (!inParty && (player = this.client.getLocalPlayer()).getName() != null) {
            DamageMember self = dpsMembers.get(player.getName());
            double damageDone = self.getDamage();
            double damageTotal = total.getDamage();
            double damagePercent = damageDone / damageTotal;
            DecimalFormat df = new DecimalFormat("##%");
            if (self != null && total.getDamage() > self.getDamage()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left(total.getName()).right(showDamage ? Integer.toString(total.getDamage()) : DPS_FORMAT.format(total.getDps())).build());
            }
        }
        String format = (s = (elapsed = total.elapsed()).getSeconds()) >= 3600L ? String.format("%d:%02d:%02d", s / 3600L, s % 3600L / 60L, s % 60L) : String.format("%d:%02d", s / 60L, s % 60L);
        this.panelComponent.getChildren().add(LineComponent.builder().left("Elapsed time:").right(format).build());
        return super.render(graphics);
    }
}

