/*
 * Decompiled with CFR 0.152.
 */
package com.damagecounter;

import java.time.Duration;
import java.time.Instant;

class DamageMember {
    private final String name;
    private Instant start;
    private Instant end;
    private int damage;
    public static boolean overlayHide = true;

    void addDamage(int amount) {
        if (this.start == null) {
            this.start = Instant.now();
            overlayHide = false;
        }
        this.damage += amount;
    }

    float getDps() {
        if (this.start == null) {
            return 0.0f;
        }
        Instant now = this.end == null ? Instant.now() : this.end;
        int diff = (int)(now.toEpochMilli() - this.start.toEpochMilli()) / 1000;
        if (diff == 0) {
            return 0.0f;
        }
        return (float)this.damage / (float)diff;
    }

    void reset() {
        this.damage = 0;
        this.start = null;
        this.end = null;
        overlayHide = true;
    }

    Duration elapsed() {
        return Duration.between(this.start == null ? Instant.now() : this.start, this.end == null ? Instant.now() : this.end);
    }

    public DamageMember(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public int getDamage() {
        return this.damage;
    }
}

