/*
 * Decompiled with CFR 0.152.
 */
package com.damagecounter;

import com.damagecounter.DamageCounterConfig;
import com.damagecounter.DamageCounterPanel;
import com.damagecounter.DamageMember;
import com.damagecounter.DamageOverlay;
import com.damagecounter.DamageUpdate;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PartyChanged;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.party.WSClient;
import net.runelite.client.party.messages.PartyMessage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Damage Counter", description="Counts damage done to bosses")
public class DamageCounterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DamageCounterPlugin.class);
    private static final ImmutableSet<Integer> BOSSES = ImmutableSet.of((Object)5886, (Object)5887, (Object)5888, (Object)5889, (Object)5890, (Object)5891, (Object[])new Integer[]{5908, 8615, 8616, 8617, 8618, 8619, 8620, 8621, 8622, 11992, 8195, 11993, 11994, 11995, 6503, 6609, 5862, 5863, 5866, 2054, 6505, 6619, 2205, 6493, 319, 6618, 9021, 9022, 9023, 9024, 2265, 2266, 2267, 6496, 6497, 6498, 7806, 7849, 7850, 7851, 7852, 7853, 7854, 7855, 2215, 6494, 5779, 6499, 8583, 128, 963, 965, 4303, 4304, 6500, 6501, 239, 2642, 6502, 494, 6640, 6656, 3162, 6492, 3129, 6495, 7979, 8633, 11278, 11279, 11280, 11281, 11282, 378, 9426, 9427, 9428, 9429, 9430, 9431, 9432, 9433, 377, 9417, 9418, 9419, 9420, 9421, 9422, 9424, 11153, 11154, 11155, 7416, 12077, 12078, 12079, 12080, 9118, 8713, 6615, 7286, 11998, 499, 7706, 3127, 6506, 6504, 6610, 6611, 6612, 8026, 8058, 8059, 8060, 8061, 9049, 9050, 2042, 2043, 2044, 11789, 11790, 11791, 11792, 11793, 11794, 11795, 11796, 11778, 11779, 11780, 11719, 11721, 11730, 11732, 11751, 11756, 11757, 11758, 11762, 11764, 11753, 11754, 11755, 11761, 11763, 8360, 8361, 8362, 8363, 8364, 8365, 10814, 10815, 10816, 10817, 10818, 10819, 10822, 10823, 10824, 10825, 10826, 10827, 8359, 10813, 10812, 8354, 8355, 8356, 8357, 10807, 10808, 10809, 10810, 10786, 10787, 10788, 10789, 8387, 8388, 10867, 10868, 10864, 10865, 8340, 8341, 10772, 10773, 10768, 10769, 8250, 8369, 8370, 10847, 10848, 10830, 10831, 8371, 8372, 10849, 10850, 10832, 10833, 8373, 8374, 8375, 10851, 10852, 10853, 10834, 10835, 10836, 7540, 7541, 7542, 7543, 7544, 7545, 7530, 7531, 7532, 7533, 7525, 7526, 7527, 7528, 7529, 7551, 7552, 7553, 7554, 7555, 7559, 7560, 7561, 7562, 7563, 7566, 7567, 7569, 7570, 7571, 7572, 7573, 7574, 7584, 7585, 7604, 7605, 7606});
    private static final ImmutableSet<Integer> BARROWS = ImmutableSet.of((Object)1672, (Object)1673, (Object)1674, (Object)1675, (Object)1676, (Object)1677, (Object[])new Integer[0]);
    private String npcName = null;
    NPC barrows = null;
    int boss = 0;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PartyService partyService;
    @Inject
    private WSClient wsClient;
    @Inject
    private DamageOverlay damageOverlay;
    @Inject
    private DamageCounterConfig damageCounterConfig;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    private List<String> additionalNpcs;
    private final Map<String, DamageMember> members = new ConcurrentHashMap<String, DamageMember>();
    private final DamageMember total = new DamageMember("Total");

    @Provides
    DamageCounterConfig provideConfig(ConfigManager configManager) {
        return (DamageCounterConfig)configManager.getConfig(DamageCounterConfig.class);
    }

    protected void startUp() {
        this.total.reset();
        this.overlayManager.add((Overlay)this.damageOverlay);
        this.wsClient.registerMessage(DamageUpdate.class);
        this.additionalNpcs = Collections.emptyList();
        DamageCounterPanel panel = (DamageCounterPanel)((Object)this.injector.getInstance(DamageCounterPanel.class));
        panel.init();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"damagecounter_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Damage Counter").icon(icon).priority(10).panel((PluginPanel)panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.wsClient.unregisterMessage(DamageUpdate.class);
        this.overlayManager.remove((Overlay)this.damageOverlay);
        this.members.clear();
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("damagecounter")) {
            String s = this.damageCounterConfig.additionalNpcs();
            this.additionalNpcs = s != null ? Text.fromCSV((String)s) : Collections.emptyList();
        }
    }

    @Subscribe
    public void onPartyChanged(PartyChanged partyChanged) {
        this.members.clear();
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        Player player = this.client.getLocalPlayer();
        Actor actor = hitsplatApplied.getActor();
        if (!(actor instanceof NPC)) {
            return;
        }
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        int npcId = ((NPC)actor).getId();
        boolean isBoss = BOSSES.contains((Object)npcId);
        boolean isBarrows = BARROWS.contains((Object)npcId);
        boolean isAdditionalNpc = false;
        if (!this.additionalNpcs.isEmpty()) {
            for (String npcName : this.additionalNpcs) {
                if (!WildcardMatcher.matches((String)npcName, (String)actor.getName())) continue;
                isAdditionalNpc = true;
            }
        }
        if (!(isBoss || isBarrows || isAdditionalNpc)) {
            return;
        }
        if (hitsplat.isMine()) {
            int hit = hitsplat.getAmount();
            PartyMember localMember = this.partyService.getLocalMember();
            String name = localMember == null ? player.getName() : localMember.getDisplayName();
            DamageMember damageMember = this.members.computeIfAbsent(name, DamageMember::new);
            damageMember.addDamage(hit);
            if (this.boss == 0) {
                this.boss = npcId;
                this.npcName = actor.getName();
            } else if (this.boss != npcId) {
                this.reset();
            }
            if (isBarrows) {
                this.barrows = this.client.getHintArrowNpc();
            }
            if (localMember != null) {
                DamageUpdate specialCounterUpdate = new DamageUpdate(hit);
                specialCounterUpdate.setMemberId(localMember.getMemberId());
                this.partyService.send((PartyMessage)specialCounterUpdate);
            }
        } else if (hitsplat.isOthers() && this.boss == npcId && isBarrows) {
            return;
        }
        this.total.addDamage(hitsplat.getAmount());
    }

    @Subscribe
    public void onDamageUpdate(DamageUpdate damageUpdate) {
        if (this.partyService.getLocalMember().getMemberId() == damageUpdate.getMemberId()) {
            return;
        }
        String name = this.partyService.getMemberById(damageUpdate.getMemberId()).getDisplayName();
        if (name == null) {
            return;
        }
        DamageMember damageMember = this.members.computeIfAbsent(name, DamageMember::new);
        damageMember.addDamage(damageUpdate.getHit());
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        if (npc.isDead() && npc.getId() == this.boss) {
            if (this.barrows != null && npc != this.barrows) {
                return;
            }
            this.npcName = npc.getName();
            this.reset();
        }
    }

    private void reset() {
        Player player = this.client.getLocalPlayer();
        PartyMember localMember = this.partyService.getLocalMember();
        String name = localMember == null ? player.getName() : localMember.getDisplayName();
        boolean sendToChat = this.damageCounterConfig.sendToChat();
        this.barrows = null;
        this.boss = 0;
        DamageMember total = this.getTotal();
        Duration elapsed = total.elapsed();
        long s = elapsed.getSeconds();
        String killTime = s >= 3600L ? String.format("%dh %02dm %02ds", s / 3600L, s % 3600L / 60L, s % 60L) : String.format("%dm %02ds", s / 60L, s % 60L);
        for (DamageMember damageMember : this.members.values()) {
            if (name.equals(damageMember.getName()) && sendToChat) {
                double damageDone = damageMember.getDamage();
                double damageTotal = total.getDamage();
                double damagePercent = damageDone / damageTotal;
                DecimalFormat df = new DecimalFormat("##%");
                if (damagePercent < 1.0) {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You dealt " + QuantityFormatter.formatNumber((long)damageMember.getDamage()) + " (" + df.format(damagePercent) + ") damage to " + this.npcName + " in " + killTime, null);
                } else {
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You dealt " + QuantityFormatter.formatNumber((long)damageMember.getDamage()) + " damage to " + this.npcName + " in " + killTime, null);
                }
            }
            damageMember.reset();
        }
        this.npcName = null;
        total.reset();
    }

    Map<String, DamageMember> getMembers() {
        return this.members;
    }

    DamageMember getTotal() {
        return this.total;
    }
}

