/*
 * Decompiled with CFR 0.152.
 */
package com.damagecounter;

import com.damagecounter.DamageCounterPlugin;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.account.SessionManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

@Singleton
public class DamageCounterPanel
extends PluginPanel {
    private static final ImageIcon ARROW_RIGHT_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(DamageCounterPlugin.class, (String)"arrow_right.png"));
    private static final ImageIcon GITHUB_ICON = new ImageIcon(ImageUtil.getResourceStreamFromClass(DamageCounterPlugin.class, (String)"github_icon.png"));
    private JPanel actionsContainer;
    private JPanel knownIssuesContainer;
    private JPanel changelogContainer;
    @Inject
    @Nullable
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private SessionManager sessionManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ConfigManager configManager;
    private static final String changelogText = "<html><body style = 'color:#a5a5a5'><span style = 'color:white'>Changelog</span><br><br><span style = 'color:white'>v1.6 -- 17-Jan-2021</span><br>- Added side panel (to be expanded upon soon)<br><br><span style = 'color:white'>v1.5 -- 09-Dec-2020</span><br>- Counter now automatically resets when engaging combat with a different boss<br>- Counter will no longer automatically reset when teleporting/running away from boss<br>- Counter will still automatically reset when boss dies<br>- Extra config option added to allow custom NPCs to be tracked by name<br><br><span style = 'color:white'>v1.4.4 -- 08-Dec-2020</span><br>- Bugfix for Giant Mole<br><br><span style = 'color:white'>v1.4.3 -- 03-Dec-2020</span><br>- Bugfix for conflicting class names<br>- Counter will now reset if you run away or teleport from combat<br><br><span style = 'color:white'>v1.4.2 -- 25-Nov-2020</span><br>- Bugfix for Barrows again<br>- Shortened chat log message<br>- Chat log message will now only mention percentage, if it is less than 100%<br><br><span style = 'color:white'>v1.4.1 -- 18-Nov-2020</span><br>- Bugfix for counter not resetting on boss death<br><br><span style = 'color:white'>v1.4 -- 11-Nov-2020</span><br>- Included config option to always hide overlay<br><br><span style = 'color:white'>v1.3 -- 11-Nov-2020</span><br>- Included kill time in overlay, rather than mouseover<br>- Fixed bug with Barrows brothers<br><br><span style = 'color:white'>v1.2 -- 10-Nov-2020</span><br>- Added kill time to chat log message<br><br><span style = 'color:white'>v1.1 -- 04-Nov-2020</span><br>- Added config option to automatically hide overlay when boss dies<br><br><span style = 'color:white'>v1.0 -- 27-Oct-2020</span><br>- Initial commit</body></html>";
    private static final String knownIssuesText = "<html><body style = 'color:#a5a5a5'><span style = 'color:white'>Known issues</span><br><br>- Grotesque Guardians logging incorrectly</body></html>";

    void init() {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.changelogContainer = new JPanel();
        this.changelogContainer.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.changelogContainer.setLayout(new GridLayout(0, 1, 0, 10));
        this.changelogContainer.add(DamageCounterPanel.buildTextPanel(changelogText));
        this.knownIssuesContainer = new JPanel();
        this.knownIssuesContainer.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.knownIssuesContainer.setLayout(new GridLayout(0, 1, 0, 10));
        this.knownIssuesContainer.add(DamageCounterPanel.buildTextPanel(knownIssuesText));
        this.actionsContainer = new JPanel();
        this.actionsContainer.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.actionsContainer.setLayout(new GridLayout(0, 1, 0, 10));
        this.actionsContainer.add(DamageCounterPanel.buildLinkPanel(GITHUB_ICON, "Report an issue or", "make a suggestion", "https://github.com/0anth/damage-counter/issues/new"));
        this.add(this.actionsContainer, "North");
        this.add(this.knownIssuesContainer, "Center");
        this.add(this.changelogContainer, "South");
        this.eventBus.register((Object)this);
    }

    private static JPanel buildLinkPanel(ImageIcon icon, String topText, String bottomText, String url) {
        return DamageCounterPanel.buildLinkPanel(icon, topText, bottomText, () -> LinkBrowser.browse((String)url));
    }

    private static JPanel buildLinkPanel(ImageIcon icon, String topText, String bottomText, final Runnable callback) {
        final JPanel container = new JPanel();
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        container.setLayout(new BorderLayout());
        container.setBorder(new EmptyBorder(10, 10, 10, 10));
        final Color hoverColor = ColorScheme.DARKER_GRAY_HOVER_COLOR;
        final Color pressedColor = ColorScheme.DARKER_GRAY_COLOR.brighter();
        JLabel iconLabel = new JLabel(icon);
        container.add((Component)iconLabel, "West");
        final JPanel textContainer = new JPanel();
        textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        textContainer.setLayout(new GridLayout(2, 1));
        textContainer.setBorder(new EmptyBorder(5, 10, 5, 10));
        container.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                container.setBackground(pressedColor);
                textContainer.setBackground(pressedColor);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                callback.run();
                container.setBackground(hoverColor);
                textContainer.setBackground(hoverColor);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                container.setBackground(hoverColor);
                textContainer.setBackground(hoverColor);
                container.setCursor(new Cursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                container.setCursor(new Cursor(0));
            }
        });
        JLabel topLine = new JLabel(topText);
        topLine.setForeground(Color.WHITE);
        topLine.setFont(FontManager.getRunescapeSmallFont());
        JLabel bottomLine = new JLabel(bottomText);
        bottomLine.setForeground(Color.WHITE);
        bottomLine.setFont(FontManager.getRunescapeSmallFont());
        textContainer.add(topLine);
        textContainer.add(bottomLine);
        container.add((Component)textContainer, "Center");
        JLabel arrowLabel = new JLabel(ARROW_RIGHT_ICON);
        container.add((Component)arrowLabel, "East");
        return container;
    }

    private static JPanel buildTextPanel(String text) {
        JPanel container = new JPanel();
        container.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        container.setLayout(new GridLayout(0, 1));
        container.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel textLabel = new JLabel(text);
        textLabel.setForeground(Color.WHITE);
        textLabel.setFont(FontManager.getRunescapeFont());
        container.add(textLabel);
        return container;
    }
}

