/*
 * Decompiled with CFR 0.152.
 */
package com.tobgearchecker.gear;

import com.tobgearchecker.RuneSets;
import com.tobgearchecker.Runes;
import com.tobgearchecker.Spellbook;
import com.tobgearchecker.ToBGearCheckerConfig;

public class HaveRunes {
    public boolean runePouch = false;
    public int[] runeAmounts = new int[22];
    public Spellbook spellbook = Spellbook.NONE;

    public String getReadableIssues(ToBGearCheckerConfig config) {
        StringBuilder output = new StringBuilder();
        if (config.targetRuneSet() != RuneSets.NONE) {
            if (this.spellbook.getId() != config.targetRuneSet().getSpellbook().getId()) {
                output.append("Wrong spellbook (Need ").append(config.targetRuneSet().getSpellbook().toString()).append(")\n");
            }
            if (!this.runePouch) {
                output.append("No rune pouch\n");
            }
            boolean foundAny = false;
            for (int i = 0; i < config.targetRuneSet().getRunes().length; ++i) {
                Runes rune = config.targetRuneSet().getRunes()[i];
                if (this.runeAmounts[rune.getRunePouchID()] > config.runeAmounts()) continue;
                output.append(foundAny ? "\n" : "").append(this.runeAmounts[rune.getRunePouchID()]).append("/").append(config.runeAmounts()).append(" ").append(rune.name().substring(0, 1).toUpperCase()).append(rune.name().substring(1).toLowerCase()).append(" runes");
                foundAny = true;
            }
        }
        return output.toString();
    }
}

