/*
 * Decompiled with CFR 0.152.
 */
package com.tobgearchecker;

import com.google.inject.Provides;
import com.tobgearchecker.Runes;
import com.tobgearchecker.Spellbook;
import com.tobgearchecker.ToBGearCheckerConfig;
import com.tobgearchecker.ToBGearCheckerOverlayPanel;
import com.tobgearchecker.gear.HaveCharges;
import com.tobgearchecker.gear.HaveRunes;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToB Gear Checker", description="A plugin that checks your spellbook, runes, and charges.", tags={"tob", "gear", "rune", "spellbook", "spells", "charges"})
public class ToBGearCheckerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ToBGearCheckerPlugin.class);
    private ToBGearCheckerOverlayPanel gearCheckerOverlayPanel = null;
    public boolean leftVersinhaza = true;
    public HaveCharges charges = new HaveCharges();
    public HaveRunes runes = new HaveRunes();
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private ToBGearCheckerConfig config;
    private NavigationButton navButton;

    protected void startUp() {
        this.gearCheckerOverlayPanel = new ToBGearCheckerOverlayPanel(this, true, "");
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!this.isInVersinhaza()) {
            return;
        }
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String message = Text.removeTags((String)event.getMessage());
        String[] words = message.split(" ");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (String numericWord : words) {
            if ((numericWord = numericWord.replaceAll("[^\\d]", "")).length() <= 0) continue;
            numbers.add(Integer.parseInt(numericWord));
        }
        if (this.config.blowpipe() && message.toLowerCase().contains("darts") && message.toLowerCase().contains("scales")) {
            boolean hasDarts = true;
            if (words[1].equalsIgnoreCase("none")) {
                hasDarts = false;
                this.charges.blowpipeDarts = 0;
            } else {
                this.charges.blowpipeDarts = (Integer)numbers.get(0);
            }
            this.charges.blowpipeScales = (Integer)numbers.get(hasDarts ? 1 : 0);
            this.charges.blowpipeDartType = words[1];
        } else if (this.config.scythe() && message.toLowerCase().contains("scythe of vitur")) {
            this.charges.scytheCharges = numbers.size() == 0 ? 0 : (Integer)numbers.get(0);
        } else if (this.config.serpentine() && message.toLowerCase().contains("scales:") && !message.toLowerCase().contains("darts")) {
            this.charges.serpentineScales = (Integer)numbers.get(0);
        } else if (this.config.trident() && (message.toLowerCase().contains("your weapon has") || message.toLowerCase().contains("sanguinesti staff")) && message.contains("charges")) {
            this.charges.tridentCharges = (Integer)numbers.get(0);
        }
    }

    protected void shutDown() {
        if (this.gearCheckerOverlayPanel.isVisible()) {
            this.overlayManager.remove((Overlay)this.gearCheckerOverlayPanel);
            this.gearCheckerOverlayPanel.setVisible(false);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.isInVersinhaza()) {
            if (!this.leftVersinhaza) {
                this.charges = new HaveCharges();
            }
            this.leftVersinhaza = true;
        }
        if (this.isInVersinhaza()) {
            this.runes = this.getPlayerRunes();
            this.leftVersinhaza = false;
        }
        this.updateInfoBox();
    }

    private HaveRunes getPlayerRunes() {
        Item[] items;
        HaveRunes output = new HaveRunes();
        int[] runePouch = new int[22];
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        output.spellbook = Spellbook.getSpellbookByID(this.client.getVarbitValue(4070));
        runePouch[this.client.getVar((int)29)] = this.client.getVar(1624);
        runePouch[this.client.getVar((int)1622)] = this.client.getVar(1625);
        runePouch[this.client.getVar((int)1623)] = this.client.getVar(1626);
        output.runeAmounts = runePouch;
        output.runePouch = false;
        if (container == null) {
            return output;
        }
        for (Item item : items = container.getItems()) {
            if (item == null) continue;
            if (item.getId() == 12791) {
                output.runePouch = true;
                continue;
            }
            for (Runes rune : Runes.values()) {
                if (item.getId() != rune.itemID) continue;
                int n = rune.runePouchID;
                output.runeAmounts[n] = output.runeAmounts[n] + item.getQuantity();
            }
        }
        return output;
    }

    @Provides
    ToBGearCheckerConfig provideConfig(ConfigManager configManager) {
        return (ToBGearCheckerConfig)configManager.getConfig(ToBGearCheckerConfig.class);
    }

    public boolean isInVersinhaza() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return false;
        }
        return localPlayer.getWorldLocation().getRegionID() == 14642;
    }

    private void updateInfoBox() {
        if (!this.isInVersinhaza() && this.gearCheckerOverlayPanel.isVisible()) {
            this.overlayManager.remove((Overlay)this.gearCheckerOverlayPanel);
            this.gearCheckerOverlayPanel.setVisible(false);
        } else if (this.isInVersinhaza() && !this.gearCheckerOverlayPanel.isVisible()) {
            this.overlayManager.add((Overlay)this.gearCheckerOverlayPanel);
            this.gearCheckerOverlayPanel.setVisible(true);
        }
        if (!this.isInVersinhaza()) {
            return;
        }
        String runeIssues = this.runes.getReadableIssues(this.config);
        String chargeIssues = this.charges.getReadableIssues(this.config);
        Object output = runeIssues.equals("") ? chargeIssues : (chargeIssues.equals("") ? runeIssues : runeIssues + "\n\n" + chargeIssues);
        if (runeIssues.length() + chargeIssues.length() == 0) {
            this.gearCheckerOverlayPanel.SetProblems(true, "");
        } else {
            this.gearCheckerOverlayPanel.SetProblems(false, (String)output);
        }
    }

    NavigationButton getNavButton() {
        return this.navButton;
    }
}

