/*
 * Decompiled with CFR 0.152.
 */
package com.cachunk;

import com.cachunk.CaChunkConfig;
import com.cachunk.CaChunkOverlay;
import com.google.inject.Provides;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="CAChunk")
public class CaChunkPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CaChunkPlugin.class);
    public static final int CA_POINTS_TOTAL = 14815;
    private int unlockedChunks;
    private int caPoints;
    private boolean isLoggedIn;
    @Inject
    private Client client;
    @Inject
    private CaChunkConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CaChunkOverlay infoOverlay;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.infoOverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.infoOverlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.isLoggedIn = true;
            this.caPoints = this.getCAPoints();
            this.unlockedChunks = this.getChunkUnlockCount();
        } else if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.isLoggedIn = false;
        }
    }

    @Subscribe
    public void onClientTick(ClientTick t) {
        if (this.isLoggedIn) {
            this.caPoints = this.getCAPoints();
            this.unlockedChunks = this.getChunkUnlockCount();
        }
    }

    @Provides
    CaChunkConfig provideConfig(ConfigManager configManager) {
        return (CaChunkConfig)configManager.getConfig(CaChunkConfig.class);
    }

    private String getChunkUnlockString() {
        return this.configManager.getConfiguration("regionlocker", "unlockedRegions");
    }

    public int getChunkUnlockCount() {
        String csvChunkString = this.getChunkUnlockString();
        List chunkStrings = Text.fromCSV((String)csvChunkString);
        return chunkStrings.size();
    }

    public int getCAPoints() {
        return this.client.getVarbitValue(14815);
    }
}

