/*
 * Decompiled with CFR 0.152.
 */
package com.cachunk;

import com.cachunk.CaChunkConfig;
import com.cachunk.CaChunkPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class CaChunkOverlay
extends OverlayPanel {
    private final Client client;
    private final CaChunkConfig config;
    private final CaChunkPlugin plugin;
    private static final String UNLOCKED_CHUNKS_STRING = "Chunks Unlocked:";
    private static final String CA_POINTS_STRING = "Combat Achievement Points:";
    private static final String AVAILABLE_CHUNKS = "Available Chunks:";
    private static final String[] STRINGS = new String[]{"Chunks Unlocked:", "Combat Achievement Points:", "Available Chunks:"};

    @Inject
    private CaChunkOverlay(Client client, CaChunkConfig config, CaChunkPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setPriority(OverlayPriority.MED);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "CAChunk Mode Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        int unlockedChunks = this.plugin.getChunkUnlockCount();
        int caPoints = this.plugin.getCAPoints();
        int availableChunks = caPoints - unlockedChunks + this.config.startingChunks();
        this.panelComponent.getChildren().add(LineComponent.builder().left(UNLOCKED_CHUNKS_STRING).leftColor(this.getTextColor()).right(String.valueOf(unlockedChunks)).rightColor(this.getTextColor()).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left(CA_POINTS_STRING).right(String.valueOf(caPoints)).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left(AVAILABLE_CHUNKS).right(String.valueOf(availableChunks)).build());
        String[] valueStrings = new String[]{String.valueOf(unlockedChunks), String.valueOf(caPoints), String.valueOf(availableChunks)};
        this.panelComponent.setPreferredSize(new Dimension(this.getLongestStringWidth(STRINGS, graphics) + this.getLongestStringWidth(valueStrings, graphics), 0));
        return super.render(graphics);
    }

    private Color getTextColor() {
        if (this.plugin.getCAPoints() + this.config.startingChunks() < this.plugin.getChunkUnlockCount()) {
            return Color.RED;
        }
        return Color.WHITE;
    }

    private int getLongestStringWidth(String[] strings, Graphics2D graphics) {
        int longest = graphics.getFontMetrics().stringWidth("000000");
        for (String i : strings) {
            int currentItemWidth = graphics.getFontMetrics().stringWidth(i);
            if (currentItemWidth <= longest) continue;
            longest = currentItemWidth;
        }
        return longest;
    }
}

