/*
 * Decompiled with CFR 0.152.
 */
package org.makingstan;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.makingstan.ItemHandler;
import org.makingstan.ItemHunterConfig;
import org.makingstan.ItemHunterPanel;
import org.makingstan.SaveHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Item Hunter")
public class ItemHunterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ItemHunterPlugin.class);
    @Inject
    public Client client;
    @Inject
    public ItemHunterConfig config;
    @Inject
    public ClientToolbar clientToolbar;
    @Inject
    public ClientThread clientThread;
    @Inject
    public ItemManager itemManager;
    @Inject
    public ConfigManager configManager;
    private NavigationButton navButton;
    private ItemHunterPanel panel;
    BufferedImage panelIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/itemhuntericon48x48.png");

    protected void startUp() {
        new SaveHandler(this.configManager);
        this.panel = (ItemHunterPanel)((Object)this.injector.getInstance(ItemHunterPanel.class));
        new ItemHandler(this.client, this.config, this.itemManager, this.panel, this.clientThread);
        this.navButton = NavigationButton.builder().tooltip("Item Hunter").icon(this.panelIcon).priority(3).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        Integer itemId = (Integer)SaveHandler.getElement("currentItem", Integer.TYPE);
        if (SaveHandler.getElement("blockList", HashSet.class) == null) {
            this.configManager.setConfiguration("Item Hunter", "blockList", new HashSet());
        }
        if (SaveHandler.getElement("completedList", HashSet.class) == null) {
            this.configManager.setConfiguration("Item Hunter", "completedList", new HashSet());
        }
        if (SaveHandler.getElement("completed", Boolean.TYPE) == null) {
            this.configManager.setConfiguration("Item Hunter", "completed", (Object)false);
        }
        if (SaveHandler.getElement("skipped", Boolean.TYPE) == null) {
            this.configManager.setConfiguration("Item Hunter", "skipped", (Object)false);
        }
        if (itemId == null) {
            ItemHandler.generateNewItem(false);
        } else {
            ItemHandler.updateItemUI();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equalsIgnoreCase("Item Hunter") && (event.getNewValue().equalsIgnoreCase("true") || event.getNewValue().equalsIgnoreCase("false")) && (event.getKey().equalsIgnoreCase("Forfeit for skipping items") || event.getKey().equalsIgnoreCase("Hide clear all button"))) {
            ItemHandler.updateItemUI();
        }
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Provides
    ItemHunterConfig provideConfig(ConfigManager configManager) {
        return (ItemHunterConfig)configManager.getConfig(ItemHunterConfig.class);
    }
}

