/*
 * Decompiled with CFR 0.152.
 */
package org.makingstan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Iterator;
import javax.inject.Inject;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import net.runelite.api.ItemComposition;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.makingstan.ItemHandler;
import org.makingstan.ItemHunterPlugin;
import org.makingstan.ItemTemplate;
import org.makingstan.SaveHandler;

public class ItemHunterPanel
extends PluginPanel {
    JLabel itemStatus = new JLabel();
    JLabel itemIconLabel = new JLabel();
    JLabel itemName = new JLabel();
    JLabel itemId = new JLabel();
    JButton skipButton = new JButton();
    JButton completedButton = new JButton();
    JButton newItemButton = new JButton();
    JButton unobtainableItemButton = new JButton();
    JPanel itemInformation = new JPanel();
    JPanel itemShowCasePanel = new JPanel();
    JPanel controlButtonsPanel = new JPanel();
    JPanel itemPanel = new JPanel();
    JPanel completedItemsPanel = new JPanel();
    JPanel columnHeader = new JPanel();
    JScrollPane completedItemsPane = new JScrollPane();
    JButton clearAllButton = new JButton("Clear All");
    BufferedImage skipImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/skip.png");
    BufferedImage completedIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/complete.png");
    BufferedImage newItemIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/newitem.png");
    BufferedImage unobtainableIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/unobtainable.png");
    ItemHunterPlugin itemGeneratorPlugin;

    @Inject
    public ItemHunterPanel(ItemHunterPlugin itemGeneratorPlugin) {
        this.itemGeneratorPlugin = itemGeneratorPlugin;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.itemStatus.setFont(FontManager.getRunescapeBoldFont());
        this.itemName.setFont(FontManager.getRunescapeBoldFont());
        this.itemId.setFont(FontManager.getRunescapeFont());
        this.itemName.setHorizontalAlignment(0);
        this.itemId.setHorizontalAlignment(0);
        this.itemInformation.setLayout(new GridBagLayout());
        GridBagConstraints itemInformationConstraints = new GridBagConstraints();
        itemInformationConstraints.gridy = 0;
        this.itemInformation.add((Component)this.itemName, itemInformationConstraints);
        itemInformationConstraints.gridy = 1;
        this.itemInformation.add((Component)this.itemId, itemInformationConstraints);
        this.skipButton.setIcon(new ImageIcon(this.skipImage));
        this.skipButton.setFocusPainted(false);
        this.skipButton.setToolTipText("Skip Item");
        this.skipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemHandler.skipItem();
            }
        });
        this.completedButton.setIcon(new ImageIcon(this.completedIcon));
        this.completedButton.setFocusPainted(false);
        this.completedButton.setToolTipText("Complete Item");
        this.completedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemHandler.completeItem();
            }
        });
        this.newItemButton.setIcon(new ImageIcon(this.newItemIcon));
        this.newItemButton.setFocusPainted(false);
        this.newItemButton.setToolTipText("New Item");
        this.newItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemHandler.generateNewItem(true);
            }
        });
        this.unobtainableItemButton.setIcon(new ImageIcon(this.unobtainableIcon));
        this.unobtainableItemButton.setFocusPainted(false);
        this.unobtainableItemButton.setToolTipText("Unobtainable Item");
        this.unobtainableItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemHandler.unobtainableItem();
            }
        });
        this.clearAllButton.setFocusPainted(false);
        this.clearAllButton.setToolTipText("Clear Items");
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemHandler.clearCompletedItems();
            }
        });
        this.itemShowCasePanel.setLayout(new GridBagLayout());
        GridBagConstraints itemShowCasePanelConstraints = new GridBagConstraints();
        itemShowCasePanelConstraints.gridy = 0;
        this.itemShowCasePanel.add((Component)this.itemIconLabel, itemShowCasePanelConstraints);
        itemShowCasePanelConstraints.gridy = 1;
        this.itemShowCasePanel.add((Component)this.itemInformation, itemShowCasePanelConstraints);
        this.controlButtonsPanel.setLayout(new FlowLayout(1));
        this.controlButtonsPanel.add(this.completedButton);
        this.controlButtonsPanel.add(this.newItemButton);
        this.controlButtonsPanel.add(this.skipButton);
        this.controlButtonsPanel.add(this.unobtainableItemButton);
        this.itemPanel.setLayout(new BorderLayout());
        this.itemPanel.add((Component)this.itemStatus, "North");
        this.itemPanel.add((Component)this.itemShowCasePanel, "Center");
        this.itemPanel.add((Component)this.controlButtonsPanel, "South");
        this.completedItemsPanel.setLayout(new BoxLayout(this.completedItemsPanel, 1));
        this.columnHeader.add(new JLabel("Completed Items: ", 2));
        JViewport viewPort = new JViewport();
        viewPort.setView(this.columnHeader);
        viewPort.setFont(FontManager.getRunescapeBoldFont());
        this.completedItemsPane.setColumnHeader(viewPort);
        this.completedItemsPane.setViewportView(this.completedItemsPanel);
        this.completedItemsPane.getViewport().setPreferredSize(new Dimension(this.getWidth(), 300));
        this.completedItemsPane.setHorizontalScrollBarPolicy(31);
        this.completedItemsPane.setVerticalScrollBarPolicy(22);
        this.add(this.itemPanel, "North");
        this.add(this.completedItemsPane, "South");
    }

    public void updateItemUI(ItemComposition itemComposition, BufferedImage itemIcon) {
        this.itemStatus.setText("Current Item to Obtain: ");
        if (ItemHandler.isCurrentItemSkipped()) {
            this.itemStatus.setText("Item Skipped");
        } else if (ItemHandler.isCurrentItemCompleted()) {
            this.itemStatus.setText("Item Completed");
        }
        this.itemIconLabel.setIcon(new ImageIcon(ItemHunterPanel.resize(itemIcon, itemIcon.getWidth() * 3, itemIcon.getHeight() * 3)));
        this.itemName.setText(itemComposition.getMembersName());
        this.itemId.setText("Id: " + itemComposition.getId());
        this.completedItemsPanel.removeAll();
        this.completedItemsPane.getViewport().remove(this.completedItemsPane.getViewport().getView());
        SwingUtilities.invokeAndWait(() -> {
            boolean containsClearAllButton = false;
            for (Component component : this.columnHeader.getComponents()) {
                if (!(component instanceof JButton)) continue;
                containsClearAllButton = true;
                break;
            }
            if (containsClearAllButton && this.itemGeneratorPlugin.config.hideClearCompletedItems()) {
                this.columnHeader.remove(this.clearAllButton);
            } else if (!containsClearAllButton && !this.itemGeneratorPlugin.config.hideClearCompletedItems()) {
                this.columnHeader.add(this.clearAllButton);
            }
        });
        Iterator iterator = ((HashSet)SaveHandler.getElement("completedList", HashSet.class)).iterator();
        while (iterator.hasNext()) {
            final int completedItem = (Integer)iterator.next();
            this.itemGeneratorPlugin.clientThread.invoke(new Runnable(){

                @Override
                public void run() {
                    ItemComposition composition = ItemHunterPanel.this.itemGeneratorPlugin.client.getItemDefinition(completedItem);
                    AsyncBufferedImage iconImage = ItemHunterPanel.this.itemGeneratorPlugin.itemManager.getImage(completedItem);
                    SwingUtilities.invokeAndWait(() -> this.lambda$run$0(composition, (BufferedImage)iconImage));
                }

                private /* synthetic */ void lambda$run$0(ItemComposition composition, BufferedImage iconImage) {
                    ItemHunterPanel.this.completedItemsPanel.add(new ItemTemplate(composition, iconImage));
                }
            });
        }
        this.completedItemsPane.setViewportView(this.completedItemsPanel);
        this.revalidate();
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }
}

