/*
 * Decompiled with CFR 0.152.
 */
package org.makingstan;

import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import org.makingstan.ItemHunterConfig;
import org.makingstan.ItemHunterPanel;
import org.makingstan.SaveHandler;
import org.makingstan.Utils;

public class ItemHandler {
    private static Client client;
    private static ItemHunterConfig config;
    private static ItemManager itemManager;
    private static ItemHunterPanel panel;
    private static ClientThread clientThread;

    public ItemHandler(Client client, ItemHunterConfig config, ItemManager itemManager, ItemHunterPanel panel, ClientThread clientThread) {
        ItemHandler.clientThread = clientThread;
        ItemHandler.panel = panel;
        ItemHandler.itemManager = itemManager;
        ItemHandler.config = config;
        ItemHandler.client = client;
    }

    private static int getRandomValidItemId() {
        boolean itemIsValid = false;
        int itemId = 0;
        while (!itemIsValid) {
            itemId = Utils.random(0, client.getItemCount());
            ItemComposition composition = client.getItemDefinition(itemId);
            HashSet blockList = (HashSet)SaveHandler.getElement("blockList", HashSet.class);
            HashSet completedList = (HashSet)SaveHandler.getElement("completedList", HashSet.class);
            String itemName = new String(composition.getMembersName().getBytes(StandardCharsets.UTF_8));
            HashSet<String> completedListNames = new HashSet<String>();
            for (Integer integer : completedList) {
                String name = new String(client.getItemDefinition(integer.intValue()).getMembersName().getBytes(StandardCharsets.UTF_8));
                completedListNames.add(name);
            }
            if (composition.getName().trim().length() <= 0 || itemName.trim().equalsIgnoreCase("null") || completedListNames.contains(itemName) && itemName.toLowerCase().startsWith("clue scroll") || blockList.contains(itemId) || completedList.contains(itemId)) continue;
            if (config.excludeNotedItems()) {
                if (composition.getNote() != -1) continue;
                itemIsValid = true;
                continue;
            }
            itemIsValid = true;
        }
        return itemId;
    }

    public static void generateNewItem(boolean checkIfCompleted) {
        if (checkIfCompleted) {
            if (ItemHandler.isCurrentItemCompleted() || ItemHandler.isCurrentItemSkipped()) {
                if (config.dialogConfirmation()) {
                    int newItemConfirm = JOptionPane.showConfirmDialog(null, "Are you sure you want to generate a new item?", "Item Hunter", 1, 3, null);
                    if (newItemConfirm == 0) {
                        ItemHandler.newItem();
                    }
                } else {
                    ItemHandler.newItem();
                }
            } else {
                JOptionPane.showMessageDialog(null, "You have to complete or skip an item before generating another!");
            }
        } else {
            ItemHandler.newItem();
        }
    }

    private static void newItem() {
        clientThread.invokeLater(new Runnable(){

            @Override
            public void run() {
                int itemId = ItemHandler.getRandomValidItemId();
                SaveHandler.setElement("currentItem", itemId);
                SaveHandler.setElement("completed", false);
                SaveHandler.setElement("skipped", false);
                ItemHandler.updateItemUI();
            }
        });
    }

    public static void unobtainableItem() {
        int confirmUnobtainable;
        if (ItemHandler.isCurrentItemCompleted() || ItemHandler.isCurrentItemSkipped()) {
            JOptionPane.showConfirmDialog(null, "You can't flag an item as unobtainable if you've completed or skipped it!", "Item Hunter", 2, 1, null);
            return;
        }
        if (config.dialogConfirmation() && (confirmUnobtainable = JOptionPane.showConfirmDialog(null, "Are you sure you want to set this item to unobtainable? It will be added to your block list and a new item will be generated.", "Item Hunter", 1, 3, null)) != 0) {
            return;
        }
        SaveHandler.addItemToList("blockList", (Integer)SaveHandler.getElement("currentItem", Integer.TYPE));
        ItemHandler.generateNewItem(false);
    }

    public static void skipItem() {
        int confirmSkip;
        if (ItemHandler.isCurrentItemCompleted() || ItemHandler.isCurrentItemSkipped()) {
            JOptionPane.showConfirmDialog(null, "You can't skip an item if you've completed or skipped it!", "Item Hunter", 2, 1, null);
            return;
        }
        if (config.dialogConfirmation() && (confirmSkip = JOptionPane.showConfirmDialog(null, "Are you sure you want to skip this item?", "Item Hunter", 1, 3, null)) != 0) {
            return;
        }
        if (config.forfeitSkippedItems()) {
            HashSet completedList = (HashSet)SaveHandler.getElement("completedList", HashSet.class);
            boolean shouldContinue = true;
            if (completedList.size() == 0) {
                JOptionPane.showConfirmDialog(null, "You can't forfeit an item if you don't have any completed items!", "Item Hunter", 2, 1, null);
                shouldContinue = false;
            }
            if (shouldContinue) {
                int randomIndex = Utils.random(0, completedList.size() - 1);
                int itemIdToBeForfeited = 0;
                int i = 0;
                Iterator iterator = completedList.iterator();
                while (iterator.hasNext()) {
                    int itemId = (Integer)iterator.next();
                    if (i == randomIndex) {
                        itemIdToBeForfeited = itemId;
                        completedList.remove(itemIdToBeForfeited);
                        int finalItemIdToBeForfeited = itemIdToBeForfeited;
                        clientThread.invoke(() -> {
                            try {
                                ItemComposition composition = client.getItemDefinition(finalItemIdToBeForfeited);
                                SwingUtilities.invokeAndWait(() -> JOptionPane.showConfirmDialog(null, "Your forfeited your " + composition.getMembersName() + "!", "Item Hunter", 2, 1, null));
                            }
                            catch (InterruptedException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        });
                        break;
                    }
                    ++i;
                }
                SaveHandler.setElement("completedList", completedList);
            }
        }
        if (config.blockSkippedItems()) {
            SaveHandler.addItemToList("blockList", (Integer)SaveHandler.getElement("currentItem", Integer.TYPE));
        }
        SaveHandler.setElement("skipped", true);
        ItemHandler.updateItemUI();
    }

    public static void clearCompletedItems() {
        String confirmClearAll = JOptionPane.showInputDialog(null, (Object)"Are you really sure you want to clear all of your completed items? Type \"yes\" to confirm.");
        if (confirmClearAll != null) {
            if (!confirmClearAll.equalsIgnoreCase("yes")) {
                return;
            }
        } else {
            return;
        }
        SaveHandler.setElement("completedList", new HashSet());
        ItemHandler.updateItemUI();
    }

    public static void completeItem() {
        int confirmComplete;
        if (ItemHandler.isCurrentItemSkipped() || ItemHandler.isCurrentItemCompleted()) {
            JOptionPane.showConfirmDialog(null, "You can't complete an item if you've skipped or completed it!", "Item Hunter", 2, 1, null);
            return;
        }
        if (config.dialogConfirmation() && (confirmComplete = JOptionPane.showConfirmDialog(null, "Are you sure you want to complete this item?", "Item Hunter", 1, 3, null)) != 0) {
            return;
        }
        SaveHandler.addItemToList("completedList", (Integer)SaveHandler.getElement("currentItem", Integer.TYPE));
        SaveHandler.setElement("completed", true);
        ItemHandler.updateItemUI();
    }

    public static boolean isCurrentItemCompleted() {
        return (Boolean)SaveHandler.getElement("completed", Boolean.TYPE);
    }

    public static boolean isCurrentItemSkipped() {
        return (Boolean)SaveHandler.getElement("skipped", Boolean.TYPE);
    }

    public static void updateItemUI() {
        int itemId = (Integer)SaveHandler.getElement("currentItem", Integer.TYPE);
        clientThread.invoke(() -> {
            ItemComposition itemComposition = client.getItemDefinition(itemId);
            AsyncBufferedImage iconImage = itemManager.getImage(itemId);
            panel.updateItemUI(itemComposition, (BufferedImage)iconImage);
        });
    }
}

