/*
 * Decompiled with CFR 0.152.
 */
package com.combatinformation;

import com.combatinformation.AttackStyle;
import com.combatinformation.CombatInformationConfig;
import com.combatinformation.CombatInformationOverlay;
import com.combatinformation.WeaponType;
import com.google.inject.Provides;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Combat Information", description="Combat information overlay for combat stats, attack style, and auto-retaliate setting.", tags={"combat", "boosts", "info", "overlay", "auto-retaliate"})
public class CombatInformationPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CombatInformationPlugin.class);
    private int attackStyleVarbit = -1;
    private int equippedWeaponTypeVarbit = -1;
    private int castingModeVarbit = -1;
    private int autoRetaliateVarbit = -1;
    private AttackStyle attackStyle;
    private String autoRetaliate;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CombatInformationOverlay combatInformationOverlay;
    @Inject
    private CombatInformationConfig config;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.combatInformationOverlay);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::start);
        }
    }

    private void start() {
        this.attackStyleVarbit = this.client.getVar(43);
        this.equippedWeaponTypeVarbit = this.client.getVar(357);
        this.castingModeVarbit = this.client.getVar(2668);
        this.updateAttackStyle(this.equippedWeaponTypeVarbit, this.attackStyleVarbit, this.castingModeVarbit);
        this.getAutoRetaliateVarbit();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.combatInformationOverlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
    }

    @Provides
    CombatInformationConfig provideConfig(ConfigManager configManager) {
        return (CombatInformationConfig)configManager.getConfig(CombatInformationConfig.class);
    }

    private void attackStyle() {
        this.attackStyleVarbit = this.client.getVar(43);
        this.equippedWeaponTypeVarbit = this.client.getVar(357);
        this.castingModeVarbit = this.client.getVar(2668);
        this.updateAttackStyle(this.equippedWeaponTypeVarbit, this.attackStyleVarbit, this.castingModeVarbit);
    }

    @Nullable
    public AttackStyle getAttackStyle() {
        return this.attackStyle;
    }

    private void updateAttackStyle(int equippedWeaponType, int attackStyleIndex, int castingMode) {
        AttackStyle[] attackStyles = WeaponType.getWeaponType(equippedWeaponType).getAttackStyles();
        if (attackStyleIndex < attackStyles.length) {
            this.attackStyle = attackStyles[attackStyleIndex];
            if (this.attackStyle == null) {
                this.attackStyle = AttackStyle.OTHER;
            } else if (this.attackStyle == AttackStyle.CASTING && castingMode == 1) {
                this.attackStyle = AttackStyle.DEFENSIVE_CASTING;
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int currentAutoRetaliateVarbit;
        int currentAttackStyleVarbit = this.client.getVar(43);
        int currentEquippedWeaponTypeVarbit = this.client.getVar(357);
        int currentCastingModeVarbit = this.client.getVar(2668);
        if (this.attackStyleVarbit != currentAttackStyleVarbit || this.equippedWeaponTypeVarbit != currentEquippedWeaponTypeVarbit || this.castingModeVarbit != currentCastingModeVarbit) {
            boolean weaponSwitch = currentEquippedWeaponTypeVarbit != this.equippedWeaponTypeVarbit;
            this.attackStyleVarbit = currentAttackStyleVarbit;
            this.equippedWeaponTypeVarbit = currentEquippedWeaponTypeVarbit;
            this.castingModeVarbit = currentCastingModeVarbit;
            this.updateAttackStyle(this.equippedWeaponTypeVarbit, this.attackStyleVarbit, this.castingModeVarbit);
        }
        if ((currentAutoRetaliateVarbit = this.client.getVarpValue(172)) != this.autoRetaliateVarbit) {
            this.getAutoRetaliateVarbit();
        }
    }

    @Nullable
    public void getAutoRetaliateVarbit() {
        this.autoRetaliateVarbit = this.client.getVarpValue(172);
    }

    @Nullable
    public String getAutoRetaliateText() {
        this.autoRetaliate = this.autoRetaliateVarbit == 0 ? "On" : "Off";
        return this.autoRetaliate;
    }
}

