/*
 * Decompiled with CFR 0.152.
 */
package com.combatinformation;

import com.combatinformation.AttackStyle;
import com.combatinformation.CombatInformationConfig;
import com.combatinformation.CombatInformationPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Skill;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.util.ColorUtil;

public class CombatInformationOverlay
extends OverlayPanel {
    private final Client client;
    private final CombatInformationConfig config;
    private final CombatInformationPlugin plugin;

    @Inject
    private CombatInformationOverlay(Client client, CombatInformationConfig config, CombatInformationPlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.setPriority(OverlayPriority.MED);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Combat information overlay."));
    }

    public Dimension render(Graphics2D graphics) {
        this.setOverlayText(Skill.ATTACK);
        this.setOverlayText(Skill.STRENGTH);
        this.setOverlayText(Skill.DEFENCE);
        this.setOverlayText(Skill.RANGED);
        this.setOverlayText(Skill.MAGIC);
        this.setAttackStyleText();
        return super.render(graphics);
    }

    private void setOverlayText(Skill skill) {
        int boosted = this.client.getBoostedSkillLevel(skill);
        int base = this.client.getRealSkillLevel(skill);
        int boost = boosted - base;
        Color strColor = this.getTextColor(boost);
        String str = ColorUtil.prependColorTag((String)Integer.toString(boosted), (Color)strColor);
        this.panelComponent.getChildren().add(LineComponent.builder().left(skill.getName()).right(str).rightColor(strColor).build());
    }

    private void setAttackStyleText() {
        AttackStyle attackStyle = this.plugin.getAttackStyle();
        String attackStyleString = attackStyle.getName();
        this.panelComponent.getChildren().add(LineComponent.builder().left(attackStyleString).leftColor(Color.ORANGE).right(this.plugin.getAutoRetaliateText()).rightColor(Color.ORANGE).build());
    }

    private Color getTextColor(int boost) {
        if (boost < 0) {
            return new Color(238, 51, 51);
        }
        return boost <= 0 ? Color.WHITE : Color.GREEN;
    }
}

