/*
 * Decompiled with CFR 0.152.
 */
package com.composthelper.compostbin;

import com.composthelper.CompostHelperConfig;
import com.composthelper.CompostHelperPlugin;
import com.composthelper.compostbin.CompostBin;
import com.composthelper.compostbin.CompostBinAction;
import com.composthelper.compostbin.CompostBinObject;
import com.composthelper.compostbin.CompostBinState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.TextComponent;

public class CompostBinOverlay
extends Overlay {
    private static final int MAX_DISTANCE = 2350;
    private static final int TEXT_HEIGHT = 11;
    private final Client client;
    private final CompostHelperPlugin plugin;
    private final CompostHelperConfig config;
    private final TextComponent typeTextComponent = new TextComponent();
    private final TextComponent countTextComponent = new TextComponent();

    @Inject
    private CompostBinOverlay(Client client, CompostHelperPlugin plugin, CompostHelperConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        CompostBin compostBin = this.plugin.getVisibleCompostBin();
        if (compostBin == null) {
            return null;
        }
        GameObject gameObject = compostBin.getGameObject();
        LocalPoint objectMinLocation = LocalPoint.fromScene((int)gameObject.getSceneMinLocation().getX(), (int)gameObject.getSceneMinLocation().getY());
        LocalPoint objectMaxLocation = LocalPoint.fromScene((int)gameObject.getSceneMaxLocation().getX(), (int)gameObject.getSceneMaxLocation().getY());
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        if (localLocation.distanceTo(objectMinLocation) <= 2350) {
            int varbitValue;
            CompostBinObject compostBinObject = compostBin.getCompostBinObject();
            CompostBinState state = compostBinObject.getState(varbitValue = this.client.getVarbitValue(compostBinObject.getVarbit()));
            if (state == null) {
                return null;
            }
            int line = 0;
            if (this.config.showCompostType()) {
                this.renderTypeTextComponent(graphics, state, line++, objectMinLocation, objectMaxLocation);
            }
            int capacity = compostBin.getCompostBinObject() == CompostBinObject.FARMING_GUILD ? 30 : 15;
            this.renderCountTextComponent(graphics, state, capacity, line, objectMinLocation, objectMaxLocation);
        }
        return null;
    }

    private void renderTypeTextComponent(Graphics2D graphics, CompostBinState state, int lineNumber, LocalPoint minLocation, LocalPoint maxLocation) {
        String typeText = state.getType() != null ? state.getType().toString() : (state.getAction() == CompostBinAction.EMPTY ? "Empty" : "Error");
        Color textColor = state.getAction().getTextColor();
        java.awt.Point typeTextLocation = this.calculateTextLocation(graphics, typeText, lineNumber, minLocation, maxLocation);
        this.typeTextComponent.setText(typeText);
        this.typeTextComponent.setColor(textColor);
        this.typeTextComponent.setPosition(typeTextLocation);
        this.typeTextComponent.render(graphics);
    }

    private void renderCountTextComponent(Graphics2D graphics, CompostBinState state, int capacity, int lineNumber, LocalPoint minLocation, LocalPoint maxLocation) {
        String countText = Integer.toString(state.getContentCount());
        if (this.config.showMaxSize()) {
            countText = String.format("%s / %s", countText, capacity);
        }
        Color textColor = state.getAction().getTextColor();
        java.awt.Point countTextLocation = this.calculateTextLocation(graphics, countText, lineNumber, minLocation, maxLocation);
        this.countTextComponent.setText(countText);
        this.countTextComponent.setColor(textColor);
        this.countTextComponent.setPosition(countTextLocation);
        this.countTextComponent.render(graphics);
    }

    private java.awt.Point calculateTextLocation(Graphics2D graphics, String text, int lineNumber, LocalPoint ... points) {
        int x = 0;
        int y = 0;
        for (LocalPoint point : points) {
            Point textLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)point, (String)text, (int)200);
            x += textLocation.getX();
            y += textLocation.getY();
        }
        return new java.awt.Point(x / points.length, y / points.length + lineNumber * 11);
    }
}

