/*
 * Decompiled with CFR 0.152.
 */
package com.composthelper;

import com.composthelper.CompostHelperConfig;
import com.composthelper.compostbin.CompostBin;
import com.composthelper.compostbin.CompostBinObject;
import com.composthelper.compostbin.CompostBinOverlay;
import com.google.inject.Provides;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Compost Helper")
public class CompostHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CompostHelperPlugin.class);
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CompostBinOverlay overlay;
    @Nullable
    private CompostBin visibleCompostBin;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.visibleCompostBin = null;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject object = event.getGameObject();
        for (CompostBinObject compostBin : CompostBinObject.values()) {
            if (compostBin.getObjectId() != object.getId()) continue;
            this.visibleCompostBin = new CompostBin(object, compostBin);
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        GameObject object = event.getGameObject();
        if (this.visibleCompostBin != null && object.getId() == this.visibleCompostBin.getGameObject().getId()) {
            this.visibleCompostBin = null;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOADING) {
            this.visibleCompostBin = null;
        }
    }

    @Provides
    CompostHelperConfig provideConfig(ConfigManager configManager) {
        return (CompostHelperConfig)configManager.getConfig(CompostHelperConfig.class);
    }

    @Nullable
    public CompostBin getVisibleCompostBin() {
        return this.visibleCompostBin;
    }
}

