/*
 * Decompiled with CFR 0.152.
 */
package com.maxhitalert;

import com.google.inject.Provides;
import com.maxhitalert.MaxHitAlertConfig;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="MaxHitPlugin")
public class MaxHitAlertPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MaxHitAlertPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private MaxHitAlertConfig config;
    @Inject
    private ClientThread clientThread;

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        if (hitsplatApplied.getHitsplat().isMine() && (hitsplatApplied.getHitsplat().getHitsplatType() == 45 || hitsplatApplied.getHitsplat().getHitsplatType() == 20 || hitsplatApplied.getHitsplat().getHitsplatType() == 43)) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Hit max detected!", null);
            String tokenWebhook = this.config.greeting();
            if (Objects.equals(this.config.greeting(), "null")) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Tried sending discord notification but got invalid webhook url.", null);
            } else {
                String title = "Got a Max Hit!";
                String message = "Max Hit!";
                Object jsonBrut = "";
                jsonBrut = (String)jsonBrut + "{\"embeds\": [{\"title\": \"" + title + "\",\"description\": \"" + message + "\",\"color\": 15258703}]}";
                MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", (String)jsonBrut);
                MultipartBody requestBody = requestBodyBuilder.build();
                Request request = new Request.Builder().url(tokenWebhook).post((RequestBody)requestBody).build();
                this.okHttpClient.newCall(request).enqueue(new Callback(){

                    public void onFailure(Call call, IOException e) {
                        MaxHitAlertPlugin.this.clientThread.invokeLater(() -> MaxHitAlertPlugin.this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Tried sending discord notification but got an error", null));
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        response.close();
                    }
                });
            }
        }
    }

    @Provides
    MaxHitAlertConfig provideConfig(ConfigManager configManager) {
        return (MaxHitAlertConfig)configManager.getConfig(MaxHitAlertConfig.class);
    }
}

