/*
 * Decompiled with CFR 0.152.
 */
package com.consumablecooldowns;

import com.consumablecooldowns.ConsumableItemCooldown;
import com.consumablecooldowns.ConsumableItemType;
import java.util.function.Predicate;

public class ConsumableItem {
    private final ConsumableItemType type;
    private final int actionCooldownTicks;
    private final int eatCooldownTicks;
    private final int comboEatCooldownTicks;
    private final int drinkCooldownTicks;
    private final Predicate<Integer> itemFilter;

    public ConsumableItem(ConsumableItemType type, int actionCooldownTicks, int eatCooldownTicks, int comboEatCooldownTicks, Predicate<Integer> itemFilter) {
        this.type = type;
        this.actionCooldownTicks = actionCooldownTicks;
        this.eatCooldownTicks = eatCooldownTicks;
        this.comboEatCooldownTicks = comboEatCooldownTicks;
        this.drinkCooldownTicks = 0;
        this.itemFilter = itemFilter;
    }

    public ConsumableItem(ConsumableItemType type, int actionCooldownTicks, int eatCooldownTicks, Predicate<Integer> itemFilter) {
        this.type = type;
        this.actionCooldownTicks = actionCooldownTicks;
        this.eatCooldownTicks = eatCooldownTicks;
        this.comboEatCooldownTicks = 0;
        this.drinkCooldownTicks = 0;
        this.itemFilter = itemFilter;
    }

    public ConsumableItem(ConsumableItemType type, int actionCooldownTicks, int eatCooldownTicks, int comboEatCooldownTicks, int drinkCooldownTicks, Predicate<Integer> itemFilter) {
        this.type = type;
        this.actionCooldownTicks = actionCooldownTicks;
        this.eatCooldownTicks = eatCooldownTicks;
        this.comboEatCooldownTicks = comboEatCooldownTicks;
        this.drinkCooldownTicks = drinkCooldownTicks;
        this.itemFilter = itemFilter;
    }

    public ConsumableItemCooldown getFullCooldown() {
        switch (this.type) {
            case FOOD: 
            case COOKED_CRAB_MEAT: 
            case CAKE: 
            case F2P_FIRST_SLICE: 
            case F2P_SECOND_SLICE: 
            case P2P_PIE: {
                return new ConsumableItemCooldown(this.eatCooldownTicks, this.cooldownTicksToClientTicks(this.eatCooldownTicks));
            }
            case DRINK: {
                return new ConsumableItemCooldown(this.drinkCooldownTicks, this.cooldownTicksToClientTicks(this.drinkCooldownTicks));
            }
            case COMBO_FOOD: {
                return new ConsumableItemCooldown(this.comboEatCooldownTicks, this.cooldownTicksToClientTicks(this.comboEatCooldownTicks));
            }
        }
        return null;
    }

    public int cooldownTicksToClientTicks(int tickCount) {
        return (tickCount - 1) * 600 / 20;
    }

    ConsumableItemType getType() {
        return this.type;
    }

    int getActionCooldownTicks() {
        return this.actionCooldownTicks;
    }

    int getEatCooldownTicks() {
        return this.eatCooldownTicks;
    }

    int getComboEatCooldownTicks() {
        return this.comboEatCooldownTicks;
    }

    int getDrinkCooldownTicks() {
        return this.drinkCooldownTicks;
    }

    Predicate<Integer> getItemFilter() {
        return this.itemFilter;
    }
}

