/*
 * Decompiled with CFR 0.152.
 */
package com.consumablecooldowns;

import com.consumablecooldowns.ConsumableCooldownsConfig;
import com.consumablecooldowns.ConsumableCooldownsPlugin;
import com.consumablecooldowns.ConsumableItem;
import com.consumablecooldowns.ConsumableItemCooldown;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumableCooldownsTextOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(ConsumableCooldownsTextOverlay.class);
    private final ConsumableCooldownsPlugin plugin;
    private final ConsumableCooldownsConfig config;

    @Inject
    public ConsumableCooldownsTextOverlay(ConsumableCooldownsPlugin plugin, ConsumableCooldownsConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        graphics.setFont(this.config.getFontType().getFont());
        this.renderConsumableCooldowns(graphics, widgetItem);
    }

    private void renderConsumableCooldowns(Graphics2D graphics, WidgetItem widgetItem) {
        if (this.plugin.isNoConsumableCooldownActive()) {
            return;
        }
        Rectangle slotBounds = widgetItem.getCanvasBounds();
        int itemId = widgetItem.getId();
        if (itemId == 6512) {
            return;
        }
        ConsumableItem consumableItem = this.plugin.getConsumableItemFromId(itemId);
        if (consumableItem == null) {
            return;
        }
        ConsumableItemCooldown cooldownRemaining = this.plugin.getCooldownForConsumableItem(consumableItem);
        if (cooldownRemaining == null) {
            return;
        }
        switch (this.config.cooldownTextMode()) {
            case GAME_TICKS: {
                this.renderCooldownText(graphics, cooldownRemaining.toGameTicks(), slotBounds);
                break;
            }
            case SECONDS_MILLISECONDS: {
                this.renderCooldownText(graphics, cooldownRemaining.toSecondsMilliseconds(), slotBounds);
                break;
            }
        }
    }

    private void renderCooldownText(Graphics2D graphics, String delayText, Rectangle slotBounds) {
        if (delayText.equals("0.0")) {
            return;
        }
        FontMetrics fm = graphics.getFontMetrics();
        Rectangle2D textBounds = fm.getStringBounds(delayText, graphics);
        int textX = (int)(slotBounds.getX() + slotBounds.getWidth() / 2.0 - textBounds.getWidth() / 2.0) - this.config.getTextXOffset();
        int textY = (int)(slotBounds.getY() + slotBounds.getHeight() / 2.0 + textBounds.getHeight() / 2.0) - this.config.getTextYOffset();
        graphics.setColor(this.config.getTextShadowColor());
        graphics.drawString(delayText, textX + 1, textY + 1);
        graphics.setColor(this.config.getTextColor());
        graphics.drawString(delayText, textX, textY);
    }
}

