/*
 * Decompiled with CFR 0.152.
 */
package com.consumablecooldowns;

import com.consumablecooldowns.ConsumableCooldownsConfig;
import com.consumablecooldowns.ConsumableCooldownsOverlay;
import com.consumablecooldowns.ConsumableCooldownsTextOverlay;
import com.consumablecooldowns.ConsumableItem;
import com.consumablecooldowns.ConsumableItemCooldown;
import com.consumablecooldowns.ConsumableItemIds;
import com.consumablecooldowns.ConsumableItemType;
import com.consumablecooldowns.InventoryConsumableItemAction;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Consumable Cooldowns", description="Displays cooldowns on food & drink items in your inventory", tags={"inventory", "timer", "pvm", "overlay", "cd", "food", "pots", "potion", "highlight"})
public class ConsumableCooldownsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ConsumableCooldownsPlugin.class);
    private static final ImmutableSet<ConsumableItem> CONSUMABLES;
    private static final Pattern EAT_PATTERN;
    private static final Pattern DRINK_PATTERN;
    private static final int ITEM_COOLDOWN_PREVIEW_TICKS = 2;
    private static final int ITEM_COOLDOWN_PREVIEW_CLIENT_TICKS = 60;
    private static final int ITEM_COOLDOWN_PREVIEW_GRACE_PERIOD_CLIENT_TICKS = -30;
    private static final int LAST_INVENTORY_SLOT_INDEX = 27;
    private static final boolean SHOULD_LOG_DEBUG = false;
    @Inject
    private Client client;
    @Inject
    private ConsumableCooldownsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ConsumableCooldownsOverlay overlay;
    @Inject
    private ConsumableCooldownsTextOverlay textOverlay;
    private int actionCooldownTicks;
    private int eatCooldownTicks;
    private int eatCooldownClientTicks;
    private int drinkCooldownTicks;
    private int drinkCooldownClientTicks;
    private int comboEatCooldownTicks;
    private int comboEatCooldownClientTicks;
    private int previewCooldownTicks;
    private int previewCooldownClientTicks;
    private int lastFoodConsumedTick;
    private ConsumableItem lastFoodConsumed;
    private int lastDrinkConsumedTick;
    private ConsumableItem lastDrinkConsumed;
    private int lastComboFoodConsumedTick;
    private ConsumableItem lastComboFoodConsumed;
    private List<InventoryConsumableItemAction> inventoryConsumableItemActions;

    @Provides
    ConsumableCooldownsConfig getConfig(ConfigManager configManager) {
        return (ConsumableCooldownsConfig)configManager.getConfig(ConsumableCooldownsConfig.class);
    }

    private void setup() {
        this.actionCooldownTicks = 0;
        this.eatCooldownTicks = 0;
        this.comboEatCooldownTicks = 0;
        this.drinkCooldownTicks = 0;
        this.eatCooldownClientTicks = 0;
        this.comboEatCooldownClientTicks = 0;
        this.drinkCooldownClientTicks = 0;
        this.previewCooldownTicks = 2;
        this.previewCooldownClientTicks = 60;
        this.lastFoodConsumedTick = -1;
        this.lastFoodConsumed = null;
        this.lastDrinkConsumedTick = -1;
        this.lastDrinkConsumed = null;
        this.lastComboFoodConsumedTick = -1;
        this.lastComboFoodConsumed = null;
    }

    protected void startUp() throws Exception {
        this.inventoryConsumableItemActions = new ArrayList<InventoryConsumableItemAction>();
        this.setup();
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.textOverlay);
    }

    protected void shutDown() throws Exception {
        this.inventoryConsumableItemActions = null;
        this.setup();
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.textOverlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("consumablecooldowns")) {
            return;
        }
        switch (event.getKey()) {
            case "cooldownIndicatorMode": {
                this.overlay.invalidateInventoryIconInfoCache();
                break;
            }
            case "itemCooldownIndicatorFillColor": 
            case "itemCooldownIndicatorFillOpacity": {
                this.overlay.invalidateFillCache();
                break;
            }
            case "showItemCooldownPreview": {
                if (!this.config.showItemCooldownPreview()) break;
                this.previewCooldownTicks = 2;
                this.previewCooldownClientTicks = 60;
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState gameState = event.getGameState();
        if (gameState == GameState.LOGGING_IN || gameState == GameState.CONNECTION_LOST || gameState == GameState.HOPPING) {
            this.inventoryConsumableItemActions.clear();
            this.setup();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.eatCooldownClientTicks > 0) {
            --this.eatCooldownClientTicks;
        }
        if (this.comboEatCooldownClientTicks > 0) {
            --this.comboEatCooldownClientTicks;
        }
        if (this.drinkCooldownClientTicks > 0) {
            --this.drinkCooldownClientTicks;
        }
        if (this.config.showItemCooldownPreview() && this.previewCooldownClientTicks > -30) {
            --this.previewCooldownClientTicks;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.actionCooldownTicks > 0) {
            --this.actionCooldownTicks;
        }
        if (this.eatCooldownTicks > 0) {
            --this.eatCooldownTicks;
        }
        if (this.comboEatCooldownTicks > 0) {
            --this.comboEatCooldownTicks;
        }
        if (this.drinkCooldownTicks > 0) {
            --this.drinkCooldownTicks;
        }
        if (this.config.showItemCooldownPreview() && this.previewCooldownTicks > -1) {
            --this.previewCooldownTicks;
        } else if (this.config.showItemCooldownPreview()) {
            this.previewCooldownTicks = 2;
            this.previewCooldownClientTicks = 60;
        }
        ListIterator<InventoryConsumableItemAction> actionsIterator = this.inventoryConsumableItemActions.listIterator();
        while (actionsIterator.hasNext()) {
            InventoryConsumableItemAction itemAction = actionsIterator.next();
            int ticksSinceAction = this.client.getTickCount() - itemAction.getActionTick();
            if (ticksSinceAction <= 1) continue;
            actionsIterator.remove();
            log.warn("{} - Removed item action (id: {}, slot: {}) from queue (size: {}). More than 1 tick since action on tick: {}", new Object[]{this.client.getTickCount(), itemAction.getItemId(), itemAction.getItemSlot(), this.inventoryConsumableItemActions.size(), itemAction.getActionTick()});
        }
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        String menuOption = Text.removeTags((String)event.getMenuOption()).toLowerCase();
        this.logDebug("{} - Menu option clicked: {}. Slot: {}", this.client.getTickCount(), menuOption, event.getMenuEntry().getParam0());
        if (!this.isConsumableMenuOption(menuOption) || this.isMenuOptionItemInInventoryActions(event)) {
            this.logDebug("{} - Menu option skipped. Consumable: {}, already in actions: {}", this.client.getTickCount(), this.isConsumableMenuOption(menuOption), this.isMenuOptionItemInInventoryActions(event));
            return;
        }
        ItemContainer oldInventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (oldInventory == null) {
            return;
        }
        int inventorySlot = event.getMenuEntry().getParam0();
        if (inventorySlot > 27) {
            return;
        }
        Item item = oldInventory.getItems()[inventorySlot];
        this.inventoryConsumableItemActions.add(new InventoryConsumableItemAction(oldInventory.getItems(), item.getId(), inventorySlot, this.client.getTickCount()));
        this.logDebug("{} - Added item in slot: {} with id: {} to queue", this.client.getTickCount(), inventorySlot, item.getId());
    }

    @Subscribe
    private void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.INVENTORY.getId()) {
            return;
        }
        this.processInventoryChanges(event.getItemContainer());
        this.logDebug("{} - Inventory changed. Queue size: {}", this.client.getTickCount(), this.inventoryConsumableItemActions.size());
    }

    private void processInventoryChanges(ItemContainer itemContainer) {
        ListIterator<InventoryConsumableItemAction> actionsIterator = this.inventoryConsumableItemActions.listIterator();
        while (actionsIterator.hasNext()) {
            InventoryConsumableItemAction itemAction = actionsIterator.next();
            this.logDebug("{} - Item in slot: {} with id: {} and idx: {} with size: {} peeked from queue", this.client.getTickCount(), itemAction.getItemSlot(), itemAction.getItemId(), actionsIterator.nextIndex(), this.inventoryConsumableItemActions.size());
            int itemId = itemAction.getItemId();
            ConsumableItem consumableItem = this.getConsumableItemFromId(itemId);
            if (consumableItem == null) {
                this.logDebug("{} - Item in slot: {} with id: {} skipped. No consumable item found", this.client.getTickCount(), itemAction.getItemSlot(), itemAction.getItemId());
                actionsIterator.remove();
                continue;
            }
            if (!itemAction.isItemConsumed(itemContainer.getItems())) {
                this.logDebug("{} - Item in slot: {} with id: {} skipped. Item still in slot", this.client.getTickCount(), itemAction.getItemSlot(), itemAction.getItemId());
                if (itemAction.getActionTick() == this.client.getTickCount()) continue;
                actionsIterator.remove();
                continue;
            }
            actionsIterator.remove();
            this.itemConsumed(consumableItem, itemAction);
        }
    }

    public ConsumableItem getConsumableItemFromId(int itemId) {
        for (ConsumableItem consumableItem : CONSUMABLES) {
            if (!consumableItem.getItemFilter().test(itemId)) continue;
            return consumableItem;
        }
        return null;
    }

    private Set<ConsumableItemType> getMaxLastConsumedItemsTickTimers(int max, Map<ConsumableItemType, Integer> lastConsumedItemsTickTimers) {
        HashSet<ConsumableItemType> maxTickTimers = new HashSet<ConsumableItemType>();
        for (Map.Entry<ConsumableItemType, Integer> entry : lastConsumedItemsTickTimers.entrySet()) {
            if (entry.getValue() != max) continue;
            maxTickTimers.add(entry.getKey());
        }
        return maxTickTimers;
    }

    private ConsumableItem getLastFoodCooldownSource() {
        if (this.eatCooldownTicks == 0 && this.drinkCooldownTicks == 0 && this.comboEatCooldownTicks == 0) {
            return null;
        }
        Map<ConsumableItemType, Integer> lastConsumedItemsTickTimers = Map.of(ConsumableItemType.FOOD, this.lastFoodConsumedTick, ConsumableItemType.DRINK, this.lastDrinkConsumedTick, ConsumableItemType.COMBO_FOOD, this.lastComboFoodConsumedTick);
        int max = Math.max(this.lastFoodConsumedTick, this.lastDrinkConsumedTick);
        Set<ConsumableItemType> maxCooldownTypes = this.getMaxLastConsumedItemsTickTimers(max = Math.max(max, this.lastComboFoodConsumedTick), lastConsumedItemsTickTimers);
        if (maxCooldownTypes.contains((Object)ConsumableItemType.COMBO_FOOD)) {
            return this.lastComboFoodConsumed;
        }
        if (maxCooldownTypes.contains((Object)ConsumableItemType.DRINK)) {
            return this.lastDrinkConsumed;
        }
        if (maxCooldownTypes.contains((Object)ConsumableItemType.FOOD)) {
            return this.lastFoodConsumed;
        }
        return null;
    }

    private ConsumableItem getLastDrinkCooldownSource() {
        if (this.drinkCooldownTicks == 0 && this.comboEatCooldownTicks == 0) {
            return null;
        }
        Map<ConsumableItemType, Integer> lastConsumedItemsTickTimers = Map.of(ConsumableItemType.DRINK, this.lastDrinkConsumedTick, ConsumableItemType.COMBO_FOOD, this.lastComboFoodConsumedTick);
        int max = Math.max(this.lastDrinkConsumedTick, this.lastComboFoodConsumedTick);
        Set<ConsumableItemType> maxCooldownTypes = this.getMaxLastConsumedItemsTickTimers(max, lastConsumedItemsTickTimers);
        if (maxCooldownTypes.contains((Object)ConsumableItemType.COMBO_FOOD)) {
            return this.lastComboFoodConsumed;
        }
        if (maxCooldownTypes.contains((Object)ConsumableItemType.DRINK)) {
            return this.lastDrinkConsumed;
        }
        return null;
    }

    private ConsumableItem getLastComboFoodCooldownSource() {
        if (this.eatCooldownTicks == 0 && this.comboEatCooldownTicks == 0) {
            return null;
        }
        Map<ConsumableItemType, Integer> lastConsumedItemsTickTimers = Map.of(ConsumableItemType.FOOD, this.lastFoodConsumedTick, ConsumableItemType.COMBO_FOOD, this.lastComboFoodConsumedTick);
        int max = Math.max(this.lastFoodConsumedTick, this.lastComboFoodConsumedTick);
        Set<ConsumableItemType> maxCooldownTypes = this.getMaxLastConsumedItemsTickTimers(max, lastConsumedItemsTickTimers);
        if (maxCooldownTypes.contains((Object)ConsumableItemType.COMBO_FOOD)) {
            return this.lastComboFoodConsumed;
        }
        if (maxCooldownTypes.contains((Object)ConsumableItemType.FOOD)) {
            return this.lastFoodConsumed;
        }
        return null;
    }

    public ConsumableItemCooldown getLastCooldownSourceByType(ConsumableItemType type) {
        if (this.config.showItemCooldownPreview()) {
            return new ConsumableItemCooldown(2, 60);
        }
        ConsumableItem cooldownSource = null;
        switch (type) {
            case FOOD: 
            case COOKED_CRAB_MEAT: 
            case CAKE: 
            case F2P_FIRST_SLICE: 
            case F2P_SECOND_SLICE: 
            case P2P_PIE: {
                cooldownSource = this.getLastFoodCooldownSource();
                break;
            }
            case DRINK: {
                cooldownSource = this.getLastDrinkCooldownSource();
                break;
            }
            case COMBO_FOOD: {
                cooldownSource = this.getLastComboFoodCooldownSource();
            }
        }
        if (cooldownSource == null) {
            return null;
        }
        return cooldownSource.getFullCooldown();
    }

    public ConsumableItemCooldown getCooldownForConsumableItem(ConsumableItem consumableItem) {
        if (this.config.showItemCooldownPreview()) {
            return new ConsumableItemCooldown(this.previewCooldownTicks, this.previewCooldownClientTicks);
        }
        switch (consumableItem.getType()) {
            case FOOD: 
            case COOKED_CRAB_MEAT: 
            case CAKE: 
            case F2P_FIRST_SLICE: 
            case F2P_SECOND_SLICE: 
            case P2P_PIE: {
                if (this.eatCooldownTicks <= 0) {
                    return null;
                }
                return new ConsumableItemCooldown(this.eatCooldownTicks, this.eatCooldownClientTicks);
            }
            case DRINK: {
                if (this.drinkCooldownTicks <= 0) {
                    return null;
                }
                return new ConsumableItemCooldown(this.drinkCooldownTicks, this.drinkCooldownClientTicks);
            }
            case COMBO_FOOD: {
                if (this.comboEatCooldownTicks <= 0) {
                    return null;
                }
                return new ConsumableItemCooldown(this.comboEatCooldownTicks, this.comboEatCooldownClientTicks);
            }
        }
        return null;
    }

    public boolean isNoConsumableCooldownActive() {
        return !this.config.showItemCooldownPreview() && this.eatCooldownTicks <= 0 && this.drinkCooldownTicks <= 0 && this.comboEatCooldownTicks <= 0 || this.config.showItemCooldownPreview() && this.previewCooldownTicks <= 0;
    }

    private void itemConsumed(ConsumableItem consumableItem, InventoryConsumableItemAction itemAction) {
        ConsumableItemType consumableItemType = consumableItem.getType();
        this.logDebug("{} - {} item with id: {} was consumed", new Object[]{this.client.getTickCount(), consumableItemType, itemAction.getItemId()});
        switch (consumableItemType) {
            case FOOD: 
            case COOKED_CRAB_MEAT: 
            case CAKE: 
            case F2P_FIRST_SLICE: 
            case F2P_SECOND_SLICE: 
            case P2P_PIE: {
                this.lastFoodConsumedTick = this.client.getTickCount();
                this.lastFoodConsumed = consumableItem;
                this.eatCooldownTicks = consumableItem.getEatCooldownTicks();
                this.eatCooldownClientTicks = consumableItem.cooldownTicksToClientTicks(this.eatCooldownTicks);
                this.actionCooldownTicks += consumableItem.getActionCooldownTicks();
                this.logDebug("{} - FOOD - eat: {}, comboEat: {}, drink: {}, action: {}", this.client.getTickCount(), this.eatCooldownTicks, this.comboEatCooldownTicks, this.drinkCooldownTicks, this.actionCooldownTicks);
                break;
            }
            case DRINK: {
                this.lastDrinkConsumedTick = this.client.getTickCount();
                this.lastDrinkConsumed = consumableItem;
                this.drinkCooldownTicks = consumableItem.getDrinkCooldownTicks();
                this.drinkCooldownClientTicks = consumableItem.cooldownTicksToClientTicks(this.drinkCooldownTicks);
                this.eatCooldownTicks = consumableItem.getEatCooldownTicks();
                this.eatCooldownClientTicks = consumableItem.cooldownTicksToClientTicks(this.eatCooldownTicks);
                this.actionCooldownTicks += consumableItem.getActionCooldownTicks();
                this.logDebug("{} - POTION - eat: {}, comboEat: {}, drink: {}, action: {}", this.client.getTickCount(), this.eatCooldownTicks, this.comboEatCooldownTicks, this.drinkCooldownTicks, this.actionCooldownTicks);
                break;
            }
            case COMBO_FOOD: {
                this.lastComboFoodConsumedTick = this.client.getTickCount();
                this.lastComboFoodConsumed = consumableItem;
                this.eatCooldownTicks = consumableItem.getEatCooldownTicks();
                this.eatCooldownClientTicks = consumableItem.cooldownTicksToClientTicks(this.eatCooldownTicks);
                this.comboEatCooldownTicks = consumableItem.getComboEatCooldownTicks();
                this.comboEatCooldownClientTicks = consumableItem.cooldownTicksToClientTicks(this.comboEatCooldownTicks);
                this.drinkCooldownTicks = consumableItem.getDrinkCooldownTicks();
                this.drinkCooldownClientTicks = consumableItem.cooldownTicksToClientTicks(this.drinkCooldownTicks);
                this.actionCooldownTicks += consumableItem.getActionCooldownTicks();
                this.logDebug("{} - COMBO - eat: {}, comboEat: {}, drink: {}, action: {}", this.client.getTickCount(), this.eatCooldownTicks, this.comboEatCooldownTicks, this.drinkCooldownTicks, this.actionCooldownTicks);
            }
        }
    }

    private boolean isConsumableMenuOption(String menuOption) {
        return EAT_PATTERN.matcher(menuOption).find() || DRINK_PATTERN.matcher(menuOption).find();
    }

    private boolean isMenuOptionItemInInventoryActions(MenuOptionClicked event) {
        return this.inventoryConsumableItemActions.stream().anyMatch(itemAction -> itemAction.getItemId() == event.getItemId() && itemAction.getItemSlot() == event.getParam0());
    }

    private void logDebug(String message, Object ... args) {
    }

    static {
        Object[] objectArray = new ConsumableItem[2];
        objectArray[0] = new ConsumableItem(ConsumableItemType.P2P_PIE, 3, 1, ConsumableItemIds.P2P_PIE_ITEM_IDS::contains);
        objectArray[1] = new ConsumableItem(ConsumableItemType.COOKED_CRAB_MEAT, 2, 2, ConsumableItemIds.COOKED_CRAB_MEAT_ITEM_IDS::contains);
        CONSUMABLES = ImmutableSet.of((Object)new ConsumableItem(ConsumableItemType.FOOD, 3, 3, ConsumableItemIds.FOOD_ITEM_IDS::contains), (Object)new ConsumableItem(ConsumableItemType.DRINK, 0, 3, 0, 3, ConsumableItemIds.DRINK_ITEM_IDS::contains), (Object)new ConsumableItem(ConsumableItemType.COMBO_FOOD, 2, 3, 3, 3, ConsumableItemIds.COMBO_FOOD_ITEM_IDS::contains), (Object)new ConsumableItem(ConsumableItemType.CAKE, 3, 2, ConsumableItemIds.CAKE_ITEM_IDS::contains), (Object)new ConsumableItem(ConsumableItemType.F2P_FIRST_SLICE, 3, 1, ConsumableItemIds.F2P_FIRST_SLICE_ITEM_IDS::contains), (Object)new ConsumableItem(ConsumableItemType.F2P_SECOND_SLICE, 3, 2, ConsumableItemIds.F2P_SECOND_SLICE_ITEM_IDS::contains), (Object[])objectArray);
        EAT_PATTERN = Pattern.compile("^eat");
        DRINK_PATTERN = Pattern.compile("^drink");
    }
}

