/*
 * Decompiled with CFR 0.152.
 */
package com.consumablecooldowns;

import com.consumablecooldowns.ConsumableCooldownsConfig;
import com.consumablecooldowns.ConsumableCooldownsPlugin;
import com.consumablecooldowns.ConsumableItem;
import com.consumablecooldowns.ConsumableItemCooldown;
import com.consumablecooldowns.CooldownIndicatorMode;
import com.consumablecooldowns.InventoryIconInfo;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumableCooldownsOverlay
extends WidgetItemOverlay {
    private static final Logger log = LoggerFactory.getLogger(ConsumableCooldownsOverlay.class);
    private final ConsumableCooldownsPlugin plugin;
    private final ConsumableCooldownsConfig config;
    private final ItemManager itemManager;
    private final Cache<Long, Image> fillCache;
    private final Cache<Long, InventoryIconInfo> inventoryIconInfoCache;

    @Inject
    public ConsumableCooldownsOverlay(ItemManager itemManager, ConsumableCooldownsPlugin plugin, ConsumableCooldownsConfig config) {
        this.itemManager = itemManager;
        this.plugin = plugin;
        this.config = config;
        this.fillCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(32L).build();
        this.inventoryIconInfoCache = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(32L).build();
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        this.renderConsumableCooldowns(graphics, widgetItem);
    }

    void invalidateFillCache() {
        this.fillCache.invalidateAll();
    }

    void invalidateInventoryIconInfoCache() {
        this.inventoryIconInfoCache.invalidateAll();
    }

    private void renderConsumableCooldowns(Graphics2D graphics, WidgetItem widgetItem) {
        if (this.plugin.isNoConsumableCooldownActive()) {
            return;
        }
        Rectangle slotBounds = widgetItem.getCanvasBounds();
        int itemId = widgetItem.getId();
        if (itemId == 6512) {
            return;
        }
        ConsumableItem consumableItem = this.plugin.getConsumableItemFromId(itemId);
        if (consumableItem == null) {
            return;
        }
        ConsumableItemCooldown cooldownRemaining = this.plugin.getCooldownForConsumableItem(consumableItem);
        if (cooldownRemaining == null) {
            return;
        }
        int opacity = (int)((float)this.config.getItemCooldownIndicatorFillOpacity() * 2.55f);
        switch (this.config.getCooldownIndicatorMode()) {
            case FILL: {
                this.renderCooldownFill(graphics, widgetItem, slotBounds, opacity);
                break;
            }
            case BOTTOM_TO_TOP: {
                this.renderCooldownBottomToTop(graphics, this.getCooldownPercent(consumableItem, cooldownRemaining), widgetItem, slotBounds, opacity);
                break;
            }
            case PIE: {
                this.renderCooldownPie(graphics, this.getCooldownPercent(consumableItem, cooldownRemaining), widgetItem, slotBounds, opacity);
                break;
            }
        }
    }

    private float getCooldownPercent(ConsumableItem consumableItem, ConsumableItemCooldown cooldownRemaining) {
        ConsumableItemCooldown fullCooldown = this.plugin.getLastCooldownSourceByType(consumableItem.getType());
        if (fullCooldown == null) {
            log.warn("No full cooldown found for consumable item type: {}", (Object)consumableItem.getType());
            return 1.0f;
        }
        int elapsedCooldownClientTicks = fullCooldown.getClientTicks() - cooldownRemaining.getClientTicks();
        return (float)elapsedCooldownClientTicks / (float)fullCooldown.getClientTicks();
    }

    private void renderCooldownFill(Graphics2D graphics, WidgetItem widgetItem, Rectangle slotBounds, int opacity) {
        Image image = this.getFillImage(this.config.getItemCooldownIndicatorFillColor(), opacity, widgetItem.getId(), widgetItem.getQuantity());
        graphics.drawImage(image, (int)slotBounds.getX(), (int)slotBounds.getY(), null);
    }

    private void renderCooldownBottomToTop(Graphics2D graphics, float percent, WidgetItem widgetItem, Rectangle slotBounds, int opacity) {
        Rectangle indicatorBoundingBox;
        int clipHeight;
        int itemId = widgetItem.getId();
        int quantity = widgetItem.getQuantity();
        Image image = this.getFillImage(this.config.getItemCooldownIndicatorFillColor(), opacity, itemId, quantity);
        InventoryIconInfo inventoryIconInfo = this.getInventoryIconInfo(itemId, quantity, image);
        if (inventoryIconInfo.width < 0 || inventoryIconInfo.height < 5) {
            clipHeight = Math.min((int)slotBounds.getHeight(), (int)((double)(1.0f - percent) * slotBounds.getHeight()));
            indicatorBoundingBox = slotBounds;
        } else {
            int itemIconHeight = inventoryIconInfo.height + this.config.getBottomToTopFullFillDuration().ordinal();
            clipHeight = Math.min(itemIconHeight, (int)((1.0f - percent) * (float)itemIconHeight));
            indicatorBoundingBox = new Rectangle((int)slotBounds.getX(), (int)slotBounds.getY() + inventoryIconInfo.minY, inventoryIconInfo.width, itemIconHeight);
        }
        graphics.setClip((int)slotBounds.getX(), (int)indicatorBoundingBox.getY(), (int)slotBounds.getWidth(), clipHeight);
        graphics.drawImage(image, (int)slotBounds.getX(), (int)slotBounds.getY(), null);
        graphics.setClip(slotBounds);
    }

    private void renderCooldownPie(Graphics2D graphics, float percent, WidgetItem widgetItem, Rectangle slotBounds, int opacity) {
        int itemId = widgetItem.getId();
        int quantity = widgetItem.getQuantity();
        Image inventoryItemImage = this.getFillImage(this.config.getItemCooldownIndicatorFillColor(), opacity, itemId, quantity);
        InventoryIconInfo inventoryIconInfo = this.getInventoryIconInfo(itemId, quantity, inventoryItemImage);
        int halfLength = (int)Math.ceil(inventoryIconInfo.visibleRadius);
        int length = halfLength * 2;
        Rectangle outerFrame = new Rectangle(slotBounds.x + (int)(inventoryIconInfo.centroid.getX() - (double)halfLength), slotBounds.y + (int)(inventoryIconInfo.centroid.getY() - (double)halfLength), length, length);
        Arc2D.Float arc = new Arc2D.Float(2);
        arc.setAngleStart(90.0);
        arc.setAngleExtent((1.0f - percent) * 360.0f);
        arc.setFrame(outerFrame);
        graphics.setClip(arc);
        graphics.drawImage(inventoryItemImage, (int)slotBounds.getX(), (int)slotBounds.getY(), null);
        graphics.setClip(slotBounds);
    }

    private InventoryIconInfo getInventoryIconInfo(int itemId, int quantity, Image image) {
        long key = (long)itemId << 32 | (long)quantity;
        InventoryIconInfo inventoryIconInfo = (InventoryIconInfo)this.inventoryIconInfoCache.getIfPresent((Object)key);
        if (inventoryIconInfo != null) {
            return inventoryIconInfo;
        }
        inventoryIconInfo = this.getInventoryIconInfoFromImage((BufferedImage)image);
        this.inventoryIconInfoCache.put((Object)key, (Object)inventoryIconInfo);
        return inventoryIconInfo;
    }

    private Image getFillImage(Color color, int opacity, int itemId, int qty) {
        long key = (long)itemId << 32 | (long)qty;
        Image image = (Image)this.fillCache.getIfPresent((Object)key);
        if (image == null) {
            Color fillColor = ColorUtil.colorWithAlpha((Color)color, (int)opacity);
            image = ImageUtil.fillImage((BufferedImage)this.itemManager.getImage(itemId, qty, false), (Color)fillColor);
            this.fillCache.put((Object)key, (Object)image);
        }
        return image;
    }

    private static double getImageVisibleRadius(BufferedImage image, Point2D center) {
        double radius = 0.0;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int pixel = image.getRGB(x, y);
                int pixelAlpha = pixel >>> 24;
                if (pixelAlpha == 0) continue;
                radius = Math.max(radius, center.distanceSq(x, y));
            }
        }
        return Math.sqrt(radius);
    }

    private InventoryIconInfo getInventoryIconInfoFromImage(BufferedImage inventoryIconImage) {
        int minX = inventoryIconImage.getWidth();
        int minY = inventoryIconImage.getHeight();
        int maxX = 0;
        int maxY = 0;
        int pixelCount = 0;
        double centroidX = 0.0;
        double centroidY = 0.0;
        for (int y = 0; y < inventoryIconImage.getHeight() - 1; ++y) {
            for (int x = 0; x < inventoryIconImage.getWidth() - 1; ++x) {
                int pixel = inventoryIconImage.getRGB(x, y);
                int pixelAlpha = pixel >>> 24;
                if (pixelAlpha == 0) continue;
                minX = Math.min(minX, x);
                minY = Math.min(minY, y);
                maxX = Math.max(maxX, x);
                maxY = Math.max(maxY, y);
                if (this.config.getCooldownIndicatorMode() != CooldownIndicatorMode.PIE) continue;
                centroidX += (double)x;
                centroidY += (double)y;
                ++pixelCount;
            }
        }
        if (this.config.getCooldownIndicatorMode() == CooldownIndicatorMode.PIE) {
            Point2D.Double centroid = new Point2D.Double(centroidX / (double)pixelCount, centroidY / (double)pixelCount);
            double visibleRadius = ConsumableCooldownsOverlay.getImageVisibleRadius(inventoryIconImage, centroid);
            return new InventoryIconInfo(minX, minY, maxX - minX, maxY - minY, centroid, visibleRadius);
        }
        return new InventoryIconInfo(minX, minY, maxX - minX, maxY - minY);
    }
}

