/*
 * Decompiled with CFR 0.152.
 */
package com.consumablecooldowns;

import com.consumablecooldowns.BottomToTopCooldownIndicatorStartDelay;
import com.consumablecooldowns.CooldownIndicatorMode;
import com.consumablecooldowns.CooldownTextMode;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.FontType;
import net.runelite.client.config.Range;

@ConfigGroup(value="consumablecooldowns")
public interface ConsumableCooldownsConfig
extends Config {
    public static final String GROUP_NAME = "consumablecooldowns";
    @ConfigSection(name="Item cooldown text", description="Options for the consumable item cooldown text", position=99)
    public static final String itemCooldownTextSection = "itemCooldownText";
    @ConfigSection(name="Item cooldown indicator", description="Options for the consumable item cooldown indicator", position=100)
    public static final String itemCooldownIndicatorSection = "itemCooldownIndicator";
    @ConfigSection(name="Bottom to top indicator", description="Options for the bottom to top consumable item cooldown indicator", closedByDefault=true, position=101)
    public static final String itemBottomToTopCooldownIndicatorSection = "itemBottomToTopCooldownIndicator";

    @ConfigItem(position=0, keyName="showItemCooldownPreview", name="Show item cooldown preview", description="Display a preview of the item cooldown indicator and text on all consumable items for configuration purposes")
    default public boolean showItemCooldownPreview() {
        return false;
    }

    @ConfigItem(position=1, keyName="cooldownTextMode", name="Mode", description="Mode used for the cooldown text that displays the duration a consumable item is on cooldown", section="itemCooldownText")
    default public CooldownTextMode cooldownTextMode() {
        return CooldownTextMode.GAME_TICKS;
    }

    @ConfigItem(position=2, keyName="textColor", name="Text color", description="Color of consumable item cooldown text", section="itemCooldownText")
    default public Color getTextColor() {
        return new Color(17, 255, 255);
    }

    @ConfigItem(position=3, keyName="textShadowColor", name="Text shadow color", description="Color of consumable item cooldown text shadow", section="itemCooldownText")
    default public Color getTextShadowColor() {
        return Color.BLACK;
    }

    @ConfigItem(position=4, keyName="fontType", name="Text font type", description="Font type used for consumable item cooldown text", section="itemCooldownText")
    default public FontType getFontType() {
        return FontType.BOLD;
    }

    @Range(min=-15, max=20)
    @ConfigItem(position=5, keyName="textXOffset", name="Text width offset", description="X-axis offset for consumable item cooldown text position. Default value is in the center of the item", section="itemCooldownText")
    default public int getTextXOffset() {
        return 3;
    }

    @Range(min=-15, max=15)
    @ConfigItem(position=6, keyName="textYOffset", name="Text height offset", description="Y-axis offset for consumable item cooldown text position. Default value is in the center of the item", section="itemCooldownText")
    default public int getTextYOffset() {
        return 0;
    }

    @ConfigItem(position=7, keyName="cooldownIndicatorMode", name="Mode", description="Indicator mode which should be used to display that a consumable item is on cooldown", section="itemCooldownIndicator")
    default public CooldownIndicatorMode getCooldownIndicatorMode() {
        return CooldownIndicatorMode.BOTTOM_TO_TOP;
    }

    @ConfigItem(position=8, keyName="itemCooldownIndicatorFillColor", name="Fill color", description="Color of item cooldown indicator fill", section="itemCooldownIndicator")
    default public Color getItemCooldownIndicatorFillColor() {
        return new Color(26, 26, 26);
    }

    @Range(max=100)
    @ConfigItem(position=9, keyName="itemCooldownIndicatorFillOpacity", name="Fill opacity", description="Opacity of item cooldown indicator fill color when on cooldown. From 0 to 100", section="itemCooldownIndicator")
    default public int getItemCooldownIndicatorFillOpacity() {
        return 80;
    }

    @ConfigItem(position=10, keyName="bottomToTopFullFillDuration", name="Full fill duration", description="The duration the cooldown indicator fill fully covers the item icon at the start of a cooldown. This can make the cooldown easier to notice. Only works when using the bottom to top cooldown indicator", section="itemBottomToTopCooldownIndicator")
    default public BottomToTopCooldownIndicatorStartDelay getBottomToTopFullFillDuration() {
        return BottomToTopCooldownIndicatorStartDelay.NORMAL;
    }
}

