/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.utilities;

import com.flippingutilities.model.OfferEvent;
import java.util.Date;
import net.runelite.api.GrandExchangeOfferState;

public class SlotState {
    public static final transient String DATE_FORMAT = "YYYY-MM-dd'T'HH:mm:ss.sssZ";
    private Boolean isBuyOffer;
    private Integer itemId;
    private Integer filledQty;
    private Date lastFilledTime;
    private int index;
    private String state;
    private Integer offerQty;
    private Integer offerPrice;
    private Integer filledPrice;
    private Date offerCreationTime;

    public static SlotState fromOfferEvent(OfferEvent offerEvent) {
        return new SlotState(offerEvent.isBuy(), offerEvent.getItemId(), offerEvent.getCurrentQuantityInTrade(), offerEvent.isBeforeLogin() ? null : Date.from(offerEvent.getTime()), offerEvent.getSlot(), SlotState.convertStateEnum(offerEvent.getState()), offerEvent.getTotalQuantityInTrade(), offerEvent.getListedPrice(), offerEvent.getSpent(), offerEvent.getTradeStartedAt() != null ? Date.from(offerEvent.getTradeStartedAt()) : null);
    }

    public static String convertStateEnum(GrandExchangeOfferState grandExchangeOfferState) {
        switch (grandExchangeOfferState) {
            case SOLD: 
            case BOUGHT: {
                return "FILLED";
            }
            case BUYING: 
            case SELLING: {
                return "ACTIVE";
            }
            case CANCELLED_BUY: 
            case CANCELLED_SELL: {
                return "CANCELLED";
            }
        }
        return "EMPTY";
    }

    public static SlotState createEmptySlot(int index) {
        SlotState emptySlot = new SlotState();
        emptySlot.index = index;
        return emptySlot;
    }

    public Boolean getIsBuyOffer() {
        return this.isBuyOffer;
    }

    public Integer getItemId() {
        return this.itemId;
    }

    public Integer getFilledQty() {
        return this.filledQty;
    }

    public Date getLastFilledTime() {
        return this.lastFilledTime;
    }

    public int getIndex() {
        return this.index;
    }

    public String getState() {
        return this.state;
    }

    public Integer getOfferQty() {
        return this.offerQty;
    }

    public Integer getOfferPrice() {
        return this.offerPrice;
    }

    public Integer getFilledPrice() {
        return this.filledPrice;
    }

    public Date getOfferCreationTime() {
        return this.offerCreationTime;
    }

    public void setIsBuyOffer(Boolean isBuyOffer) {
        this.isBuyOffer = isBuyOffer;
    }

    public void setItemId(Integer itemId) {
        this.itemId = itemId;
    }

    public void setFilledQty(Integer filledQty) {
        this.filledQty = filledQty;
    }

    public void setLastFilledTime(Date lastFilledTime) {
        this.lastFilledTime = lastFilledTime;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setOfferQty(Integer offerQty) {
        this.offerQty = offerQty;
    }

    public void setOfferPrice(Integer offerPrice) {
        this.offerPrice = offerPrice;
    }

    public void setFilledPrice(Integer filledPrice) {
        this.filledPrice = filledPrice;
    }

    public void setOfferCreationTime(Date offerCreationTime) {
        this.offerCreationTime = offerCreationTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlotState)) {
            return false;
        }
        SlotState other = (SlotState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isBuyOffer = this.getIsBuyOffer();
        Boolean other$isBuyOffer = other.getIsBuyOffer();
        if (this$isBuyOffer == null ? other$isBuyOffer != null : !((Object)this$isBuyOffer).equals(other$isBuyOffer)) {
            return false;
        }
        Integer this$itemId = this.getItemId();
        Integer other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !((Object)this$itemId).equals(other$itemId)) {
            return false;
        }
        Integer this$filledQty = this.getFilledQty();
        Integer other$filledQty = other.getFilledQty();
        if (this$filledQty == null ? other$filledQty != null : !((Object)this$filledQty).equals(other$filledQty)) {
            return false;
        }
        Date this$lastFilledTime = this.getLastFilledTime();
        Date other$lastFilledTime = other.getLastFilledTime();
        if (this$lastFilledTime == null ? other$lastFilledTime != null : !((Object)this$lastFilledTime).equals(other$lastFilledTime)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Integer this$offerQty = this.getOfferQty();
        Integer other$offerQty = other.getOfferQty();
        if (this$offerQty == null ? other$offerQty != null : !((Object)this$offerQty).equals(other$offerQty)) {
            return false;
        }
        Integer this$offerPrice = this.getOfferPrice();
        Integer other$offerPrice = other.getOfferPrice();
        if (this$offerPrice == null ? other$offerPrice != null : !((Object)this$offerPrice).equals(other$offerPrice)) {
            return false;
        }
        Integer this$filledPrice = this.getFilledPrice();
        Integer other$filledPrice = other.getFilledPrice();
        if (this$filledPrice == null ? other$filledPrice != null : !((Object)this$filledPrice).equals(other$filledPrice)) {
            return false;
        }
        Date this$offerCreationTime = this.getOfferCreationTime();
        Date other$offerCreationTime = other.getOfferCreationTime();
        return !(this$offerCreationTime == null ? other$offerCreationTime != null : !((Object)this$offerCreationTime).equals(other$offerCreationTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SlotState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isBuyOffer = this.getIsBuyOffer();
        result = result * 59 + ($isBuyOffer == null ? 43 : ((Object)$isBuyOffer).hashCode());
        Integer $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : ((Object)$itemId).hashCode());
        Integer $filledQty = this.getFilledQty();
        result = result * 59 + ($filledQty == null ? 43 : ((Object)$filledQty).hashCode());
        Date $lastFilledTime = this.getLastFilledTime();
        result = result * 59 + ($lastFilledTime == null ? 43 : ((Object)$lastFilledTime).hashCode());
        result = result * 59 + this.getIndex();
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Integer $offerQty = this.getOfferQty();
        result = result * 59 + ($offerQty == null ? 43 : ((Object)$offerQty).hashCode());
        Integer $offerPrice = this.getOfferPrice();
        result = result * 59 + ($offerPrice == null ? 43 : ((Object)$offerPrice).hashCode());
        Integer $filledPrice = this.getFilledPrice();
        result = result * 59 + ($filledPrice == null ? 43 : ((Object)$filledPrice).hashCode());
        Date $offerCreationTime = this.getOfferCreationTime();
        result = result * 59 + ($offerCreationTime == null ? 43 : ((Object)$offerCreationTime).hashCode());
        return result;
    }

    public String toString() {
        return "SlotState(isBuyOffer=" + this.getIsBuyOffer() + ", itemId=" + this.getItemId() + ", filledQty=" + this.getFilledQty() + ", lastFilledTime=" + this.getLastFilledTime() + ", index=" + this.getIndex() + ", state=" + this.getState() + ", offerQty=" + this.getOfferQty() + ", offerPrice=" + this.getOfferPrice() + ", filledPrice=" + this.getFilledPrice() + ", offerCreationTime=" + this.getOfferCreationTime() + ")";
    }

    public SlotState(Boolean isBuyOffer, Integer itemId, Integer filledQty, Date lastFilledTime, int index, String state, Integer offerQty, Integer offerPrice, Integer filledPrice, Date offerCreationTime) {
        this.isBuyOffer = isBuyOffer;
        this.itemId = itemId;
        this.filledQty = filledQty;
        this.lastFilledTime = lastFilledTime;
        this.index = index;
        this.state = state;
        this.offerQty = offerQty;
        this.offerPrice = offerPrice;
        this.filledPrice = filledPrice;
        this.offerCreationTime = offerCreationTime;
    }

    public SlotState() {
    }
}

