/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.utilities;

import com.flippingutilities.utilities.RecipeItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Recipe {
    List<RecipeItem> inputs;
    List<RecipeItem> outputs;
    String name;

    public Set<Integer> getIds() {
        HashSet<Integer> ids = new HashSet<Integer>();
        this.inputs.forEach(r -> ids.add(r.id));
        this.outputs.forEach(r -> ids.add(r.id));
        return ids;
    }

    public boolean isInRecipe(int itemId) {
        return this.getIds().contains(itemId);
    }

    public Map<Integer, Integer> getItemIdToQuantity() {
        HashMap<Integer, Integer> itemIdToQuantity = new HashMap<Integer, Integer>();
        this.inputs.forEach(r -> itemIdToQuantity.put(r.id, r.quantity));
        this.outputs.forEach(r -> itemIdToQuantity.put(r.id, r.quantity));
        return itemIdToQuantity;
    }

    public boolean isInput(int itemId) {
        return this.inputs.stream().anyMatch(ri -> ri.id == itemId);
    }

    public Set<Integer> getInputIds() {
        return this.inputs.stream().map(ri -> ri.id).collect(Collectors.toSet());
    }

    public Set<Integer> getOutputIds() {
        return this.outputs.stream().map(ri -> ri.id).collect(Collectors.toSet());
    }

    public List<RecipeItem> getInputs() {
        return this.inputs;
    }

    public List<RecipeItem> getOutputs() {
        return this.outputs;
    }

    public String getName() {
        return this.name;
    }

    public void setInputs(List<RecipeItem> inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(List<RecipeItem> outputs) {
        this.outputs = outputs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RecipeItem> this$inputs = this.getInputs();
        List<RecipeItem> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<RecipeItem> this$outputs = this.getOutputs();
        List<RecipeItem> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Recipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RecipeItem> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<RecipeItem> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "Recipe(inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", name=" + this.getName() + ")";
    }

    public Recipe(List<RecipeItem> inputs, List<RecipeItem> outputs, String name) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.name = name;
    }
}

