/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;

public class ListUtils {
    public static <T> List<T>[] partition(List<T> items, Predicate<T> ... conditions) {
        List[] subLists = new ArrayList[conditions.length];
        IntStream.range(0, subLists.length).forEach(i -> {
            subLists[i] = new ArrayList();
        });
        for (T item : items) {
            for (int i2 = 0; i2 < conditions.length; ++i2) {
                if (!conditions[i2].test(item)) continue;
                subLists[i2].add(item);
            }
        }
        return subLists;
    }

    public static <K, V, L> Map<K, V> toMap(List<L> values, Function<L, Pair<K, V>> keyValueFunction) {
        HashMap m = new HashMap();
        values.forEach(l -> {
            Pair pair = (Pair)keyValueFunction.apply(l);
            m.put(pair.getKey(), pair.getValue());
        });
        return m;
    }
}

