/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.utilities;

import com.flippingutilities.utilities.JwtHeader;
import com.flippingutilities.utilities.JwtPayload;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;

public class Jwt {
    JwtHeader header;
    JwtPayload payload;
    String signature;

    public static Jwt fromString(String jwtString, Gson gson) throws JsonSyntaxException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        String[] parts = jwtString.split("\\.");
        String jwtHeaderString = new String(Base64.getDecoder().decode(parts[0]));
        String jwtPayloadString = new String(Base64.getDecoder().decode(parts[1]));
        JwtHeader jwtHeader = (JwtHeader)gson.fromJson(jwtHeaderString, JwtHeader.class);
        JwtPayload jwtPayload = (JwtPayload)gson.fromJson(jwtPayloadString, JwtPayload.class);
        String signature = parts[2];
        return new Jwt(jwtHeader, jwtPayload, signature);
    }

    public boolean isExpired() {
        return this.payload.exp <= Instant.now().getEpochSecond();
    }

    public boolean shouldRefresh() {
        return this.payload.exp <= Instant.now().plus(10L, ChronoUnit.DAYS).getEpochSecond();
    }

    public Jwt(JwtHeader header, JwtPayload payload, String signature) {
        this.header = header;
        this.payload = payload;
        this.signature = signature;
    }

    public JwtHeader getHeader() {
        return this.header;
    }

    public JwtPayload getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setHeader(JwtHeader header) {
        this.header = header;
    }

    public void setPayload(JwtPayload payload) {
        this.payload = payload;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jwt)) {
            return false;
        }
        Jwt other = (Jwt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JwtHeader this$header = this.getHeader();
        JwtHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        JwtPayload this$payload = this.getPayload();
        JwtPayload other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Jwt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JwtHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        JwtPayload $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    public String toString() {
        return "Jwt(header=" + this.getHeader() + ", payload=" + this.getPayload() + ", signature=" + this.getSignature() + ")";
    }
}

