/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.utilities;

import com.flippingutilities.model.OfferEvent;
import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeHistoryTabExtractor {
    private static final Logger log = LoggerFactory.getLogger(GeHistoryTabExtractor.class);
    private static Pattern MULTI_ITEM_PATTERN = Pattern.compile(">= (.*) each");
    private static Pattern SINGLE_ITEM_PATTERN = Pattern.compile(">(.*) coin");
    private static Pattern ORIGINAL_PRICE_PATTERN = Pattern.compile("\\((.*) -");

    public static List<OfferEvent> convertWidgetsToOfferEvents(Widget[] widgets) {
        List groupsOfWidgets = Lists.partition(Arrays.asList(widgets), (int)6);
        return groupsOfWidgets.stream().map(w -> GeHistoryTabExtractor.createOfferEventFromWidgetGroup(w)).collect(Collectors.toList());
    }

    public static OfferEvent createOfferEventFromWidgetGroup(List<Widget> widgets) {
        int slot = -1;
        GrandExchangeOfferState offerState = GeHistoryTabExtractor.getState(widgets.get(2));
        int quantity = widgets.get(4).getItemQuantity();
        int itemId = widgets.get(4).getItemId();
        int price = GeHistoryTabExtractor.getPrice(widgets.get(5), quantity);
        boolean isBuy = offerState == GrandExchangeOfferState.BOUGHT;
        Instant time = Instant.now();
        int totalQuantity = quantity;
        int tickArrivedAt = -1;
        int ticksSinceFirstOffer = 10;
        OfferEvent offerEvent = new OfferEvent(UUID.randomUUID().toString(), isBuy, itemId, quantity, price, time, slot, offerState, tickArrivedAt, ticksSinceFirstOffer, totalQuantity, null, false, null, null, 0, 0);
        return offerEvent;
    }

    private static int getPrice(Widget w, int quantity) {
        Matcher m;
        String text;
        String numString = text = w.getText();
        boolean isTotalPrice = false;
        if (text.contains(")</col>")) {
            m = ORIGINAL_PRICE_PATTERN.matcher(text);
            isTotalPrice = true;
        } else {
            m = text.contains("each") ? MULTI_ITEM_PATTERN.matcher(text) : SINGLE_ITEM_PATTERN.matcher(text);
        }
        m.find();
        numString = m.group(1);
        StringBuilder s = new StringBuilder();
        for (char c : numString.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            s.append(c);
        }
        int price = Integer.parseInt(s.toString());
        if (isTotalPrice) {
            return price / quantity;
        }
        return price;
    }

    private static GrandExchangeOfferState getState(Widget w) {
        String text = w.getText();
        if (text.startsWith("Bought")) {
            return GrandExchangeOfferState.BOUGHT;
        }
        return GrandExchangeOfferState.SOLD;
    }
}

