/*
 * Decompiled with CFR 0.152.
 */
package com.flippingutilities.ui.widgets;

import com.flippingutilities.controller.FlippingPlugin;
import com.flippingutilities.ui.uiutilities.GeSpriteLoader;
import com.flippingutilities.ui.uiutilities.QuickLookPanel;
import com.flippingutilities.utilities.SlotInfo;
import com.flippingutilities.utilities.SlotPredictedState;
import com.flippingutilities.utilities.WikiItemMargins;
import com.flippingutilities.utilities.WikiRequest;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.runelite.api.GrandExchangeOffer;
import net.runelite.api.GrandExchangeOfferState;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotStateDrawer {
    private static final Logger log = LoggerFactory.getLogger(SlotStateDrawer.class);
    FlippingPlugin plugin;
    WikiRequest wikiRequest;
    Widget[] slotWidgets;
    Map<Integer, Widget> slotIdxToQuickLookWidget = new HashMap<Integer, Widget>();
    JPopupMenu popup = new JPopupMenu();
    QuickLookPanel quickLookPanel = new QuickLookPanel();
    List<Optional<SlotInfo>> slotInfos = new ArrayList<Optional<SlotInfo>>();

    public SlotStateDrawer(FlippingPlugin plugin) {
        this.plugin = plugin;
        this.popup.add(this.quickLookPanel);
    }

    public void onWikiRequest(WikiRequest wikiRequest) {
        this.wikiRequest = wikiRequest;
        this.drawWrapper();
    }

    public void setSlotWidgets(Widget[] slotWidgets) {
        if (slotWidgets == null) {
            return;
        }
        this.slotWidgets = slotWidgets;
        this.drawWrapper();
    }

    public void hideQuickLookPanel() {
        this.popup.setVisible(false);
    }

    public void drawWrapper() {
        if (this.slotWidgets == null || this.plugin.getCurrentlyLoggedInAccount() == null || !this.plugin.getApiAuthHandler().isPremium() || !this.plugin.shouldEnhanceSlots()) {
            return;
        }
        this.slotInfos = this.createSlotRepresentation();
        this.plugin.getClientThread().invokeLater(() -> this.draw(this.slotInfos));
    }

    private void draw(List<Optional<SlotInfo>> slots) {
        for (int i = 0; i < slots.size(); ++i) {
            Optional<SlotInfo> slot = slots.get(i);
            Widget slotWidget = this.slotWidgets[i + 1];
            if (!slot.isPresent()) {
                this.resetSlot(i, slotWidget);
                continue;
            }
            this.drawOnSlot(slot.get(), slotWidget);
        }
    }

    public void resetAllSlots() {
        if (this.slotWidgets == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Widget slotWidget = this.slotWidgets[i + 1];
            this.resetSlot(i, slotWidget);
        }
    }

    private void resetSlot(int slotIdx, Widget slotWidget) {
        Map<Integer, Integer> spriteIdMap = GeSpriteLoader.CHILDREN_IDX_TO_DEFAULT_SPRITE_ID;
        GeSpriteLoader.DYNAMIC_CHILDREN_IDXS.forEach(idx -> {
            Widget child = slotWidget.getChild(idx.intValue());
            int spriteId = (Integer)spriteIdMap.get(idx);
            child.setSpriteId(spriteId);
        });
        Widget quickLookWidget = this.slotIdxToQuickLookWidget.get(slotIdx);
        if (quickLookWidget != null) {
            quickLookWidget.setHidden(true);
            this.slotIdxToQuickLookWidget.remove(slotIdx);
        }
    }

    private void drawOnSlot(SlotInfo slot, Widget slotWidget) {
        if (slotWidget.isHidden()) {
            return;
        }
        Map<Integer, Integer> spriteMap = GeSpriteLoader.CHILDREN_IDX_TO_RED_SPRITE_ID;
        if (slot.getPredictedState() == SlotPredictedState.IN_RANGE) {
            spriteMap = GeSpriteLoader.CHILDREN_IDX_TO_BLUE_SPRITE_ID;
        } else if (slot.getPredictedState() == SlotPredictedState.OUT_OF_RANGE) {
            spriteMap = GeSpriteLoader.CHILDREN_IDX_TO_RED_SPRITE_ID;
        } else if (slot.getPredictedState() == SlotPredictedState.BETTER_THAN_WIKI) {
            spriteMap = GeSpriteLoader.CHILDREN_IDX_TO_GREEN_SPRITE_ID;
        }
        Map<Integer, Integer> finalSpriteMap = spriteMap;
        GeSpriteLoader.DYNAMIC_CHILDREN_IDXS.forEach(idx -> {
            Widget child = slotWidget.getChild(idx.intValue());
            int spriteId = (Integer)finalSpriteMap.get(idx);
            child.setSpriteId(spriteId);
        });
        this.addQuicklookWidget(slotWidget, slot);
    }

    private void addQuicklookWidget(Widget slotWidget, SlotInfo slot) {
        Widget existingQuickLookWidget = this.slotIdxToQuickLookWidget.get(slot.getIndex());
        if (existingQuickLookWidget == null || !this.isWidgetStillAttached(existingQuickLookWidget)) {
            Widget quicklookWidget = this.createQuicklookWidget(slotWidget, slot);
            this.slotIdxToQuickLookWidget.put(slot.getIndex(), quicklookWidget);
        } else {
            existingQuickLookWidget.setHidden(false);
        }
    }

    private Widget createQuicklookWidget(Widget slotWidget, SlotInfo slot) {
        Widget quickLookWidget = slotWidget.createChild(-1, 5);
        quickLookWidget.setFontId(494);
        quickLookWidget.setYPositionMode(0);
        quickLookWidget.setOriginalX(90);
        quickLookWidget.setOriginalY(52);
        quickLookWidget.setSpriteId(1043);
        quickLookWidget.setWidthMode(0);
        quickLookWidget.setOriginalHeight(22);
        quickLookWidget.setOriginalWidth(22);
        quickLookWidget.setXPositionMode(0);
        quickLookWidget.setXTextAlignment(0);
        quickLookWidget.setTextShadowed(true);
        quickLookWidget.setHasListener(true);
        quickLookWidget.setOnMouseOverListener(new Object[]{ev -> SwingUtilities.invokeLater(() -> {
            if (this.wikiRequest == null) {
                this.quickLookPanel.updateDetails(null, null);
                return;
            }
            Optional<SlotInfo> slotInfo = this.slotInfos.get(slot.getIndex());
            if (!slotInfo.isPresent()) {
                this.quickLookPanel.updateDetails(null, null);
                return;
            }
            int itemId = slotInfo.get().getItemId();
            WikiItemMargins margins = this.wikiRequest.getData().get(itemId);
            PointerInfo a = MouseInfo.getPointerInfo();
            Point p = a.getLocation();
            this.quickLookPanel.updateDetails(slotInfo.get(), margins);
            this.popup.pack();
            this.popup.setLocation(p.x + 25, p.y);
            this.popup.setVisible(true);
        })});
        quickLookWidget.setOnMouseLeaveListener(new Object[]{ev -> SwingUtilities.invokeLater(() -> this.popup.setVisible(false))});
        quickLookWidget.revalidate();
        return quickLookWidget;
    }

    private boolean isWidgetStillAttached(Widget widget) {
        Widget parent = widget.getParent();
        Widget[] siblings = parent.getDynamicChildren();
        return widget.getIndex() < siblings.length && siblings[widget.getIndex()] != null;
    }

    private List<Optional<SlotInfo>> createSlotRepresentation() {
        ArrayList<Optional<SlotInfo>> slots = new ArrayList<Optional<SlotInfo>>();
        GrandExchangeOffer[] currentOffers = this.plugin.getClient().getGrandExchangeOffers();
        for (int i = 0; i < currentOffers.length; ++i) {
            GrandExchangeOffer localSlot = currentOffers[i];
            if (localSlot.getState() == GrandExchangeOfferState.EMPTY) {
                slots.add(Optional.empty());
                continue;
            }
            slots.add(this.clientGeOfferToSlotInfo(i, localSlot));
        }
        return slots;
    }

    private Optional<SlotInfo> clientGeOfferToSlotInfo(int index, GrandExchangeOffer offer) {
        if (this.wikiRequest == null) {
            return Optional.empty();
        }
        int itemId = offer.getItemId();
        WikiItemMargins margins = this.wikiRequest.getData().get(itemId);
        if (margins == null) {
            return Optional.empty();
        }
        int listedPrice = offer.getPrice();
        boolean isBuy = offer.getState() == GrandExchangeOfferState.BUYING;
        SlotPredictedState predictedState = SlotPredictedState.getPredictedState(isBuy, listedPrice, margins.getLow(), margins.getHigh());
        return Optional.of(new SlotInfo(index, predictedState, itemId, listedPrice, isBuy));
    }
}

